/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.editor;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IDirectEditingInfo;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.internal.pref.GFPreferences;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.editor.RefreshPerformanceCache;
import org.eclipse.graphiti.ui.internal.parts.IAnchorContainerEditPart;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementEditPart;
import org.eclipse.graphiti.ui.internal.parts.ShapeEditPart;
import org.eclipse.swt.widgets.Display;

public class DefaultRefreshBehavior {
    protected final DiagramBehavior diagramBehavior;
    private RefreshPerformanceCache refreshPerformanceCache = new RefreshPerformanceCache();

    public DefaultRefreshBehavior(DiagramBehavior diagramBehavior) {
        this.diagramBehavior = diagramBehavior;
    }

    public void initRefresh() {
        this.getRefreshPerformanceCache().initRefresh();
    }

    public void handleAutoUpdateAtStartup() {
        IDiagramTypeProvider diagramTypeProvider = this.diagramBehavior.getDiagramTypeProvider();
        if (diagramTypeProvider.isAutoUpdateAtStartup()) {
            this.autoUpdate();
        }
    }

    public void handleAutoUpdateAtReset() {
        IDiagramTypeProvider diagramTypeProvider = this.diagramBehavior.getDiagramTypeProvider();
        if (diagramTypeProvider.isAutoUpdateAtReset()) {
            this.autoUpdate();
        }
    }

    protected void autoUpdate() {
        IDiagramTypeProvider diagramTypeProvider = this.diagramBehavior.getDiagramTypeProvider();
        Diagram diagram = diagramTypeProvider.getDiagram();
        IFeatureProvider featureProvider = diagramTypeProvider.getFeatureProvider();
        UpdateContext updateCtx = new UpdateContext((PictogramElement)diagram);
        featureProvider.updateIfPossible((IUpdateContext)updateCtx);
        this.refresh();
    }

    public void refresh() {
        EditPart editPart;
        IDirectEditingInfo dei;
        if (!this.diagramBehavior.isAlive()) {
            return;
        }
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DefaultRefreshBehavior.this.refresh();
                }
            });
            return;
        }
        if (GFPreferences.getInstance().isCPUProfilingTraceActive() && T.racer().info()) {
            T.racer().info("DiagramEditorInternal.refresh()");
        }
        long start = System.currentTimeMillis();
        EditPart contentEditPart = this.diagramBehavior.getContentEditPart();
        if (contentEditPart == null) {
            return;
        }
        this.internalRefreshEditPart(contentEditPart);
        this.diagramBehavior.getDiagramContainer().refreshTitle();
        long stop = System.currentTimeMillis();
        long time = stop - start;
        if (time > 500L) {
            String output = "refresh took " + time + " ms.";
            T.racer().warning("DiagramEditorInternal.refresh() ", output);
        }
        if ((dei = this.diagramBehavior.getConfigurationProvider().getFeatureProvider().getDirectEditingInfo()).isActive() && (editPart = (EditPart)this.diagramBehavior.getDiagramContainer().getGraphicalViewer().getEditPartRegistry().get(dei.getMainPictogramElement())) instanceof ShapeEditPart) {
            ShapeEditPart shapeEditPart = (ShapeEditPart)editPart;
            shapeEditPart.switchToDirectEditingMode(dei.getPictogramElement(), dei.getGraphicsAlgorithm());
            dei.reset();
        }
        this.diagramBehavior.selectBufferedPictogramElements();
    }

    protected void refresh(PictogramElement pe) {
        if (pe == null || !pe.isActive()) {
            return;
        }
        GraphicalEditPart editPart = this.diagramBehavior.getEditPartForPictogramElement(pe);
        if (editPart != null && editPart instanceof IPictogramElementEditPart) {
            IPictogramElementEditPart ep = (IPictogramElementEditPart)editPart;
            IPictogramElementDelegate delegate = ep.getPictogramElementDelegate();
            delegate.setForceRefresh(true);
            editPart.refresh();
            delegate.setForceRefresh(false);
        }
    }

    public void refreshRenderingDecorators(PictogramElement pe) {
        GraphicalEditPart ep = this.diagramBehavior.getEditPartForPictogramElement(pe);
        if (ep instanceof IAnchorContainerEditPart) {
            IAnchorContainerEditPart acep = (IAnchorContainerEditPart)ep;
            acep.refreshDecorators();
        }
    }

    public void internalRefreshEditPart(final EditPart editPart) {
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    DefaultRefreshBehavior.this.internalRefreshEditPart(editPart);
                }
            });
            return;
        }
        long start = System.currentTimeMillis();
        try {
            ((IConfigurationProviderInternal)this.diagramBehavior.getConfigurationProvider()).getContextButtonManager().hideContextButtonsInstantly();
            editPart.refresh();
            long stop = System.currentTimeMillis();
            long time = stop - start;
            if (time > 500L) {
                String output = "refreshEditPart took " + time + " ms.";
                T.racer().warning("DiagramEditorInternal.refreshEditPart() ", output);
            }
        }
        catch (NullPointerException e) {
            T.racer().error("refresh edit part problem", (Throwable)e);
        }
    }

    public boolean isAutoRefresh() {
        return true;
    }

    public boolean isMultipleRefreshSupressionActive() {
        return true;
    }

    public boolean shouldRefresh(Object obj) {
        return this.getRefreshPerformanceCache().shouldRefresh(obj);
    }

    private RefreshPerformanceCache getRefreshPerformanceCache() {
        return this.refreshPerformanceCache;
    }
}

