/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import org.apache.directory.studio.connection.core.Connection;
import org.eclipse.ui.IActionFilter;

public class ConnectionActionFilterAdapter
implements IActionFilter {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String ENCRYPTION_METHOD = "encryptionMethod";
    private static final String NETWORK_PROVIDER = "networkProvider";
    private static final String AUTH_METHOD = "authMethod";
    private static final String BIND_PRINCIPAL = "bindPrincipal";
    private static final String BIND_PASSWORD = "bindPassword";
    private static final String SASL_REALM = "saslRealm";
    private static final String SASL_QOP = "saslQop";
    private static final String SASL_SECURITY_STRENGTH = "saslSecurityStrength";
    private static final String SASL_MUTUAL_AUTHENTICATION = "saslMutualAuthentication";
    private static final String KRB5_CREDENTIAL_CONFIGURATION = "krb5CredentialConfiguration";
    private static final String KRB5_CONFIGURATION = "krb5Configuration";
    private static final String KRB5_CONFIGURATION_FILE = "krb5ConfigurationFile";
    private static final String KRB5_REALM = "krb5Realm";
    private static final String KRB5_KDC_HOST = "krb5KdcHost";
    private static final String KRB5_KDC_PORT = "krb5KdcPort";
    private static final String VENDOR_NAME = "vendorName";
    private static final String VENDOR_VERSION = "vendorVersion";
    private static final String SERVER_TYPE = "serverType";
    private static final String SUPPORTED_LDAP_VERSIONS = "supportedLdapVersions";
    private static final String SUPPORTED_CONTROLS = "supportedControls";
    private static final String SUPPORTED_EXTENSIONS = "supportedExtensions";
    private static final String SUPPORTED_FEATURES = "supportedFeatures";
    private static ConnectionActionFilterAdapter INSTANCE = new ConnectionActionFilterAdapter();

    private ConnectionActionFilterAdapter() {
    }

    public static ConnectionActionFilterAdapter getInstance() {
        return INSTANCE;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof Connection) {
            Connection connection = (Connection)target;
            if (ID.equals(name)) {
                return value.equals(connection.getId());
            }
            if (NAME.equals(name)) {
                return value.equals(connection.getName());
            }
            if (HOST.equals(name)) {
                return value.equals(connection.getHost());
            }
            if (PORT.equals(name)) {
                return value.equals("" + connection.getPort());
            }
            if (ENCRYPTION_METHOD.equals(name)) {
                return value.equals(connection.getEncryptionMethod().toString());
            }
            if (NETWORK_PROVIDER.equals(name)) {
                return value.equals(connection.getNetworkProvider().toString());
            }
            if (AUTH_METHOD.equals(name)) {
                return value.equals(connection.getAuthMethod().toString());
            }
            if (BIND_PRINCIPAL.equals(name)) {
                return value.equals(connection.getBindPrincipal());
            }
            if (BIND_PASSWORD.equals(name)) {
                return value.equals(connection.getBindPassword());
            }
            if (SASL_REALM.equals(name)) {
                return value.equals(connection.getSaslRealm());
            }
            if (SASL_QOP.equals(name)) {
                return value.equals(connection.getSaslQop().toString());
            }
            if (SASL_SECURITY_STRENGTH.equals(name)) {
                return value.equals(connection.getSaslSecurityStrength().toString());
            }
            if (SASL_MUTUAL_AUTHENTICATION.equals(name)) {
                return value.equals(connection.isSaslMutualAuthentication() ? "true" : "false");
            }
            if (KRB5_CREDENTIAL_CONFIGURATION.equals(name)) {
                return value.equals(connection.getKrb5CredentialConfiguration().toString());
            }
            if (KRB5_CONFIGURATION.equals(name)) {
                return value.equals(connection.getKrb5Configuration().toString());
            }
            if (KRB5_CONFIGURATION_FILE.equals(name)) {
                return value.equals(connection.getKrb5ConfigurationFile());
            }
            if (KRB5_REALM.equals(name)) {
                return value.equals(connection.getKrb5Realm());
            }
            if (KRB5_KDC_HOST.equals(name)) {
                return value.equals(connection.getKrb5KdcHost());
            }
            if (KRB5_KDC_PORT.equals(name)) {
                return value.equals("" + connection.getKrb5KdcPort());
            }
            if (VENDOR_NAME.equals(name)) {
                return value.equals(connection.getDetectedConnectionProperties().getVendorName());
            }
            if (VENDOR_VERSION.equals(name)) {
                if (connection.getDetectedConnectionProperties().getVendorVersion() != null) {
                    return connection.getDetectedConnectionProperties().getVendorVersion().indexOf(value) != -1;
                }
            } else {
                if (SERVER_TYPE.equals(name)) {
                    return value.equals(connection.getDetectedConnectionProperties().getServerType().toString());
                }
                if (SUPPORTED_LDAP_VERSIONS.equals(name)) {
                    connection.getDetectedConnectionProperties().getSupportedLdapVersions().contains(value);
                } else if (SUPPORTED_CONTROLS.equals(name)) {
                    connection.getDetectedConnectionProperties().getSupportedControls().contains(value);
                } else if (SUPPORTED_EXTENSIONS.equals(name)) {
                    connection.getDetectedConnectionProperties().getSupportedExtensions().contains(value);
                } else if (SUPPORTED_FEATURES.equals(name)) {
                    connection.getDetectedConnectionProperties().getSupportedFeatures().contains(value);
                }
            }
        }
        return false;
    }
}

