/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import java.io.Serializable;
import org.apache.directory.studio.ldifparser.model.lines.LdifControlLine;

public class StudioControl
implements Serializable {
    private static final long serialVersionUID = -1289018814649849178L;
    public static final StudioControl SUBENTRIES_CONTROL = new StudioControl("Subentries", "1.3.6.1.4.1.4203.1.10.1", false, new byte[]{1, 1, -1});
    public static final StudioControl MANAGEDSAIT_CONTROL = new StudioControl("Manage DSA IT", "2.16.840.1.113730.3.4.2", false, null);
    public static final StudioControl TREEDELETE_CONTROL = new StudioControl("Tree Delete", "1.2.840.113556.1.4.805", false, null);
    protected String name;
    protected String oid;
    protected boolean critical;
    protected byte[] controlValue;

    public StudioControl() {
    }

    public StudioControl(String name, String oid, boolean critical, byte[] controlValue) {
        this.name = name == null ? "" : name;
        this.oid = oid;
        this.critical = critical;
        this.controlValue = controlValue;
    }

    public byte[] getControlValue() {
        return this.controlValue;
    }

    public String getOid() {
        return this.oid;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        if (this.oid == null) {
            return "";
        }
        LdifControlLine line = LdifControlLine.create((String)this.getOid(), (boolean)this.isCritical(), (byte[])this.getControlValue());
        String s = line.toRawString();
        s = s.substring(line.getRawControlSpec().length(), s.length());
        s = s.substring(line.getRawControlType().length(), s.length());
        s = s.substring(0, s.length() - line.getRawNewLine().length());
        return s;
    }

    public void setControlValue(byte[] controlValue) {
        this.controlValue = controlValue;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.toString().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof StudioControl)) {
            return false;
        }
        StudioControl other = (StudioControl)obj;
        return this.toString().equals(other.toString());
    }
}

