/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.io.api;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.naming.ContextNotEmptyException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.codec.api.BinaryAttributeDetector;
import org.apache.directory.api.ldap.codec.api.DefaultConfigurableBinaryAttributeDetector;
import org.apache.directory.api.ldap.codec.protocol.mina.LdapProtocolCodecActivator;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.AttributeUtils;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.FilterParser;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AddRequestImpl;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindRequestImpl;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.DeleteRequest;
import org.apache.directory.api.ldap.model.message.DeleteRequestImpl;
import org.apache.directory.api.ldap.model.message.DeleteResponse;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyDnRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyDnResponse;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.ldap.client.api.SaslCramMd5Request;
import org.apache.directory.ldap.client.api.SaslDigestMd5Request;
import org.apache.directory.ldap.client.api.SaslGssApiRequest;
import org.apache.directory.ldap.client.api.exception.InvalidConnectionException;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.IAuthHandler;
import org.apache.directory.studio.connection.core.ICredentials;
import org.apache.directory.studio.connection.core.IJndiLogger;
import org.apache.directory.studio.connection.core.Messages;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.core.io.ConnectionWrapper;
import org.apache.directory.studio.connection.core.io.StudioNamingEnumeration;
import org.apache.directory.studio.connection.core.io.StudioTrustManager;
import org.apache.directory.studio.connection.core.io.api.CursorStudioNamingEnumeration;
import org.apache.directory.studio.connection.core.io.jndi.CancelException;
import org.apache.directory.studio.connection.core.io.jndi.ReferralsInfo;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.osgi.util.NLS;

public class DirectoryApiConnectionWrapper
implements ConnectionWrapper {
    private static int SEARCH_RESQUEST_NUM = 0;
    private Connection connection;
    private LdapConnectionConfig ldapConnectionConfig;
    private LdapNetworkConnection ldapConnection;
    private DefaultConfigurableBinaryAttributeDetector binaryAttributeDetector;
    private boolean isConnected = false;
    private Thread jobThread;
    private String bindPrincipal;
    private String bindPassword;

    public DirectoryApiConnectionWrapper(Connection connection) {
        this.connection = connection;
        LdapProtocolCodecActivator.lazyStart();
    }

    @Override
    public void connect(StudioProgressMonitor monitor) {
        this.ldapConnection = null;
        this.isConnected = false;
        this.jobThread = null;
        try {
            this.doConnect(monitor);
        }
        catch (Exception e) {
            this.disconnect();
            monitor.reportError(e);
        }
    }

    private void doConnect(StudioProgressMonitor monitor) throws Exception {
        this.ldapConnection = null;
        this.isConnected = true;
        this.ldapConnectionConfig = new LdapConnectionConfig();
        this.ldapConnectionConfig.setLdapHost(this.connection.getHost());
        this.ldapConnectionConfig.setLdapPort(this.connection.getPort());
        this.binaryAttributeDetector = new DefaultConfigurableBinaryAttributeDetector();
        this.ldapConnectionConfig.setBinaryAttributeDetector((BinaryAttributeDetector)this.binaryAttributeDetector);
        if (this.connection.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.LDAPS || this.connection.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.START_TLS) {
            this.ldapConnectionConfig.setUseSsl(this.connection.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.LDAPS);
            this.ldapConnectionConfig.setUseTls(this.connection.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.START_TLS);
            try {
                TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                factory.init((KeyStore)null);
                TrustManager[] defaultTrustManagers = factory.getTrustManagers();
                TrustManager[] trustManagers = new StudioTrustManager[defaultTrustManagers.length];
                int i = 0;
                while (i < defaultTrustManagers.length) {
                    trustManagers[i] = new StudioTrustManager((X509TrustManager)defaultTrustManagers[i]);
                    ((StudioTrustManager)trustManagers[i]).setHost(this.connection.getHost());
                    ++i;
                }
                this.ldapConnectionConfig.setTrustManagers(trustManagers);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        InnerRunnable runnable = new InnerRunnable(this){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    ldapConnection = new LdapNetworkConnection(ldapConnectionConfig);
                    boolean connected = ldapConnection.connect();
                    if (connected) return;
                    throw new Exception(Messages.DirectoryApiConnectionWrapper_UnableToConnect);
                }
                catch (Exception e) {
                    this.exception = e;
                    try {
                        try {
                            if (ldapConnection != null) {
                                ldapConnection.close();
                            }
                        }
                        catch (Exception exception) {
                            ldapConnection = null;
                            binaryAttributeDetector = null;
                            return;
                        }
                    }
                    finally {
                        ldapConnection = null;
                        binaryAttributeDetector = null;
                    }
                }
            }
        };
        this.runAndMonitor(runnable, monitor);
        if (runnable.getException() != null) {
            throw runnable.getException();
        }
    }

    @Override
    public void disconnect() {
        if (this.jobThread != null) {
            Thread t = this.jobThread;
            this.jobThread = null;
            t.interrupt();
        }
        if (this.ldapConnection != null) {
            try {
                this.ldapConnection.close();
            }
            catch (Exception exception) {}
            this.ldapConnection = null;
            this.binaryAttributeDetector = null;
        }
        this.isConnected = false;
    }

    @Override
    public void bind(StudioProgressMonitor monitor) {
        try {
            this.doBind(monitor);
        }
        catch (Exception e) {
            this.disconnect();
            monitor.reportError(e);
        }
    }

    private void doBind(final StudioProgressMonitor monitor) throws Exception {
        if (this.ldapConnection != null && this.isConnected) {
            InnerRunnable runnable = new InnerRunnable(this){

                @Override
                public void run() {
                    try {
                        BindResponse bindResponse = null;
                        if (connection.getConnectionParameter().getAuthMethod() == ConnectionParameter.AuthenticationMethod.NONE) {
                            BindRequestImpl bindRequest = new BindRequestImpl();
                            bindResponse = ldapConnection.bind((BindRequest)bindRequest);
                        } else {
                            IAuthHandler authHandler = ConnectionCorePlugin.getDefault().getAuthHandler();
                            if (authHandler == null) {
                                Exception exception = new Exception(Messages.model__no_auth_handler);
                                monitor.setCanceled(true);
                                monitor.reportError(Messages.model__no_auth_handler, exception);
                                throw exception;
                            }
                            ICredentials credentials = authHandler.getCredentials(connection.getConnectionParameter());
                            if (credentials == null) {
                                Exception exception = new Exception();
                                monitor.setCanceled(true);
                                monitor.reportError(Messages.model__no_credentials, exception);
                                throw exception;
                            }
                            if (credentials.getBindPrincipal() == null || credentials.getBindPassword() == null) {
                                Exception exception = new Exception(Messages.model__no_credentials);
                                monitor.reportError(Messages.model__no_credentials, exception);
                                throw exception;
                            }
                            bindPrincipal = credentials.getBindPrincipal();
                            bindPassword = credentials.getBindPassword();
                            if (connection.getConnectionParameter().getAuthMethod() == ConnectionParameter.AuthenticationMethod.SIMPLE) {
                                BindRequestImpl bindRequest = new BindRequestImpl();
                                bindRequest.setName(bindPrincipal);
                                bindRequest.setCredentials(bindPassword);
                                bindResponse = ldapConnection.bind((BindRequest)bindRequest);
                            } else if (connection.getConnectionParameter().getAuthMethod() == ConnectionParameter.AuthenticationMethod.SASL_CRAM_MD5) {
                                SaslCramMd5Request cramMd5Request = new SaslCramMd5Request();
                                cramMd5Request.setUsername(bindPrincipal);
                                cramMd5Request.setCredentials(bindPassword);
                                cramMd5Request.setQualityOfProtection(connection.getConnectionParameter().getSaslQop());
                                cramMd5Request.setSecurityStrength(connection.getConnectionParameter().getSaslSecurityStrength());
                                cramMd5Request.setMutualAuthentication(connection.getConnectionParameter().isSaslMutualAuthentication());
                                bindResponse = ldapConnection.bind(cramMd5Request);
                            } else if (connection.getConnectionParameter().getAuthMethod() == ConnectionParameter.AuthenticationMethod.SASL_DIGEST_MD5) {
                                SaslDigestMd5Request digestMd5Request = new SaslDigestMd5Request();
                                digestMd5Request.setUsername(bindPrincipal);
                                digestMd5Request.setCredentials(bindPassword);
                                digestMd5Request.setRealmName(connection.getConnectionParameter().getSaslRealm());
                                digestMd5Request.setQualityOfProtection(connection.getConnectionParameter().getSaslQop());
                                digestMd5Request.setSecurityStrength(connection.getConnectionParameter().getSaslSecurityStrength());
                                digestMd5Request.setMutualAuthentication(connection.getConnectionParameter().isSaslMutualAuthentication());
                                bindResponse = ldapConnection.bind(digestMd5Request);
                            } else if (connection.getConnectionParameter().getAuthMethod() == ConnectionParameter.AuthenticationMethod.SASL_GSSAPI) {
                                SaslGssApiRequest gssApiRequest = new SaslGssApiRequest();
                                Preferences preferences = ConnectionCorePlugin.getDefault().getPluginPreferences();
                                boolean useKrb5SystemProperties = preferences.getBoolean("useKrb5SystemProperties");
                                String krb5LoginModule = preferences.getString("krb5LoginModule");
                                if (!useKrb5SystemProperties) {
                                    gssApiRequest.setUsername(bindPrincipal);
                                    gssApiRequest.setCredentials(bindPassword);
                                    gssApiRequest.setQualityOfProtection(connection.getConnectionParameter().getSaslQop());
                                    gssApiRequest.setSecurityStrength(connection.getConnectionParameter().getSaslSecurityStrength());
                                    gssApiRequest.setMutualAuthentication(connection.getConnectionParameter().isSaslMutualAuthentication());
                                    gssApiRequest.setLoginModuleConfiguration((Configuration)new InnerConfiguration(krb5LoginModule));
                                    switch (connection.getConnectionParameter().getKrb5Configuration()) {
                                        case FILE: {
                                            gssApiRequest.setKrb5ConfFilePath(connection.getConnectionParameter().getKrb5ConfigurationFile());
                                            break;
                                        }
                                        case MANUAL: {
                                            gssApiRequest.setRealmName(connection.getConnectionParameter().getKrb5Realm());
                                            gssApiRequest.setKdcHost(connection.getConnectionParameter().getKrb5KdcHost());
                                            gssApiRequest.setKdcPort(connection.getConnectionParameter().getKrb5KdcPort());
                                            break;
                                        }
                                    }
                                }
                                bindResponse = ldapConnection.bind(gssApiRequest);
                            }
                        }
                        this.checkResponse((ResultResponse)bindResponse);
                    }
                    catch (Exception e) {
                        this.exception = e;
                    }
                }
            };
            this.runAndMonitor(runnable, monitor);
            if (runnable.getException() != null) {
                throw runnable.getException();
            }
        } else {
            throw new Exception(Messages.DirectoryApiConnectionWrapper_NoConnection);
        }
    }

    @Override
    public void unbind() {
        this.disconnect();
    }

    @Override
    public boolean isConnected() {
        return this.ldapConnection != null && this.ldapConnection.isConnected();
    }

    @Override
    public void setBinaryAttributes(Collection<String> binaryAttributes) {
        if (this.binaryAttributeDetector != null) {
            this.binaryAttributeDetector.setBinaryAttributes(new String[0]);
            for (String binaryAttribute : binaryAttributes) {
                this.binaryAttributeDetector.addBinaryAttribute(new String[]{binaryAttribute});
            }
        }
    }

    @Override
    public StudioNamingEnumeration search(final String searchBase, final String filter, final SearchControls searchControls, final Connection.AliasDereferencingMethod aliasesDereferencingMethod, final Connection.ReferralHandlingMethod referralsHandlingMethod, final javax.naming.ldap.Control[] controls, final StudioProgressMonitor monitor, final ReferralsInfo referralsInfo) {
        final long requestNum = SEARCH_RESQUEST_NUM++;
        InnerRunnable runnable = new InnerRunnable(this){

            @Override
            public void run() {
                try {
                    SearchRequestImpl request = new SearchRequestImpl();
                    request.setBase(new Dn(new String[]{searchBase}));
                    ExprNode node = FilterParser.parse((String)filter, (boolean)true);
                    request.setFilter(node);
                    request.setScope(this.convertSearchScope(searchControls));
                    if (searchControls.getReturningAttributes() != null) {
                        request.addAttributes(searchControls.getReturningAttributes());
                    }
                    request.addAllControls(this.convertControls(controls));
                    request.setSizeLimit(searchControls.getCountLimit());
                    request.setTimeLimit(searchControls.getTimeLimit());
                    request.setDerefAliases(this.convertAliasDerefMode(aliasesDereferencingMethod));
                    SearchCursor cursor = ldapConnection.search((SearchRequest)request);
                    this.namingEnumeration = new CursorStudioNamingEnumeration(connection, cursor, searchBase, filter, searchControls, aliasesDereferencingMethod, referralsHandlingMethod, controls, requestNum, monitor, referralsInfo);
                }
                catch (Exception e) {
                    this.exception = e;
                }
                NamingException ne = null;
                if (this.exception != null) {
                    ne = new NamingException(this.exception.getMessage());
                }
                for (IJndiLogger logger : this.getJndiLoggers()) {
                    if (this.namingEnumeration != null) {
                        logger.logSearchRequest(connection, searchBase, filter, searchControls, aliasesDereferencingMethod, controls, requestNum, ne);
                        continue;
                    }
                    logger.logSearchRequest(connection, searchBase, filter, searchControls, aliasesDereferencingMethod, controls, requestNum, ne);
                    logger.logSearchResultDone(connection, 0L, requestNum, ne);
                }
            }
        };
        try {
            this.checkConnectionAndRunAndMonitor(runnable, monitor);
        }
        catch (Exception e) {
            monitor.reportError(e);
            return null;
        }
        if (runnable.isCanceled()) {
            monitor.setCanceled(true);
        }
        if (runnable.getException() != null) {
            monitor.reportError(runnable.getException());
            return null;
        }
        return runnable.getResult();
    }

    private SearchScope convertSearchScope(SearchControls searchControls) {
        int scope = searchControls.getSearchScope();
        if (scope == 0) {
            return SearchScope.OBJECT;
        }
        if (scope == 1) {
            return SearchScope.ONELEVEL;
        }
        if (scope == 2) {
            return SearchScope.SUBTREE;
        }
        return SearchScope.SUBTREE;
    }

    private Control[] convertControls(javax.naming.ldap.Control[] controls) throws Exception {
        if (controls != null) {
            Control[] returningControls = new Control[controls.length];
            int i = 0;
            while (i < controls.length) {
                returningControls[i] = this.ldapConnection.getCodecService().fromJndiControl(controls[i]);
                ++i;
            }
            return returningControls;
        }
        return new Control[0];
    }

    private AliasDerefMode convertAliasDerefMode(Connection.AliasDereferencingMethod aliasesDereferencingMethod) {
        switch (aliasesDereferencingMethod) {
            case ALWAYS: {
                return AliasDerefMode.DEREF_ALWAYS;
            }
            case FINDING: {
                return AliasDerefMode.DEREF_FINDING_BASE_OBJ;
            }
            case NEVER: {
                return AliasDerefMode.NEVER_DEREF_ALIASES;
            }
            case SEARCH: {
                return AliasDerefMode.DEREF_IN_SEARCHING;
            }
        }
        return AliasDerefMode.DEREF_ALWAYS;
    }

    @Override
    public void modifyEntry(final String dn, final ModificationItem[] modificationItems, final javax.naming.ldap.Control[] controls, StudioProgressMonitor monitor, ReferralsInfo referralsInfo) {
        if (this.connection.isReadOnly()) {
            monitor.reportError(new Exception(NLS.bind((String)Messages.error__connection_is_readonly, (Object)this.connection.getName())));
            return;
        }
        InnerRunnable runnable = new InnerRunnable(this){

            @Override
            public void run() {
                try {
                    ModifyRequestImpl request = new ModifyRequestImpl();
                    request.setName(new Dn(new String[]{dn}));
                    Modification[] modifications = this.convertModificationItems(modificationItems);
                    if (modifications != null) {
                        Modification[] modificationArray = modifications;
                        int n = modifications.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Modification modification = modificationArray[n2];
                            request.addModification(modification);
                            ++n2;
                        }
                    }
                    request.addAllControls(this.convertControls(controls));
                    ModifyResponse modifyResponse = ldapConnection.modify((ModifyRequest)request);
                    this.checkResponse((ResultResponse)modifyResponse);
                }
                catch (Exception e) {
                    this.exception = e;
                }
                NamingException ne = null;
                if (this.exception != null) {
                    ne = new NamingException(this.exception.getMessage());
                }
                for (IJndiLogger logger : this.getJndiLoggers()) {
                    logger.logChangetypeModify(connection, dn, modificationItems, controls, ne);
                }
            }
        };
        try {
            this.checkConnectionAndRunAndMonitor(runnable, monitor);
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
        if (runnable.isCanceled()) {
            monitor.setCanceled(true);
        }
        if (runnable.getException() != null) {
            monitor.reportError(runnable.getException());
        }
    }

    private Modification[] convertModificationItems(ModificationItem[] modificationItems) throws LdapInvalidAttributeValueException {
        if (modificationItems != null) {
            ArrayList<DefaultModification> modifications = new ArrayList<DefaultModification>();
            ModificationItem[] modificationItemArray = modificationItems;
            int n = modificationItems.length;
            int n2 = 0;
            while (n2 < n) {
                ModificationItem modificationItem = modificationItemArray[n2];
                DefaultModification modification = new DefaultModification();
                modification.setAttribute(AttributeUtils.toApiAttribute((Attribute)modificationItem.getAttribute()));
                modification.setOperation(this.convertModificationOperation(modificationItem.getModificationOp()));
                modifications.add(modification);
                ++n2;
            }
            return modifications.toArray(new Modification[0]);
        }
        return null;
    }

    private ModificationOperation convertModificationOperation(int modificationOp) {
        if (modificationOp == 1) {
            return ModificationOperation.ADD_ATTRIBUTE;
        }
        if (modificationOp == 2) {
            return ModificationOperation.REPLACE_ATTRIBUTE;
        }
        if (modificationOp == 3) {
            return ModificationOperation.REMOVE_ATTRIBUTE;
        }
        return null;
    }

    @Override
    public void renameEntry(final String oldDn, final String newDn, final boolean deleteOldRdn, final javax.naming.ldap.Control[] controls, StudioProgressMonitor monitor, ReferralsInfo referralsInfo) {
        if (this.connection.isReadOnly()) {
            monitor.reportError(new Exception(NLS.bind((String)Messages.error__connection_is_readonly, (Object)this.connection.getName())));
            return;
        }
        InnerRunnable runnable = new InnerRunnable(this){

            @Override
            public void run() {
                try {
                    ModifyDnRequestImpl request = new ModifyDnRequestImpl();
                    request.setName(new Dn(new String[]{oldDn}));
                    request.setDeleteOldRdn(deleteOldRdn);
                    Dn newName = new Dn(new String[]{newDn});
                    request.setNewRdn(newName.getRdn());
                    request.setNewSuperior(newName.getParent());
                    request.addAllControls(this.convertControls(controls));
                    ModifyDnResponse modifyDnResponse = ldapConnection.modifyDn((ModifyDnRequest)request);
                    this.checkResponse((ResultResponse)modifyDnResponse);
                }
                catch (Exception e) {
                    this.exception = e;
                }
                NamingException ne = null;
                if (this.exception != null) {
                    ne = new NamingException(this.exception.getMessage());
                }
                for (IJndiLogger logger : this.getJndiLoggers()) {
                    logger.logChangetypeModDn(connection, oldDn, newDn, deleteOldRdn, controls, ne);
                }
            }
        };
        try {
            this.checkConnectionAndRunAndMonitor(runnable, monitor);
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
        if (runnable.isCanceled()) {
            monitor.setCanceled(true);
        }
        if (runnable.getException() != null) {
            monitor.reportError(runnable.getException());
        }
    }

    @Override
    public void createEntry(final String dn, final Attributes attributes, final javax.naming.ldap.Control[] controls, StudioProgressMonitor monitor, ReferralsInfo referralsInfo) {
        if (this.connection.isReadOnly()) {
            monitor.reportError(new Exception(NLS.bind((String)Messages.error__connection_is_readonly, (Object)this.connection.getName())));
            return;
        }
        InnerRunnable runnable = new InnerRunnable(this){

            @Override
            public void run() {
                try {
                    AddRequestImpl request = new AddRequestImpl();
                    request.setEntryDn(new Dn(new String[]{dn}));
                    request.setEntry(AttributeUtils.toEntry((Attributes)attributes, (Dn)new Dn(new String[]{dn})));
                    request.addAllControls(this.convertControls(controls));
                    AddResponse addResponse = ldapConnection.add((AddRequest)request);
                    this.checkResponse((ResultResponse)addResponse);
                }
                catch (Exception e) {
                    this.exception = e;
                }
                NamingException ne = null;
                if (this.exception != null) {
                    ne = new NamingException(this.exception.getMessage());
                }
                for (IJndiLogger logger : this.getJndiLoggers()) {
                    logger.logChangetypeAdd(connection, dn, attributes, controls, ne);
                }
            }
        };
        try {
            this.checkConnectionAndRunAndMonitor(runnable, monitor);
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
        if (runnable.isCanceled()) {
            monitor.setCanceled(true);
        }
        if (runnable.getException() != null) {
            monitor.reportError(runnable.getException());
        }
    }

    @Override
    public void deleteEntry(final String dn, final javax.naming.ldap.Control[] controls, StudioProgressMonitor monitor, ReferralsInfo referralsInfo) {
        if (this.connection.isReadOnly()) {
            monitor.reportError(new Exception(NLS.bind((String)Messages.error__connection_is_readonly, (Object)this.connection.getName())));
            return;
        }
        InnerRunnable runnable = new InnerRunnable(this){

            @Override
            public void run() {
                try {
                    DeleteRequestImpl request = new DeleteRequestImpl();
                    request.setName(new Dn(new String[]{dn}));
                    request.addAllControls(this.convertControls(controls));
                    DeleteResponse deleteResponse = ldapConnection.delete((DeleteRequest)request);
                    this.checkResponse((ResultResponse)deleteResponse);
                }
                catch (Exception e) {
                    this.exception = e;
                }
                NamingException ne = null;
                if (this.exception != null) {
                    ne = new NamingException(this.exception.getMessage());
                }
                for (IJndiLogger logger : this.getJndiLoggers()) {
                    logger.logChangetypeDelete(connection, dn, controls, ne);
                }
            }
        };
        try {
            this.checkConnectionAndRunAndMonitor(runnable, monitor);
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
        if (runnable.isCanceled()) {
            monitor.setCanceled(true);
        }
        if (runnable.getException() != null) {
            monitor.reportError(runnable.getException());
        }
    }

    private void checkConnectionAndRunAndMonitor(InnerRunnable runnable, StudioProgressMonitor monitor) throws Exception {
        if (!this.isConnected || this.ldapConnection == null) {
            this.doConnect(monitor);
            this.doBind(monitor);
        }
        if (this.ldapConnection == null) {
            throw new NamingException(Messages.DirectoryApiConnectionWrapper_NoConnection);
        }
        int i = 0;
        while (i <= 1) {
            this.runAndMonitor(runnable, monitor);
            if (i != 0 || runnable.getException() == null || !(runnable.getException() instanceof InvalidConnectionException)) break;
            this.doConnect(monitor);
            this.doBind(monitor);
            runnable.reset();
            ++i;
        }
    }

    private void runAndMonitor(InnerRunnable runnable, final StudioProgressMonitor monitor) throws CancelException {
        if (!monitor.isCanceled()) {
            StudioProgressMonitor.CancelListener listener = new StudioProgressMonitor.CancelListener(){

                public void cancelRequested(StudioProgressMonitor.CancelEvent event) {
                    if (monitor.isCanceled()) {
                        if (DirectoryApiConnectionWrapper.this.jobThread != null && DirectoryApiConnectionWrapper.this.jobThread.isAlive()) {
                            DirectoryApiConnectionWrapper.this.jobThread.interrupt();
                        }
                        if (DirectoryApiConnectionWrapper.this.ldapConnection != null) {
                            try {
                                DirectoryApiConnectionWrapper.this.ldapConnection.close();
                            }
                            catch (Exception exception) {}
                            DirectoryApiConnectionWrapper.this.isConnected = false;
                            DirectoryApiConnectionWrapper.this.ldapConnection = null;
                        }
                        DirectoryApiConnectionWrapper.this.isConnected = false;
                    }
                }
            };
            monitor.addCancelListener(listener);
            this.jobThread = Thread.currentThread();
            try {
                runnable.run();
            }
            finally {
                monitor.removeCancelListener(listener);
                this.jobThread = null;
            }
            if (monitor.isCanceled()) {
                throw new CancelException();
            }
        }
    }

    private List<IJndiLogger> getJndiLoggers() {
        return ConnectionCorePlugin.getDefault().getJndiLoggers();
    }

    private void checkResponse(ResultResponse response) throws Exception {
        LdapResult ldapResult;
        if (response != null && (ldapResult = response.getLdapResult()) != null) {
            if (ResultCodeEnum.NOT_ALLOWED_ON_NON_LEAF.equals((Object)ldapResult.getResultCode())) {
                throw new ContextNotEmptyException(ldapResult.getDiagnosticMessage());
            }
            if (ResultCodeEnum.ENTRY_ALREADY_EXISTS.equals((Object)ldapResult.getResultCode())) {
                throw new NameAlreadyBoundException(ldapResult.getDiagnosticMessage());
            }
            if (!ResultCodeEnum.SUCCESS.equals((Object)ldapResult.getResultCode())) {
                int code = ldapResult.getResultCode().getResultCode();
                String message = ldapResult.getDiagnosticMessage();
                if (StringUtils.isEmpty((String)message)) {
                    message = Utils.getResultCodeDescription(code);
                }
                throw new Exception(NLS.bind((String)"[LDAP: error code {0} - {1}]", (Object[])new String[]{String.valueOf(code), message}));
            }
        }
    }

    private final class InnerConfiguration
    extends Configuration {
        private String krb5LoginModule;
        private AppConfigurationEntry[] configList = null;

        public InnerConfiguration(String krb5LoginModule) {
            this.krb5LoginModule = krb5LoginModule;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String applicationName) {
            if (this.configList == null) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("refreshKrb5Config", "true");
                switch (DirectoryApiConnectionWrapper.this.connection.getConnectionParameter().getKrb5CredentialConfiguration()) {
                    case USE_NATIVE: {
                        options.put("useTicketCache", "true");
                        options.put("doNotPrompt", "true");
                        break;
                    }
                    case OBTAIN_TGT: {
                        options.put("doNotPrompt", "false");
                    }
                }
                this.configList = new AppConfigurationEntry[1];
                this.configList[0] = new AppConfigurationEntry(this.krb5LoginModule, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
            }
            return this.configList;
        }

        @Override
        public void refresh() {
        }
    }

    abstract class InnerRunnable
    implements Runnable {
        protected StudioNamingEnumeration namingEnumeration = null;
        protected Exception exception = null;
        protected boolean canceled = false;

        InnerRunnable() {
        }

        public Exception getException() {
            return this.exception;
        }

        public StudioNamingEnumeration getResult() {
            return this.namingEnumeration;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void reset() {
            this.namingEnumeration = null;
            this.exception = null;
            this.canceled = false;
        }
    }
}

