/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.io.jndi;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.Control;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCoreConstants;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionManager;
import org.apache.directory.studio.connection.core.IJndiLogger;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.core.io.jndi.ReferralsInfo;
import org.apache.directory.studio.connection.core.io.jndi.StudioSearchResult;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifCommentLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifLineBase;
import org.apache.directory.studio.ldifparser.model.lines.LdifSepLine;
import org.eclipse.core.runtime.Preferences;

public class LdifSearchLogger
implements IJndiLogger {
    private String id;
    private String name;
    private String description;
    private Map<String, FileHandler> fileHandlers = new HashMap<String, FileHandler>();
    private Map<String, Logger> loggers = new HashMap<String, Logger>();

    public LdifSearchLogger() {
        ConnectionCorePlugin.getDefault().getPluginPreferences().addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                if ("searchLogsFileCount".equals(event.getProperty()) || "searchLogsFileSize".equals(event.getProperty())) {
                    for (Logger logger : LdifSearchLogger.this.loggers.values()) {
                        Handler[] handlerArray = logger.getHandlers();
                        int n = handlerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Handler handler = handlerArray[n2];
                            handler.close();
                            ++n2;
                        }
                    }
                    for (FileHandler fh : LdifSearchLogger.this.fileHandlers.values()) {
                        try {
                            File[] logFiles = LdifSearchLogger.getLogFiles(fh);
                            int i = LdifSearchLogger.this.getFileCount();
                            while (i < logFiles.length) {
                                if (logFiles[i] != null && logFiles[i].exists()) {
                                    logFiles[i].delete();
                                }
                                ++i;
                            }
                        }
                        catch (Exception exception) {}
                    }
                    LdifSearchLogger.this.loggers.clear();
                }
            }
        });
    }

    private void initSearchLogger(Connection connection) {
        Logger logger = Logger.getAnonymousLogger();
        this.loggers.put(connection.getId(), logger);
        logger.setLevel(Level.ALL);
        String logfileName = ConnectionManager.getSearchLogFileName(connection);
        try {
            FileHandler fileHandler = new FileHandler(logfileName, this.getFileSizeInKb() * 1000, this.getFileCount(), true);
            this.fileHandlers.put(connection.getId(), fileHandler);
            fileHandler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return record.getMessage();
                }
            });
            logger.addHandler(fileHandler);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dispose(Connection connection) {
        String id = connection.getId();
        if (this.loggers.containsKey(id)) {
            Handler[] handlers;
            Handler[] handlerArray = handlers = this.loggers.get(id).getHandlers();
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                Handler handler = handlerArray[n2];
                handler.close();
                ++n2;
            }
            this.loggers.remove(id);
        }
    }

    private void log(String text, String type, NamingException ex, Connection connection) {
        String id = connection.getId();
        if (!this.loggers.containsKey(id) && connection.getName() != null) {
            this.initSearchLogger(connection);
        }
        if (this.loggers.containsKey(id)) {
            Logger logger = this.loggers.get(id);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            df.setTimeZone(ConnectionCoreConstants.UTC_TIME_ZONE);
            if (ex != null) {
                logger.log(Level.ALL, LdifCommentLine.create((String)("#!" + type + " ERROR")).toFormattedString(LdifFormatParameters.DEFAULT));
            } else {
                logger.log(Level.ALL, LdifCommentLine.create((String)("#!" + type + " OK")).toFormattedString(LdifFormatParameters.DEFAULT));
            }
            logger.log(Level.ALL, LdifCommentLine.create((String)("#!CONNECTION ldap://" + connection.getHost() + ":" + connection.getPort())).toFormattedString(LdifFormatParameters.DEFAULT));
            logger.log(Level.ALL, LdifCommentLine.create((String)("#!DATE " + df.format(new Date()))).toFormattedString(LdifFormatParameters.DEFAULT));
            if (ex != null) {
                String errorComment = "#!ERROR " + ex.getMessage();
                errorComment = errorComment.replaceAll("\r", " ");
                errorComment = errorComment.replaceAll("\n", " ");
                LdifCommentLine errorCommentLine = LdifCommentLine.create((String)errorComment);
                logger.log(Level.ALL, errorCommentLine.toFormattedString(LdifFormatParameters.DEFAULT));
            }
            logger.log(Level.ALL, text);
        }
    }

    @Override
    public void logChangetypeAdd(Connection connection, String dn, Attributes attributes, Control[] controls, NamingException ex) {
    }

    @Override
    public void logChangetypeDelete(Connection connection, String dn, Control[] controls, NamingException ex) {
    }

    @Override
    public void logChangetypeModify(Connection connection, String dn, ModificationItem[] modificationItems, Control[] controls, NamingException ex) {
    }

    @Override
    public void logChangetypeModDn(Connection connection, String oldDn, String newDn, boolean deleteOldRdn, Control[] controls, NamingException ex) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logSearchRequest(Connection connection, String searchBase, String filter, SearchControls searchControls, Connection.AliasDereferencingMethod aliasesDereferencingMethod, Control[] controls, long requestNum, NamingException ex) {
        String attributesAsString;
        String scopeAsString;
        if (!this.isSearchRequestLogEnabled()) {
            return;
        }
        String string = searchControls.getSearchScope() == 2 ? "wholeSubtree (2)" : (scopeAsString = searchControls.getSearchScope() == 1 ? "singleLevel (1)" : "baseObject (0)");
        String string2 = searchControls.getReturningAttributes() == null ? "*" : (attributesAsString = searchControls.getReturningAttributes().length == 0 ? "1.1" : StringUtils.join((Object[])searchControls.getReturningAttributes(), (String)" "));
        String aliasAsString = aliasesDereferencingMethod == Connection.AliasDereferencingMethod.ALWAYS ? "derefAlways (3)" : (aliasesDereferencingMethod == Connection.AliasDereferencingMethod.FINDING ? "derefFindingBaseObj (2)" : (aliasesDereferencingMethod == Connection.AliasDereferencingMethod.SEARCH ? "derefInSearching (1)" : "neverDerefAliases (0)"));
        LdapUrl url = Utils.getLdapURL(connection, searchBase, searchControls.getSearchScope(), filter, searchControls.getReturningAttributes());
        String cmdLine = Utils.getLdapSearchCommandLine(connection, searchBase, searchControls.getSearchScope(), aliasesDereferencingMethod, searchControls.getCountLimit(), searchControls.getTimeLimit(), filter, searchControls.getReturningAttributes());
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add(LdifCommentLine.create((String)("# LDAP URL     : " + url.toString())));
        lines.add(LdifCommentLine.create((String)("# command line : " + cmdLine.toString())));
        lines.add(LdifCommentLine.create((String)("# baseObject   : " + searchBase)));
        lines.add(LdifCommentLine.create((String)("# scope        : " + scopeAsString)));
        lines.add(LdifCommentLine.create((String)("# derefAliases : " + aliasAsString)));
        lines.add(LdifCommentLine.create((String)("# sizeLimit    : " + searchControls.getCountLimit())));
        lines.add(LdifCommentLine.create((String)("# timeLimit    : " + searchControls.getTimeLimit())));
        lines.add(LdifCommentLine.create((String)"# typesOnly    : False"));
        lines.add(LdifCommentLine.create((String)("# filter       : " + filter)));
        lines.add(LdifCommentLine.create((String)("# attributes   : " + attributesAsString)));
        if (controls != null) {
            void var17_19;
            Control[] controlArray = controls;
            int n = controls.length;
            boolean n2 = false;
            while (var17_19 < n) {
                Control control = controlArray[var17_19];
                lines.add(LdifCommentLine.create((String)("# control      : " + control.getID())));
                ++var17_19;
            }
        }
        lines.add(LdifSepLine.create());
        String formattedString = "";
        for (LdifLineBase ldifLineBase : lines) {
            formattedString = String.valueOf(formattedString) + ldifLineBase.toFormattedString(LdifFormatParameters.DEFAULT);
        }
        this.log(formattedString, "SEARCH REQUEST (" + requestNum + ")", ex, connection);
    }

    @Override
    public void logSearchResultEntry(Connection connection, StudioSearchResult studioSearchResult, long requestNum, NamingException ex) {
        if (!this.isSearchResultEntryLogEnabled()) {
            return;
        }
        try {
            String formattedString;
            if (studioSearchResult != null) {
                String dn = studioSearchResult.getNameInNamespace();
                Attributes attributes = studioSearchResult.getAttributes();
                LdifContentRecord record = new LdifContentRecord(LdifDnLine.create((String)dn));
                NamingEnumeration<? extends Attribute> attributeEnumeration = attributes.getAll();
                while (attributeEnumeration.hasMore()) {
                    Attribute attribute = attributeEnumeration.next();
                    String attributeName = attribute.getID();
                    NamingEnumeration<?> valueEnumeration = attribute.getAll();
                    while (valueEnumeration.hasMore()) {
                        Object o = valueEnumeration.next();
                        if (o instanceof String) {
                            record.addAttrVal(LdifAttrValLine.create((String)attributeName, (String)((String)o)));
                        }
                        if (!(o instanceof byte[])) continue;
                        record.addAttrVal(LdifAttrValLine.create((String)attributeName, (byte[])((byte[])o)));
                    }
                }
                record.finish(LdifSepLine.create());
                formattedString = record.toFormattedString(LdifFormatParameters.DEFAULT);
            } else {
                formattedString = LdifFormatParameters.DEFAULT.getLineSeparator();
            }
            this.log(formattedString, "SEARCH RESULT ENTRY (" + requestNum + ")", ex, connection);
        }
        catch (NamingException namingException) {}
    }

    @Override
    public void logSearchResultReference(Connection connection, Referral referral, ReferralsInfo referralsInfo, long requestNum, NamingException ex) {
        if (!this.isSearchResultEntryLogEnabled()) {
            return;
        }
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add(LdifCommentLine.create((String)("# reference : " + (referral != null ? referral.getLdapUrls() : "null"))));
        lines.add(LdifSepLine.create());
        String formattedString = "";
        for (LdifLineBase ldifLineBase : lines) {
            formattedString = String.valueOf(formattedString) + ldifLineBase.toFormattedString(LdifFormatParameters.DEFAULT);
        }
        this.log(formattedString, "SEARCH RESULT REFERENCE (" + requestNum + ")", ex, connection);
    }

    @Override
    public void logSearchResultDone(Connection connection, long count, long requestNum, NamingException ex) {
        if (!this.isSearchRequestLogEnabled()) {
            return;
        }
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add(LdifCommentLine.create((String)("# numEntries : " + count)));
        lines.add(LdifSepLine.create());
        String formattedString = "";
        for (LdifLineBase ldifLineBase : lines) {
            formattedString = String.valueOf(formattedString) + ldifLineBase.toFormattedString(LdifFormatParameters.DEFAULT);
        }
        this.log(formattedString, "SEARCH RESULT DONE (" + requestNum + ")", ex, connection);
    }

    public File[] getFiles(Connection connection) {
        String id = connection.getId();
        if (!this.loggers.containsKey(id) && connection.getName() != null) {
            this.initSearchLogger(connection);
        }
        try {
            return LdifSearchLogger.getLogFiles(this.fileHandlers.get(id));
        }
        catch (Exception exception) {
            return new File[0];
        }
    }

    private static File[] getLogFiles(FileHandler fileHandler) throws Exception {
        Field field = LdifSearchLogger.getFieldFromClass("java.util.logging.FileHandler", "files");
        field.setAccessible(true);
        File[] files = (File[])field.get(fileHandler);
        return files;
    }

    private static Field getFieldFromClass(String className, String fieldName) throws Exception {
        Class<?> clazz = Class.forName(className);
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals(fieldName)) {
                return fields[i];
            }
            ++i;
        }
        return null;
    }

    private boolean isSearchRequestLogEnabled() {
        return ConnectionCorePlugin.getDefault().getPluginPreferences().getBoolean("searchRequestLogsEnable");
    }

    private boolean isSearchResultEntryLogEnabled() {
        return ConnectionCorePlugin.getDefault().getPluginPreferences().getBoolean("searchResultEntryLogsEnable");
    }

    private int getFileCount() {
        return ConnectionCorePlugin.getDefault().getPluginPreferences().getInt("searchLogsFileCount");
    }

    private int getFileSizeInKb() {
        return ConnectionCorePlugin.getDefault().getPluginPreferences().getInt("searchLogsFileSize");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }
}

