/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.jmx.internal;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.fusesource.ide.server.karaf.core.Activator;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.tools.jmx.jvmmonitor.core.IActiveJvm;
import org.jboss.tools.jmx.jvmmonitor.core.IHost;
import org.jboss.tools.jmx.jvmmonitor.core.JvmModel;

public class KarafJVMFacadeUtility {
    public static IActiveJvm findJvmForServer(IServer server) {
        String progArgs = null;
        String main = null;
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        if (beh != null && server.getServerState() == 2) {
            try {
                Object o = beh.getSharedData("AbstractStartJavaServerLaunchDelegate.Process");
                if (o instanceof IProcess) {
                    IProcess proc = (IProcess)o;
                    ILaunch launch = proc.getLaunch();
                    ILaunchConfiguration lc = launch.getLaunchConfiguration();
                    progArgs = lc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
                    main = lc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
                }
            }
            catch (CoreException ce) {
                Activator.getLogger().error((Throwable)ce);
            }
        }
        String target = String.valueOf(main) + (progArgs == null ? "" : " " + progArgs);
        target = target.replaceAll("\"", "").trim();
        JvmModel model = JvmModel.getInstance();
        List hosts = model.getHosts();
        for (IHost host : hosts) {
            host.getName();
            List jvms = host.getActiveJvms();
            for (IActiveJvm jvm : jvms) {
                jvm.getPid();
                String command = jvm.getLaunchCommand();
                if (!command.equals(target)) continue;
                return jvm;
            }
        }
        return null;
    }
}

