/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.publish.jmx;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.publish.jmx.IJMXPublishBehaviour;
import org.fusesource.ide.server.karaf.core.server.subsystems.OSGiBundleState;

public class KarafBundleMBeanPublishBehaviour
implements IJMXPublishBehaviour {
    private static final String KARAF_BUNDLE_MBEAN = "org.apache.karaf:type=bundle,*";
    protected ObjectName objectName;

    @Override
    public long getBundleId(MBeanServerConnection mbsc, String bundleSymbolicName, String version) {
        try {
            TabularData tabData = (TabularData)mbsc.getAttribute(this.objectName, "Bundles");
            Collection<?> rows = tabData.values();
            for (Object row : rows) {
                if (!(row instanceof CompositeData)) continue;
                CompositeData cd = (CompositeData)row;
                String bsn = cd.get("Name").toString();
                String id = cd.get("ID").toString();
                String ver = cd.get("Version").toString();
                if (!(version != null ? bsn.equals(bundleSymbolicName) && ver.equals(version) : bsn.equals(bundleSymbolicName))) continue;
                return Long.parseLong(id);
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1L;
    }

    @Override
    public long installBundle(MBeanServerConnection mbsc, String bundlePath) {
        String bundleUrl = this.getBundleUrl(bundlePath);
        try {
            Object retVal = mbsc.invoke(this.objectName, "install", new Object[]{bundleUrl, Boolean.TRUE}, new String[]{String.class.getName(), "boolean"});
            if (retVal instanceof Long) {
                return (Long)retVal;
            }
            Activator.getLogger().error(retVal.toString());
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1L;
    }

    private String getBundleUrl(String bundlePath) {
        String bundleUrl = bundlePath;
        try {
            bundleUrl = new File(bundlePath.replaceFirst("file:", "")).toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException murle) {
            Activator.getLogger().log((IStatus)new Status(4, "org.fusesource.ide.server.karaf.core", murle.getMessage(), (Throwable)murle));
        }
        return bundleUrl;
    }

    @Override
    public boolean updateBundle(MBeanServerConnection mbsc, long bundleId, String bundlePath) {
        String bundleUrl = this.getBundleUrl(bundlePath);
        try {
            mbsc.invoke(this.objectName, "update", new Object[]{Long.toString(bundleId), bundleUrl}, new String[]{String.class.getName(), String.class.getName()});
            return true;
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean uninstallBundle(MBeanServerConnection mbsc, long bundleId) {
        try {
            mbsc.invoke(this.objectName, "uninstall", new Object[]{Long.toString(bundleId)}, new String[]{String.class.getName()});
            return true;
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            return false;
        }
    }

    @Override
    public int getBundleStatus(MBeanServerConnection mbsc, long bundleId) {
        try {
            TabularData tabData = (TabularData)mbsc.getAttribute(this.objectName, "Bundles");
            Collection<?> rows = tabData.values();
            for (Object row : rows) {
                if (!(row instanceof CompositeData)) continue;
                CompositeData cd = (CompositeData)row;
                String id = cd.get("ID").toString();
                String state = cd.get("State").toString();
                long longID = Long.parseLong(id);
                if (bundleId != longID) continue;
                return OSGiBundleState.getStatusForString(state);
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return 0;
    }

    @Override
    public boolean canHandle(MBeanServerConnection mbsc) {
        try {
            this.objectName = new ObjectName(KARAF_BUNDLE_MBEAN);
            Set<ObjectInstance> mbeans = mbsc.queryMBeans(this.objectName, null);
            if (mbeans.size() == 1) {
                ObjectInstance oMbean = mbeans.iterator().next();
                this.objectName = oMbean.getObjectName();
                return true;
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return false;
    }
}

