/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.publish.jmx;

import java.util.Collection;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.publish.jmx.KarafBundleMBeanPublishBehaviour;
import org.fusesource.ide.server.karaf.core.server.subsystems.OSGiBundleState;

public class KarafBundlesMBeanPublishBehaviour
extends KarafBundleMBeanPublishBehaviour {
    private static final String KARAF_BUNDLES_MBEAN = "org.apache.karaf:type=bundles,*";

    @Override
    public long getBundleId(MBeanServerConnection mbsc, String bundleSymbolicName, String version) {
        try {
            TabularData tabData = (TabularData)mbsc.invoke(this.objectName, "list", null, null);
            Collection<?> rows = tabData.values();
            for (Object row : rows) {
                if (!(row instanceof CompositeData)) continue;
                CompositeData cd = (CompositeData)row;
                String bsn = cd.get("Name").toString();
                String id = cd.get("ID").toString();
                String ver = cd.get("Version").toString();
                if (!(version != null ? bsn.equals(bundleSymbolicName) && ver.equals(version) : bsn.equals(bundleSymbolicName))) continue;
                return Long.parseLong(id);
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1L;
    }

    @Override
    public int getBundleStatus(MBeanServerConnection mbsc, long bundleId) {
        try {
            TabularData tabData = (TabularData)mbsc.invoke(this.objectName, "list", null, null);
            Collection<?> rows = tabData.values();
            for (Object row : rows) {
                if (!(row instanceof CompositeData)) continue;
                CompositeData cd = (CompositeData)row;
                String id = cd.get("ID").toString();
                String state = cd.get("State").toString();
                long longID = Long.parseLong(id);
                if (bundleId != longID) continue;
                return OSGiBundleState.getStatusForString(state);
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return 0;
    }

    @Override
    public boolean canHandle(MBeanServerConnection mbsc) {
        try {
            this.objectName = new ObjectName(KARAF_BUNDLES_MBEAN);
            Set<ObjectInstance> mbeans = mbsc.queryMBeans(this.objectName, null);
            if (mbeans.size() == 1) {
                ObjectInstance oMbean;
                ObjectInstance oi = oMbean = mbeans.iterator().next();
                this.objectName = oi.getObjectName();
                return true;
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return false;
    }
}

