/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.publish.jmx;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.publish.jmx.IJMXPublishBehaviour;
import org.fusesource.ide.server.karaf.core.server.subsystems.OSGiBundleState;

public class OSGIMBeanPublishBehaviour
implements IJMXPublishBehaviour {
    private static final String OSGI_FRAMEWORK_MBEAN = "osgi.core:type=framework,*";
    private static final String OSGI_BUNDLESTATE_MBEAN = "osgi.core:type=bundleState,*";
    private ObjectName objectNameBundleState;
    private ObjectName objectNameFramework;

    @Override
    public long getBundleId(MBeanServerConnection mbsc, String bundleSymbolicName, String version) {
        try {
            TabularData tabData = (TabularData)mbsc.invoke(this.objectNameBundleState, "listBundles", null, null);
            Collection<?> rows = tabData.values();
            for (Object row : rows) {
                CompositeData cd;
                Object symbolicName;
                if (!(row instanceof CompositeData) || (symbolicName = (cd = (CompositeData)row).get("SymbolicName")) == null) continue;
                String bsn = symbolicName.toString();
                Object identifier = cd.get("Identifier");
                if (identifier == null) continue;
                String id = identifier.toString();
                Object deployedVersion = cd.get("Version");
                if (version != null && deployedVersion != null) {
                    String ver = deployedVersion.toString();
                    if (!bsn.equals(bundleSymbolicName) || !ver.equals(version)) continue;
                    return Long.parseLong(id);
                }
                if (!bsn.equals(bundleSymbolicName)) continue;
                return Long.parseLong(id);
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1L;
    }

    @Override
    public long installBundle(MBeanServerConnection mbsc, String bundlePath) {
        String bundleUrl = this.getEncodedURIBundlePath(bundlePath);
        try {
            Object retVal = mbsc.invoke(this.objectNameFramework, "installBundle", new Object[]{bundleUrl}, new String[]{String.class.getName()});
            if (retVal instanceof Long) {
                long bid = (Long)retVal;
                mbsc.invoke(this.objectNameFramework, "startBundle", new Object[]{bid}, new String[]{"long"});
                return bid;
            }
            Activator.getLogger().error(retVal.toString());
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1L;
    }

    private String getEncodedURIBundlePath(String bundlePath) {
        String bundleUrl = bundlePath;
        try {
            bundleUrl = new File(bundlePath.replaceFirst("file:", "")).toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException murle) {
            murle.printStackTrace();
        }
        return bundleUrl;
    }

    @Override
    public boolean updateBundle(MBeanServerConnection mbsc, long bundleId, String bundlePath) {
        String bundleUrl = this.getEncodedURIBundlePath(bundlePath);
        try {
            mbsc.invoke(this.objectNameFramework, "updateBundleFromURL", new Object[]{bundleId, bundleUrl}, new String[]{"long", String.class.getName()});
            return true;
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean uninstallBundle(MBeanServerConnection mbsc, long bundleId) {
        try {
            mbsc.invoke(this.objectNameFramework, "uninstallBundle", new Object[]{bundleId}, new String[]{"long"});
            return true;
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            return false;
        }
    }

    @Override
    public int getBundleStatus(MBeanServerConnection mbsc, long bundleId) {
        try {
            TabularData tabData = (TabularData)mbsc.invoke(this.objectNameBundleState, "listBundles", null, null);
            Collection<?> rows = tabData.values();
            for (Object row : rows) {
                if (!(row instanceof CompositeData)) continue;
                CompositeData cd = (CompositeData)row;
                String id = cd.get("Identifier").toString();
                String state = cd.get("State").toString();
                long longID = Long.parseLong(id);
                if (bundleId != longID) continue;
                return OSGiBundleState.getStatusForString(state);
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return 0;
    }

    @Override
    public boolean canHandle(MBeanServerConnection mbsc) {
        ObjectInstance oMbean;
        Set<ObjectInstance> mbeans;
        block5: {
            block4: {
                try {
                    this.objectNameBundleState = new ObjectName(OSGI_BUNDLESTATE_MBEAN);
                    this.objectNameFramework = new ObjectName(OSGI_FRAMEWORK_MBEAN);
                    mbeans = mbsc.queryMBeans(this.objectNameBundleState, null);
                    if (mbeans.size() == 1) break block4;
                    return false;
                }
                catch (Exception ex) {
                    Activator.getLogger().error((Throwable)ex);
                    return false;
                }
            }
            oMbean = mbeans.iterator().next();
            this.objectNameBundleState = oMbean.getObjectName();
            mbeans = mbsc.queryMBeans(this.objectNameFramework, null);
            if (mbeans.size() == 1) break block5;
            return false;
        }
        oMbean = mbeans.iterator().next();
        this.objectNameFramework = oMbean.getObjectName();
        return true;
    }
}

