/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.runtime.classpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.common.project.facet.core.IClasspathProvider;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.server.ui.internal.RuntimeLabelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.ui.IRuntimeComponentLabelProvider;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.fusesource.ide.server.karaf.core.runtime.IKarafRuntime;
import org.fusesource.ide.server.karaf.core.runtime.classpath.KarafProjectRuntimeClasspathProvider;

public final class KarafClasspathProviderAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_TYPES = new Class[]{IClasspathProvider.class, IRuntimeComponentLabelProvider.class};

    public Object getAdapter(Object adaptable, Class adapterType) {
        IRuntimeComponent rc = (IRuntimeComponent)adaptable;
        if (IRuntimeComponentLabelProvider.class.equals((Object)adapterType)) {
            return new RuntimeLabelProvider(rc);
        }
        return new RuntimeFacetClasspathProvider(rc);
    }

    public Class<?>[] getAdapterList() {
        return ADAPTER_TYPES;
    }

    public static class JREClasspathUtil {
        public static List<IClasspathEntry> getJavaClasspathEntries(String runtimeId) {
            IKarafRuntime jbsRuntime;
            IVMInstall vmInstall;
            IRuntime runtime;
            if (runtimeId != null && (runtime = ServerCore.findRuntime((String)runtimeId)) != null && (vmInstall = (jbsRuntime = (IKarafRuntime)runtime.loadAdapter(IKarafRuntime.class, null)).getVM()) != null) {
                String name = vmInstall.getName();
                String typeId = vmInstall.getVMInstallType().getId();
                IClasspathEntry[] entries = new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER).append(typeId).append(name))};
                return Arrays.asList(entries);
            }
            return new ArrayList<IClasspathEntry>();
        }
    }

    public class RuntimeFacetClasspathProvider
    implements IClasspathProvider {
        protected IRuntimeComponent rc;

        public RuntimeFacetClasspathProvider() {
        }

        public RuntimeFacetClasspathProvider(IRuntimeComponent rc) {
            this.rc = rc;
        }

        public List<IClasspathEntry> getClasspathEntries(IProjectFacetVersion fv) {
            ArrayList<IClasspathEntry> ret = new ArrayList<IClasspathEntry>();
            if (fv.getProjectFacet().equals(JavaFacet.FACET)) {
                String runtimeId = this.rc.getProperty("id");
                ret.addAll(JREClasspathUtil.getJavaClasspathEntries(runtimeId));
            } else {
                ret.addAll(this.getProjectRuntimeEntry());
            }
            return ret;
        }

        private List<IClasspathEntry> getProjectRuntimeEntry() {
            String id = this.rc.getProperty("id");
            IPath containerPath = KarafProjectRuntimeClasspathProvider.CONTAINER_PATH;
            IClasspathEntry cpentry = JavaCore.newContainerEntry((IPath)containerPath.append(id));
            return Collections.singletonList(cpentry);
        }
    }
}

