/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.server;

import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ILaunchServerController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IModuleStateController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerShutdownController;

public class ControllableKarafServerBehavior
extends ControllableServerBehavior {
    protected IPublishController getPublishController() throws CoreException {
        return (IPublishController)this.getController("publish", null);
    }

    protected IModuleStateController getModuleStateController() throws CoreException {
        return (IModuleStateController)this.getController("modules", null);
    }

    protected IServerShutdownController getShutdownController() throws CoreException {
        return (IServerShutdownController)this.getController("shutdown", null);
    }

    protected ILaunchServerController getLaunchController() throws CoreException {
        return (ILaunchServerController)this.getController("launch", null);
    }

    public void setServerStarted() {
        super.setServerStarted();
        this.updateModuleStates();
    }

    protected void updateModuleStates() {
        final IServer server = this.getServer();
        WorkspaceJob moduleStateJob = new WorkspaceJob("Module State Update Job"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IModule[] modules = server.getModules();
                monitor.beginTask("Verifying Module State", modules.length * 1000);
                int i = 0;
                while (i < modules.length) {
                    IModule[] temp = new IModule[]{modules[i]};
                    int state = ControllableKarafServerBehavior.this.getModuleStateController().getModuleState(temp, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    ((Server)server).setModuleState(temp, state);
                    ++i;
                }
                return Status.OK_STATUS;
            }
        };
        moduleStateJob.schedule();
    }
}

