/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.server.subsystems;

import java.util.Arrays;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.Messages;
import org.fusesource.ide.server.karaf.core.publish.IPublishBehaviour;
import org.fusesource.ide.server.karaf.core.publish.jmx.KarafJMXPublisher;
import org.fusesource.ide.server.karaf.core.server.subsystems.publish.ModuleBundleVersionUtility;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilter;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilterProvider;
import org.jboss.ide.eclipse.as.core.util.ProgressMonitorUtil;
import org.jboss.ide.eclipse.as.wtp.core.modules.filter.patterns.ComponentModuleInclusionFilterUtility;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPrimaryPublishController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishControllerDelegate;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.util.PublishControllerUtil;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.LocalZippedModulePublishRunner;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerModelUtilities;

public class Karaf2xPublishController
extends AbstractSubsystemController
implements IPublishController,
IPrimaryPublishController {
    private static final List<String> GOALS = Arrays.asList("package");
    protected IPublishBehaviour publisher2 = new KarafJMXPublisher();

    public IStatus canPublish() {
        if (this.getServer().getServerState() != 2) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected IPublishBehaviour getJMXPublisher() {
        return this.publisher2;
    }

    protected IPublishBehaviour getPublisher(IModule[] module) {
        return this.getJMXPublisher();
    }

    public boolean canPublishModule(IModule[] module) {
        return true;
    }

    public void publishStart(IProgressMonitor monitor) throws CoreException {
    }

    public void publishFinish(IProgressMonitor monitor) throws CoreException {
    }

    public int publishModule(int kind, int deltaKind, IModule[] modules, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        this.validate();
        IPublishControllerDelegate delegate = PublishControllerUtil.findDelegatePublishController((IServer)this.getServer(), (IModule[])modules, (boolean)true);
        if (delegate != null) {
            return delegate.publishModule(kind, deltaKind, modules, (IProgressMonitor)subMonitor.newChild(2));
        }
        int publishType = PublishControllerUtil.getPublishType((IServer)this.getServer(), (IModule[])modules, (int)kind, (int)deltaKind);
        if (publishType == 3) {
            return this.removeModule(modules, (IProgressMonitor)subMonitor.newChild(2));
        }
        if (ServerModelUtilities.isAnyDeleted((IModule[])modules)) {
            return 0;
        }
        boolean isBinaryObject = ServerModelUtilities.isBinaryModule((IModule[])modules);
        if (!isBinaryObject) {
            return this.handleZippedPublish(modules, publishType, false, (IProgressMonitor)subMonitor.newChild(1));
        }
        return 0;
    }

    private int handleZippedPublish(IModule[] module, int publishType, boolean force, IProgressMonitor monitor) throws CoreException {
        IPath tmpArchive = this.getTempBundlePath(module);
        LocalZippedModulePublishRunner runner = this.createZippedRunner(module, tmpArchive);
        monitor.beginTask("Packaging Module", 200);
        IStatus result = runner.fullPublishModule(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)100));
        if ((result == null || result.isOK()) && tmpArchive.toFile().exists()) {
            return this.transferBuiltModule(module, tmpArchive, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)100));
        }
        return 0;
    }

    protected LocalZippedModulePublishRunner createZippedRunner(IModule[] m, IPath p) {
        return new LocalZippedModulePublishRunner(this.getServer(), m, p, this.getModulePathFilterProvider());
    }

    protected IModulePathFilterProvider getModulePathFilterProvider() {
        return new IModulePathFilterProvider(){

            public IModulePathFilter getFilter(IServer server, IModule[] module) {
                return ComponentModuleInclusionFilterUtility.findDefaultModuleFilter((IModule)module[module.length - 1]);
            }
        };
    }

    private IPath getMetadataTemporaryLocation(IServer server) {
        IPath deployRoot = Karaf2xPublishController.getServerStateLocation(server.getId()).append("tempRemoteDeploy").makeAbsolute();
        deployRoot.toFile().mkdirs();
        return deployRoot;
    }

    public static IPath getServerStateLocation(String serverID) {
        return serverID == null ? Activator.getDefault().getStateLocation() : Activator.getDefault().getStateLocation().append(serverID.replace(' ', '_'));
    }

    public void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        this.validate();
    }

    public int transferBuiltModule(IModule[] module, IPath srcFile, IProgressMonitor monitor) throws CoreException {
        ModuleBundleVersionUtility.BundleDetails bd = new ModuleBundleVersionUtility().getBundleDetails(module, srcFile);
        int status = 2;
        if (bd == null) {
            Activator.getLogger().error("Deployment problem: Binary archive " + srcFile.toOSString() + " is not valid or lacking a valid MANIFEST.MF!");
            throw new CoreException((IStatus)new Status(4, "org.fusesource.ide.server.karaf.core", Messages.DeployErrorMissingManifest));
        }
        status = this.getPublisher(module).publish(this.getServer(), module, bd.getSymbolicName(), bd.getVersion(), srcFile);
        ((Server)this.getServer()).setModuleState(module, status);
        ((Server)this.getServer()).setModulePublishState(module, 1);
        ((Server)this.getServer()).setServerPublishState(1);
        status = 1;
        return status;
    }

    public int removeModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        boolean removed;
        IPath tmpArchive = this.getTempBundlePath(module);
        ModuleBundleVersionUtility.BundleDetails bd = new ModuleBundleVersionUtility().getBundleDetails(module, tmpArchive);
        if (bd != null && (removed = this.getPublisher(module).uninstall(this.getServer(), module, bd.getSymbolicName(), bd.getVersion()))) {
            return 1;
        }
        return 3;
    }

    private IPath getTempBundlePath(IModule[] module) {
        IPath localTempLocation = this.getMetadataTemporaryLocation(this.getServer());
        String moduleVersion = null;
        try {
            moduleVersion = this.getModuleVersion(module[0]);
        }
        catch (CoreException coreException) {
            moduleVersion = Long.toString(System.currentTimeMillis());
        }
        String archiveName = String.valueOf(module[0].getName()) + "-" + moduleVersion + ServerModelUtilities.getDefaultSuffixForModule((IModule)module[0]);
        IPath tempBundlePath = localTempLocation.append(archiveName);
        return tempBundlePath;
    }

    private String getModuleVersion(IModule module) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IProject project = module.getProject();
        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(project, (IProgressMonitor)monitor);
        MavenProject mavenProject = facade.getMavenProject((IProgressMonitor)monitor);
        return mavenProject.getVersion();
    }
}

