/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.server.subsystems;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IServer;
import org.fusesource.ide.server.karaf.core.runtime.IKarafRuntime;
import org.jboss.ide.eclipse.as.core.util.ArgsUtil;
import org.jboss.ide.eclipse.as.wtp.core.server.launch.LaunchConfiguratorWithOverrides;

public class Karaf2xStartupLaunchConfigurator
extends LaunchConfiguratorWithOverrides {
    public static final String QUOTE = "\"";
    public static final String SPACE = " ";
    public static final String SEPARATOR = File.separator;
    public static final String KARAF_MAIN_CLASS = "org.apache.karaf.main.Main";
    public static final String KARAF_STOP_CLASS = "org.apache.karaf.main.Stop";

    public Karaf2xStartupLaunchConfigurator(IServer server) throws CoreException {
        super(server);
    }

    protected void doConfigure(ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        IKarafRuntime runtime = null;
        if (this.server.getRuntime() != null) {
            runtime = (IKarafRuntime)this.server.getRuntime().loadAdapter(IKarafRuntime.class, null);
        }
        if (runtime != null) {
            String karafInstallDir = runtime.getLocation().toOSString();
            String mainProgram = null;
            String vmArguments = null;
            vmArguments = this.getVMArguments(karafInstallDir);
            mainProgram = this.getMainProgram();
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, karafInstallDir);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainProgram);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArguments);
            LinkedList<String> classPathList = new LinkedList<String>();
            String[] classPathEntries = this.getClassPathEntries(karafInstallDir);
            if (classPathEntries != null && classPathEntries.length > 0) {
                String[] stringArray = classPathEntries;
                int n = classPathEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    String jarName = stringArray[n2];
                    Path jarPath = new Path(jarName);
                    IRuntimeClasspathEntry entry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)jarPath);
                    classPathList.add(entry.getMemento());
                    ++n2;
                }
            }
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classPathList);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, this.getJreContainerPath(runtime));
        }
    }

    protected String getJreContainerPath(IKarafRuntime runtime) {
        IVMInstall vmInstall = runtime.getVM();
        if (vmInstall == null) {
            return null;
        }
        return JavaRuntime.newJREContainerPath((IVMInstall)vmInstall).toPortableString();
    }

    protected String[] getClassPathEntries(String installPath) {
        ArrayList cp = new ArrayList();
        Path libPath = new Path(String.format("%s%s%s%s", installPath, SEPARATOR, "lib", SEPARATOR));
        if (libPath.toFile().exists()) {
            this.findJars((IPath)libPath, cp);
        }
        String[] entries = new String[cp.size() + 1];
        entries[0] = String.valueOf(installPath) + SEPARATOR + "etc";
        int i = 1;
        for (Object o : cp) {
            IRuntimeClasspathEntry e = (IRuntimeClasspathEntry)o;
            entries[i++] = e.getLocation();
        }
        return entries;
    }

    private void findJars(IPath path, List cp) {
        File[] libs;
        File[] fileArray = libs = path.toFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.isFile() && pathname.getName().toLowerCase().endsWith(".jar");
            }
        });
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            File lib = fileArray[n2];
            IPath p = path.append(lib.getName());
            if (lib.isFile()) {
                if (lib.getName().toLowerCase().startsWith("karaf")) {
                    cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)p));
                }
            } else {
                this.findJars(p, cp);
            }
            ++n2;
        }
    }

    protected String getDeployDir() {
        IKarafRuntime runtime = (IKarafRuntime)this.server.getRuntime().loadAdapter(IKarafRuntime.class, null);
        if (runtime != null) {
            String karafInstallDir = runtime.getLocation().toOSString();
            return String.valueOf(karafInstallDir) + SEPARATOR + "deploy";
        }
        return "";
    }

    protected String getMainProgram() {
        return KARAF_MAIN_CLASS;
    }

    protected String getVMArguments(String karafInstallDir) {
        StringBuilder vmArguments = new StringBuilder();
        String endorsedDirs = System.getProperty("java.endorsed.dirs");
        String extDirs = System.getProperty("java.ext.dirs");
        IKarafRuntime runtime = null;
        if (this.server.getRuntime() != null) {
            runtime = (IKarafRuntime)this.server.getRuntime().loadAdapter(IKarafRuntime.class, null);
            File vmLoc = runtime.getVM().getInstallLocation();
            endorsedDirs = this.createEndorsedDirValue(karafInstallDir, vmLoc);
            extDirs = this.createExtDirValue(karafInstallDir, vmLoc);
        }
        vmArguments.append("-Xms128M");
        vmArguments.append(" -Xmx512M");
        vmArguments.append(" -XX:+UnlockDiagnosticVMOptions");
        vmArguments.append(" -XX:+UnsyncloadClass");
        vmArguments.append(" -Dderby.system.home=\"" + karafInstallDir + SEPARATOR + "data" + SEPARATOR + "derby" + QUOTE);
        vmArguments.append(" -Dderby.storage.fileSyncTransactionLog=true");
        vmArguments.append(" -server");
        vmArguments.append(" -Dcom.sun.management.jmxremote");
        vmArguments.append(" -Djava.endorsed.dirs=\"" + endorsedDirs + QUOTE);
        vmArguments.append(" -Djava.ext.dirs=\"" + extDirs + QUOTE);
        vmArguments.append(" -Dkaraf.startLocalConsole=false");
        vmArguments.append(" -Dkaraf.startRemoteShell=true");
        vmArguments.append(" -Dkaraf.home=\"" + karafInstallDir + QUOTE);
        vmArguments.append(" -Dkaraf.base=\"" + karafInstallDir + QUOTE);
        vmArguments.append(" -Dkaraf.instances=\"" + karafInstallDir + SEPARATOR + "instances" + QUOTE);
        vmArguments.append(" -Dkaraf.data=\"" + karafInstallDir + SEPARATOR + "data" + QUOTE);
        vmArguments.append(" -Djava.util.logging.config.file=\"" + karafInstallDir + SEPARATOR + "etc" + SEPARATOR + "java.util.logging.properties" + QUOTE);
        return vmArguments.toString();
    }

    String createEndorsedDirValue(String karafInstallDir, File vmLoc) {
        return String.valueOf(Paths.get(vmLoc.getPath(), "jre", "lib", "endorsed").toString()) + File.pathSeparator + Paths.get(vmLoc.getPath(), "lib", "endorsed").toString() + File.pathSeparator + Paths.get(karafInstallDir, "lib", "endorsed").toString();
    }

    String createExtDirValue(String karafInstallDir, File vmLoc) {
        return String.valueOf(Paths.get(vmLoc.getPath(), "jre", "lib", "ext").toString()) + File.pathSeparator + Paths.get(vmLoc.getPath(), "lib", "ext").toString() + File.pathSeparator + Paths.get(karafInstallDir, "lib", "ext").toString();
    }

    protected void doOverrides(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        String vmArguments = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
        if (this.server.getRuntime() != null) {
            String karafInstallDir = this.server.getRuntime().getLocation().toOSString();
            IKarafRuntime karafRuntime = (IKarafRuntime)this.server.getRuntime().loadAdapter(IKarafRuntime.class, null);
            File vmLoc = karafRuntime.getVM().getInstallLocation();
            vmArguments = ArgsUtil.setArg((String)vmArguments, null, (String)"-Djava.ext.dirs", (String)this.createExtDirValue(karafInstallDir, vmLoc));
            vmArguments = ArgsUtil.setArg((String)vmArguments, null, (String)"-Djava.endorsed.dirs", (String)this.createEndorsedDirValue(karafInstallDir, vmLoc));
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArguments);
        }
    }
}

