/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.server.subsystems.publish;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.wst.server.core.IModule;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.util.KarafUtils;

public class ModuleBundleVersionUtility {
    public BundleDetails getBundleDetails(IModule[] module, IPath srcFile) {
        String moduleTypeId = module[0].getModuleType().getId();
        if (moduleTypeId.equals("jboss.osgi")) {
            return this.getJBossOSGiDetails(module, srcFile);
        }
        if (moduleTypeId.equals("jst.utility") || moduleTypeId.equals("jst.web")) {
            BundleDetails ret;
            if (srcFile != null && srcFile.toFile().exists() && (ret = this.getJBossOSGiDetailsFromJar(srcFile)) != null) {
                return ret;
            }
            return this.getJBossOSGiDetailsFromProject(module);
        }
        Activator.getLogger().warning("Unhandled module type for deployment: " + moduleTypeId);
        return null;
    }

    private BundleDetails getFuseCamelDetails(IModule[] module) {
        try {
            String version2 = KarafUtils.getBundleVersion(module[0], null);
            String symbolicName2 = KarafUtils.getBundleSymbolicName(module[0]);
            return new BundleDetails(symbolicName2, version2);
        }
        catch (CoreException ce) {
            Activator.getLogger().error((Throwable)ce);
            return null;
        }
    }

    private BundleDetails getJBossOSGiDetails(IModule[] module, IPath srcFile) {
        if (srcFile != null) {
            return this.getJBossOSGiDetailsFromJar(srcFile);
        }
        return this.getJBossOSGiDetailsFromProject(module);
    }

    private BundleDetails getJBossOSGiDetailsFromJar(IPath srcFile) {
        block12: {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JarFile jf = new JarFile(srcFile.toOSString());){
                    Manifest m = jf.getManifest();
                    if (m == null) break block12;
                    return this.createBundleDetails(m);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioe) {
                Activator.getLogger().error((Throwable)ioe);
            }
        }
        return null;
    }

    private BundleDetails getJBossOSGiDetailsFromProject(IModule[] module) {
        IProject p = module[0].getProject();
        final IFile[] found = new IFile[1];
        try {
            p.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile && "manifest.mf".equalsIgnoreCase(resource.getName())) {
                        found[0] = (IFile)resource;
                    }
                    return found[0] == null;
                }
            });
        }
        catch (CoreException ce) {
            Activator.getLogger().error((Throwable)ce);
        }
        if (found[0] == null) {
            return this.findBuildArtifactInProjectsOutputFolder(module);
        }
        try {
            InputStream is = found[0].getContents();
            Manifest mf = new Manifest(is);
            return this.createBundleDetails(mf);
        }
        catch (IOException ioe) {
            Activator.getLogger().error((Throwable)ioe);
        }
        catch (CoreException ce) {
            Activator.getLogger().error((Throwable)ce);
        }
        return null;
    }

    private BundleDetails findBuildArtifactInProjectsOutputFolder(IModule[] module) {
        String file;
        String path;
        File out;
        BundleDetails bd = null;
        IProject prj = module[0].getProject();
        IMavenProjectFacade m2prjFacade = MavenPlugin.getMavenProjectRegistry().create(prj, (IProgressMonitor)new NullProgressMonitor());
        MavenProject m2Project = m2prjFacade.getMavenProject();
        if (m2Project != null && (out = new File(path = m2Project.getBuild().getOutputDirectory(), file = m2Project.getBuild().getFinalName())).exists() && out.isFile()) {
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (JarFile jf = new JarFile(out);){
                    bd = this.createBundleDetails(jf.getManifest());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                Activator.getLogger().error((Throwable)ex);
            }
        }
        return bd;
    }

    private BundleDetails createBundleDetails(Manifest mf) {
        Attributes attributes = mf.getMainAttributes();
        String symName = attributes.getValue("Bundle-SymbolicName");
        String version = attributes.getValue("Bundle-Version");
        return new BundleDetails(symName, version);
    }

    public static class BundleDetails {
        private String symbolicName;
        private String version;

        public BundleDetails(String symbolicName, String version) {
            this.symbolicName = symbolicName;
            this.version = version;
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

