/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.modelgenerator.wsdl.ui.Messages;
import org.teiid.designer.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiConstants;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ColumnInfo;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.proc.wsdl.IWsdlAttributeInfo;
import org.teiid.designer.query.sql.symbol.IElementSymbol;

public class AttributeInfo
implements ModelGeneratorWsdlUiConstants,
IWsdlAttributeInfo {
    private static final StringNameValidator nameValidator = new RelationalStringNameValidator(false);
    private IElementSymbol nameSymbol;
    private String alias;
    private Object xmlElement;
    private ColumnInfo columnInfo;
    private IStatus status;

    public AttributeInfo(Object xmlElement, String name, ColumnInfo columnInfo) {
        this.xmlElement = xmlElement;
        this.initNameSymbol(name);
        this.alias = this.getName();
        this.columnInfo = columnInfo;
        this.validate();
    }

    private void initNameSymbol(String name) {
        IQueryService service = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = service.createQueryFactory();
        this.nameSymbol = factory.createElementSymbol(name.replaceAll("\\.", "_"));
    }

    public String getName() {
        String name = this.nameSymbol.toString();
        return name.replaceAll("\"", "");
    }

    public String getSymbolName() {
        return this.nameSymbol.toString();
    }

    public void setName(String name) {
        CoreArgCheck.isNotNull((Object)name, (String)"name is null");
        this.initNameSymbol(name);
        this.validate();
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String name) {
        CoreArgCheck.isNotNull((Object)name, (String)"alias is null");
        this.alias = name;
        this.validate();
    }

    public String getSignature() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getAlias()).append(" [").append(this.getName()).append(']');
        return sb.toString();
    }

    public void setXmlElement(Object element) {
        this.xmlElement = element;
    }

    public Object getXmlElement() {
        return this.xmlElement;
    }

    public ColumnInfo getColumnInfo() {
        return this.columnInfo;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void setStatus(IStatus status) {
        this.status = status;
    }

    public void validate() {
        String result = nameValidator.checkValidName(this.getAlias());
        if (result != null) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.modelgenerator.wsdl.ui", String.valueOf(Messages.InvalidAttributeAliasName) + this.getAlias()));
            return;
        }
        this.setStatus(Status.OK_STATUS);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("AttributeInfo: ");
        text.append("  name =").append(this.getSymbolName());
        text.append("  alias =").append(this.getAlias());
        return text.toString();
    }
}

