/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.datatools.connection.DataSourceConnectionHelper;
import org.teiid.designer.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiPlugin;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.WSDLImportWizardManager;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ImportWsdlSoapWizard;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.DefaultScrolledComposite;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;

public class ImportWsdlDataSourceDefinitionPage
extends AbstractWizardPage
implements UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ImportWsdlDataSourceDefinitionPage.class);
    private static final String TITLE = ImportWsdlDataSourceDefinitionPage.getString("title");
    private final WSDLImportWizardManager theImportManager;
    private Text jndiNameField;
    private String jndiName;
    private Button autoCreateDataSource;
    private boolean synchronizing;

    private static String getString(String id) {
        return ModelGeneratorWsdlUiPlugin.UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object var) {
        return ModelGeneratorWsdlUiPlugin.UTIL.getString(String.valueOf(I18N_PREFIX) + id, var);
    }

    public ImportWsdlDataSourceDefinitionPage(WSDLImportWizardManager theImportManager, ImportWsdlSoapWizard wizard) {
        super(ImportWsdlDataSourceDefinitionPage.class.getSimpleName(), TITLE);
        this.theImportManager = theImportManager;
    }

    public void createControl(Composite parent) {
        Composite hostPanel = new Composite(parent, 0);
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        hostPanel.setLayoutData((Object)new GridData(1808));
        DefaultScrolledComposite scrolledComposite = new DefaultScrolledComposite(hostPanel);
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        hostPanel.setLayoutData((Object)new GridData(1808));
        Composite mainPanel = scrolledComposite.getPanel();
        mainPanel.setLayoutData((Object)new GridData(1808));
        mainPanel.setLayout((Layout)new GridLayout(1, false));
        Group theGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)ImportWsdlDataSourceDefinitionPage.getString("jndiGroup"), (int)0, (int)2, (int)3);
        theGroup.setLayoutData((Object)new GridData(768));
        ((GridLayout)theGroup.getLayout()).marginLeft = 10;
        ((GridLayout)theGroup.getLayout()).marginRight = 10;
        Label label = WidgetFactory.createLabel((Composite)theGroup, (String)ImportWsdlDataSourceDefinitionPage.getString("jndiLabel"));
        label.setToolTipText(ImportWsdlDataSourceDefinitionPage.getString("jndiToolTip"));
        boolean serverDefined = DataSourceConnectionHelper.isServerDefined();
        boolean serverActive = DataSourceConnectionHelper.isServerConnected();
        this.jndiNameField = WidgetFactory.createTextField((Composite)theGroup);
        this.jndiNameField.setToolTipText(ImportWsdlDataSourceDefinitionPage.getString("jndiToolTip"));
        this.jndiName = this.theImportManager.getJBossJndiName();
        if (!StringUtilities.isEmpty((String)this.jndiName)) {
            this.jndiNameField.setText(this.jndiName);
        } else {
            String modelName = this.theImportManager.getSourceModelName();
            if (!StringUtilities.isEmpty((String)modelName)) {
                if (modelName.toUpperCase().endsWith(".XMI")) {
                    int nameLength = modelName.length();
                    modelName = modelName.substring(0, nameLength - 4);
                }
                this.theImportManager.setJBossJndiNameName(modelName);
                this.jndiName = this.theImportManager.getJBossJndiName();
                this.jndiNameField.setText(this.jndiName);
            }
        }
        this.jndiNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ImportWsdlDataSourceDefinitionPage.this.synchronizing) {
                    return;
                }
                if (ImportWsdlDataSourceDefinitionPage.this.jndiNameField.getText() != null && ImportWsdlDataSourceDefinitionPage.this.jndiNameField.getText().length() > 0) {
                    ImportWsdlDataSourceDefinitionPage.this.jndiName = ImportWsdlDataSourceDefinitionPage.this.jndiNameField.getText();
                    ImportWsdlDataSourceDefinitionPage.this.theImportManager.setJBossJndiNameName(ImportWsdlDataSourceDefinitionPage.this.jndiName);
                } else {
                    ImportWsdlDataSourceDefinitionPage.this.jndiName = "";
                    ImportWsdlDataSourceDefinitionPage.this.theImportManager.setJBossJndiNameName(null);
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.jndiNameField);
        this.autoCreateDataSource = WidgetFactory.createCheckBox((Composite)theGroup, (String)"Auto-create Data Source");
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.autoCreateDataSource);
        this.autoCreateDataSource.setSelection(this.theImportManager.doCreateDataSource());
        if (serverActive) {
            this.autoCreateDataSource.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ImportWsdlDataSourceDefinitionPage.this.theImportManager.setCreateDataSource(ImportWsdlDataSourceDefinitionPage.this.autoCreateDataSource.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.autoCreateDataSource.setEnabled(serverActive);
        if (!serverActive) {
            Group serverMessageGroup = WidgetFactory.createGroup((Composite)theGroup, (String)ImportWsdlDataSourceDefinitionPage.getString("serverUnavailableGroup"), (int)0, (int)2, (int)3);
            serverMessageGroup.setLayoutData((Object)new GridData(768));
            Text msgText = new Text((Composite)serverMessageGroup, 72);
            msgText.setBackground(Display.getCurrent().getSystemColor(19));
            msgText.setForeground(Display.getCurrent().getSystemColor(10));
            GridDataFactory.fillDefaults().span(2, 1).grab(true, false).hint(0, 55).applyTo((Control)serverMessageGroup);
            if (!serverDefined) {
                msgText.setText(ImportWsdlDataSourceDefinitionPage.getString("noServerDefined"));
            } else {
                msgText.setText(ImportWsdlDataSourceDefinitionPage.getString("serverNotStarted"));
            }
        }
        scrolledComposite.sizeScrolledPanel();
        this.setControl((Control)hostPanel);
        this.setMessage(ImportWsdlDataSourceDefinitionPage.getString("initialMessage"));
        this.setPageComplete(true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.synchronizeUI();
        }
    }

    void synchronizeUI() {
        this.synchronizing = true;
        this.jndiName = this.theImportManager.getJBossJndiName();
        if (!StringUtilities.isEmpty((String)this.jndiName)) {
            this.jndiNameField.setText(this.jndiName);
        } else {
            String modelName = this.theImportManager.getSourceModelName();
            if (!StringUtilities.isEmpty((String)modelName)) {
                if (modelName.toUpperCase().endsWith(".XMI")) {
                    int nameLength = modelName.length();
                    modelName = modelName.substring(0, nameLength - 4);
                }
                this.theImportManager.setJBossJndiNameName(modelName);
                this.jndiName = this.theImportManager.getJBossJndiName();
                this.jndiNameField.setText(this.jndiName);
            }
        }
        this.synchronizing = false;
    }
}

