/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap;

import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.modelgenerator.wsdl.model.Operation;
import org.teiid.designer.modelgenerator.wsdl.ui.Messages;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ColumnInfo;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ProcedureGenerator;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ProcedureInfo;
import org.teiid.designer.query.IProcedureService;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.proc.wsdl.IWsdlConstants;
import org.teiid.designer.query.proc.wsdl.IWsdlResponseInfo;

public class ResponseInfo
extends ProcedureInfo
implements IWsdlResponseInfo {
    public ResponseInfo(Operation operation, ProcedureGenerator generator) {
        super(operation, IWsdlConstants.ProcedureType.RESPONSE, generator);
        this.setProcedureName(this.getDefaultProcedureName());
    }

    @Override
    public String getDefaultProcedureName() {
        return String.valueOf(this.getOperation().getName()) + "_response";
    }

    @Override
    public IStatus validate() {
        IStatus nameStatus;
        MultiStatus status = new MultiStatus("org.teiid.designer.modelgenerator.wsdl.ui", 0, null, null);
        if (this.getProcedureName() == null) {
            status.add((IStatus)new Status(4, "org.teiid.designer.modelgenerator.wsdl.ui", NLS.bind((String)Messages.Error_Operation_0_ResponseProcedureNameCannotBeNullOrEmpty, (Object)this.getOperation().getName())));
        }
        if ((nameStatus = this.getGenerator().getNameStatus(this.getProcedureName())).getSeverity() > 1) {
            status.merge(nameStatus);
        }
        if (this.getBodyColumnInfoList().length == 0) {
            status.add((IStatus)new Status(4, "org.teiid.designer.modelgenerator.wsdl.ui", NLS.bind((String)Messages.Error_NoColumnsDefinedForResponseProcedureForOperation_0, (Object)this.getOperation().getName(), (Object)this.getOperation().getName())));
        }
        ColumnInfo[] columnInfoArray = this.getBodyColumnInfoList();
        int n = columnInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnInfo info = columnInfoArray[n2];
            if (info.getStatus().getSeverity() > 1) {
                return info.getStatus();
            }
            ++n2;
        }
        this.setChanged(false);
        return status;
    }

    @Override
    public String getSqlStringTemplate() {
        return this.getSqlString(new Properties());
    }

    @Override
    public String getSqlString(Properties properties) {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IProcedureService procedureService = queryService.getProcedureService();
        return procedureService.getSQLStatement((IWsdlResponseInfo)this, properties);
    }
}

