/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoHelper;
import org.teiid.designer.modelgenerator.wsdl.ui.Messages;
import org.teiid.designer.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiConstants;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.WSDLImportWizardManager;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.wizards.file.FlatFileRelationalModelFactory;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelResourceSelectionValidator;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;

public class ImportOptionsPanel
implements IChangeListener,
ModelGeneratorWsdlUiConstants {
    private Text sourceModelFileText;
    private Text sourceModelContainerText;
    private Text sourceModelHelpText;
    private Text viewModelFileText;
    private Text viewModelContainerText;
    private Text viewModelHelpText;
    private Combo projectCombo;
    private IConnectionInfoHelper connectionInfoHelper;
    private final WSDLImportWizardManager importManager;
    private ModelWorkspaceManager modelWorkspaceManager = ModelWorkspaceManager.getModelWorkspaceManager();
    ModelingResourceFilter locationFilter = new ModelingResourceFilter();
    private boolean refreshing = false;
    final ViewerFilter sourceModelFilter = new ModelWorkspaceViewerFilter(true){

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof IResource) {
                IProject proj = ((IResource)element).getProject();
                if (proj == null) {
                    return false;
                }
                IProject targetProj = ImportOptionsPanel.this.importManager.getTargetProject();
                if (targetProj != null && targetProj != proj) {
                    return false;
                }
                boolean projectOpen = ((IResource)element).getProject().isOpen();
                if (projectOpen) {
                    if (element instanceof IProject) {
                        try {
                            return ((IProject)element).hasNature("org.teiid.designer.core.modelNature");
                        }
                        catch (CoreException e) {
                            UiConstants.Util.log((Throwable)e);
                            return false;
                        }
                    }
                    if (element instanceof IContainer) {
                        return true;
                    }
                    if (element instanceof IFile && ModelUtil.isModelFile((IResource)((IFile)element))) {
                        ModelResource theModel = null;
                        try {
                            theModel = ModelUtil.getModelResource((IFile)((IFile)element), (boolean)true);
                        }
                        catch (Exception ex) {
                            ModelerCore.Util.log((Throwable)ex);
                            return false;
                        }
                        if (theModel != null && ModelIdentifier.isRelationalSourceModel((ModelResource)theModel)) {
                            return true;
                        }
                    }
                }
            }
            return false;
        }
    };
    final ViewerFilter viewModelFilter = new ModelWorkspaceViewerFilter(true){

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof IResource) {
                IProject proj = ((IResource)element).getProject();
                if (proj == null) {
                    return false;
                }
                IProject targetProj = ImportOptionsPanel.this.importManager.getTargetProject();
                if (targetProj != null && targetProj != proj) {
                    return false;
                }
                boolean projectOpen = ((IResource)element).getProject().isOpen();
                if (projectOpen) {
                    if (element instanceof IProject) {
                        try {
                            return ((IProject)element).hasNature("org.teiid.designer.core.modelNature");
                        }
                        catch (CoreException e) {
                            UiConstants.Util.log((Throwable)e);
                            return false;
                        }
                    }
                    if (element instanceof IContainer) {
                        return true;
                    }
                    if (element instanceof IFile && ModelUtil.isModelFile((IResource)((IFile)element))) {
                        ModelResource theModel = null;
                        try {
                            theModel = ModelUtil.getModelResource((IFile)((IFile)element), (boolean)true);
                        }
                        catch (Exception ex) {
                            ModelerCore.Util.log((Throwable)ex);
                            return false;
                        }
                        if (theModel != null && ModelIdentifier.isRelationalViewModel((ModelResource)theModel)) {
                            return true;
                        }
                    }
                }
            }
            return false;
        }
    };

    public ImportOptionsPanel(Composite parent, WSDLImportWizardManager importManager) {
        this.importManager = importManager;
        this.importManager.addChangeListener(this);
        this.init(parent);
    }

    private void init(Composite parent) {
        this.connectionInfoHelper = new ConnectionInfoHelper();
        Group projectGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.TargetProject, (int)0, (int)1, (int)2);
        projectGroup.setLayoutData((Object)new GridData(768));
        ((GridData)projectGroup.getLayoutData()).widthHint = 400;
        Label label = new Label((Composite)projectGroup, 0);
        label.setText(Messages.SelectOpenModelProject);
        LabelProvider srcLabelProvider = new LabelProvider(){

            public String getText(Object project) {
                return ((IProject)project).getName();
            }
        };
        this.projectCombo = WidgetFactory.createCombo((Composite)projectGroup, (int)8, (int)768, (List)((ArrayList)DotProjectUtils.getOpenModelProjects()), null, (ILabelProvider)srcLabelProvider, (boolean)true);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.projectCombo);
        if (this.importManager.getTargetProject() != null) {
            String projName = this.importManager.getTargetProject().getName();
            int count = 0;
            int index = -1;
            String[] stringArray = this.projectCombo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.equals(projName)) {
                    index = count;
                } else {
                    ++count;
                }
                ++n2;
            }
            if (index > -1) {
                this.projectCombo.select(index);
            }
        }
        this.projectCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IProject proj = ImportOptionsPanel.this.getProject((IPath)new Path(ImportOptionsPanel.this.projectCombo.getText()));
                boolean changed = ImportOptionsPanel.this.importManager.setTargetProject(proj);
                if (changed) {
                    ImportOptionsPanel.this.sourceModelContainerText.setText(ImportOptionsPanel.this.importManager.getSourceModelLocation().getFullPath().makeRelative().toString());
                    ImportOptionsPanel.this.viewModelContainerText.setText(ImportOptionsPanel.this.importManager.getSourceModelLocation().getFullPath().makeRelative().toString());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group group = WidgetFactory.createGroup((Composite)parent, (String)Messages.SourceModelDefinition, (int)768, (int)1, (int)3);
        ((GridData)group.getLayoutData()).widthHint = 400;
        Label locationLabel = new Label((Composite)group, 0);
        locationLabel.setText(Messages.Location);
        this.sourceModelContainerText = new Text((Composite)group, 2052);
        GridData gridData = new GridData(768);
        this.sourceModelContainerText.setLayoutData((Object)gridData);
        WidgetUtil.colorizeWidget((Control)this.sourceModelContainerText, (int)1, (boolean)true);
        this.sourceModelContainerText.setEditable(false);
        Button browseButton = new Button((Composite)group, 8);
        gridData = new GridData();
        browseButton.setLayoutData((Object)gridData);
        browseButton.setText(Messages.BrowseElipsis);
        browseButton.setToolTipText(NLS.bind((String)Messages.BrowseToSelectModelsLocation, (Object)Messages.Source_lower));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportOptionsPanel.this.handleSourceModelLocationBrowse();
            }
        });
        Label fileLabel = new Label((Composite)group, 0);
        fileLabel.setText(Messages.Name);
        fileLabel.setToolTipText(Messages.SourceNameTooltip);
        this.sourceModelFileText = new Text((Composite)group, 2052);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.sourceModelFileText.setLayoutData((Object)gridData);
        this.sourceModelFileText.setToolTipText(Messages.SourceNameTooltip);
        WidgetUtil.colorizeWidget((Control)this.sourceModelFileText, (int)1, (boolean)false);
        this.sourceModelFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportOptionsPanel.this.handleSourceModelTextChanged();
            }
        });
        browseButton = new Button((Composite)group, 8);
        gridData = new GridData();
        browseButton.setLayoutData((Object)gridData);
        browseButton.setText(Messages.BrowseElipsis);
        browseButton.setToolTipText(NLS.bind((String)Messages.BrowseToSelect_0_Model, (Object)Messages.Source_lower));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportOptionsPanel.this.handleSourceModelBrowse();
            }
        });
        Group helpGroup = WidgetFactory.createGroup((Composite)group, (String)Messages.Status, (int)2, (int)3);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        helpGroup.setLayoutData((Object)gd);
        this.sourceModelHelpText = new Text((Composite)helpGroup, 72);
        WidgetUtil.colorizeWidget((Control)this.sourceModelHelpText, (int)1, (boolean)true);
        gd = new GridData(1808);
        gd.heightHint = 40;
        gd.widthHint = 300;
        this.sourceModelHelpText.setLayoutData((Object)gd);
        group = WidgetFactory.createGroup((Composite)parent, (String)Messages.ViewModelDefinition, (int)768, (int)1, (int)3);
        locationLabel = new Label((Composite)group, 0);
        locationLabel.setText(Messages.Location);
        this.viewModelContainerText = new Text((Composite)group, 2052);
        gridData = new GridData(768);
        this.viewModelContainerText.setLayoutData((Object)gridData);
        WidgetUtil.colorizeWidget((Control)this.viewModelContainerText, (int)1, (boolean)true);
        this.viewModelContainerText.setEditable(false);
        browseButton = new Button((Composite)group, 8);
        gridData = new GridData();
        browseButton.setLayoutData((Object)gridData);
        browseButton.setText(Messages.BrowseElipsis);
        browseButton.setToolTipText(NLS.bind((String)Messages.BrowseToSelectModelsLocation, (Object)Messages.Source_lower));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportOptionsPanel.this.handleViewModelLocationBrowse();
            }
        });
        fileLabel = new Label((Composite)group, 0);
        fileLabel.setText(Messages.Name);
        fileLabel.setToolTipText(Messages.ViewNameTooltip);
        this.viewModelFileText = new Text((Composite)group, 2052);
        gridData = new GridData(768);
        this.viewModelFileText.setLayoutData((Object)gridData);
        this.viewModelFileText.setToolTipText(Messages.ViewNameTooltip);
        WidgetUtil.colorizeWidget((Control)this.viewModelFileText, (int)1, (boolean)false);
        this.viewModelFileText.setForeground(WidgetUtil.getDarkBlueColor());
        this.viewModelFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportOptionsPanel.this.handleViewModelTextChanged();
            }
        });
        browseButton = new Button((Composite)group, 8);
        gridData = new GridData();
        browseButton.setLayoutData((Object)gridData);
        browseButton.setText(Messages.BrowseElipsis);
        browseButton.setToolTipText(NLS.bind((String)Messages.BrowseToSelect_0_Model, (Object)Messages.View_lower));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportOptionsPanel.this.handleViewModelBrowse();
            }
        });
        helpGroup = WidgetFactory.createGroup((Composite)group, (String)Messages.Status, (int)2, (int)3);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        helpGroup.setLayoutData((Object)gd);
        this.viewModelHelpText = new Text((Composite)helpGroup, 72);
        WidgetUtil.colorizeWidget((Control)this.viewModelHelpText, (int)1, (boolean)true);
        gd = new GridData(1808);
        gd.heightHint = 40;
        gd.widthHint = 300;
        this.viewModelHelpText.setLayoutData((Object)gd);
    }

    public void setVisible() {
        this.refreshing = true;
        this.refreshUiFromManager();
        this.refreshing = false;
    }

    void handleSourceModelLocationBrowse() {
        IProject proj = this.importManager.getTargetProject();
        this.locationFilter.setSingleProjectProject(proj);
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)ModelerCore.getWorkspace().getRoot(), (ViewerFilter)this.locationFilter, (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null && this.sourceModelContainerText != null) {
            this.importManager.setSourceModelLocation(folder);
            this.sourceModelContainerText.setText(folder.getFullPath().makeRelative().toString());
        }
        this.notifyChanged();
    }

    void handleViewModelLocationBrowse() {
        IProject proj = this.importManager.getTargetProject();
        this.locationFilter.setSingleProjectProject(proj);
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)ModelerCore.getWorkspace().getRoot(), (ViewerFilter)this.locationFilter, (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null && this.sourceModelContainerText != null) {
            this.importManager.setViewModelLocation(folder);
            this.viewModelContainerText.setText(folder.getFullPath().makeRelative().toString());
        }
        this.notifyChanged();
    }

    void handleSourceModelBrowse() {
        Object[] selections = WidgetUtil.showWorkspaceObjectSelectionDialog((String)"Select Source Model", (String)"Select Source Model Message", (boolean)false, null, (ViewerFilter)this.sourceModelFilter, (ISelectionStatusValidator)new ModelResourceSelectionValidator(false), (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        if (selections != null && selections.length == 1 && this.sourceModelFileText != null && selections[0] instanceof IFile) {
            IFile selectedFile = (IFile)selections[0];
            IContainer folder = selectedFile.getParent();
            String modelName = selectedFile.getFullPath().lastSegment();
            this.importManager.setSourceModelExists(true);
            this.importManager.setSourceModelLocation(folder);
            this.importManager.setSourceModelName(modelName);
            this.sourceModelContainerText.setText(folder.getFullPath().makeRelative().toString());
            this.sourceModelFileText.setText(modelName);
        }
        this.notifyChanged();
    }

    void handleViewModelBrowse() {
        Object[] selections = WidgetUtil.showWorkspaceObjectSelectionDialog((String)"Select Source Model", (String)"Select Source Model Message", (boolean)false, null, (ViewerFilter)this.sourceModelFilter, (ISelectionStatusValidator)new ModelResourceSelectionValidator(false), (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        if (selections != null && selections.length == 1 && this.sourceModelFileText != null && selections[0] instanceof IFile) {
            IFile selectedFile = (IFile)selections[0];
            IContainer folder = selectedFile.getParent();
            String modelName = selectedFile.getFullPath().lastSegment();
            this.importManager.setViewModelExists(true);
            this.importManager.setViewModelLocation(folder);
            this.importManager.setViewModelName(modelName);
            this.viewModelContainerText.setText(folder.getFullPath().makeRelative().toString());
            this.viewModelFileText.setText(modelName);
        }
        this.notifyChanged();
    }

    void handleViewModelTextChanged() {
        if (this.refreshing) {
            return;
        }
        String newName = "";
        if (this.viewModelFileText.getText() != null) {
            if (this.viewModelFileText.getText().length() == 0) {
                this.importManager.setViewModelName(newName);
                this.importManager.setViewModelExists(false);
            } else {
                newName = this.viewModelFileText.getText();
                this.importManager.setViewModelName(newName);
                this.importManager.setViewModelExists(this.viewModelExists());
            }
        }
        this.notifyChanged();
    }

    void handleSourceModelTextChanged() {
        if (this.refreshing) {
            return;
        }
        String newName = "";
        if (this.sourceModelFileText.getText() != null) {
            if (this.sourceModelFileText.getText().length() == 0) {
                this.importManager.setSourceModelName(newName);
                this.importManager.setSourceModelExists(false);
            } else {
                newName = this.sourceModelFileText.getText();
                this.importManager.setSourceModelName(newName);
                this.importManager.setSourceModelExists(this.sourceModelExists());
            }
        }
        this.notifyChanged();
    }

    private boolean viewModelExists() {
        if (this.importManager.getViewModelLocation() == null) {
            return false;
        }
        return this.modelWorkspaceManager.modelExists(this.importManager.getViewModelLocation().getFullPath().toOSString(), this.viewModelFileText.getText());
    }

    private boolean sourceModelExists() {
        if (this.importManager.getSourceModelLocation() == null) {
            return false;
        }
        return this.modelWorkspaceManager.modelExists(this.importManager.getSourceModelLocation().getFullPath().toOSString(), this.sourceModelFileText.getText());
    }

    public void refreshUiFromManager() {
        IContainer viewLocation;
        this.refreshing = true;
        IContainer sourceLocation = this.importManager.getSourceModelLocation();
        if (sourceLocation != null) {
            this.sourceModelContainerText.setText(sourceLocation.getFullPath().makeRelative().toString());
        }
        if (this.importManager.getSourceModelName() != null && !this.sourceModelFileText.getText().equals(this.importManager.getSourceModelName())) {
            this.sourceModelFileText.setText(this.importManager.getSourceModelName());
        }
        if ((viewLocation = this.importManager.getViewModelLocation()) != null) {
            this.viewModelContainerText.setText(viewLocation.getFullPath().makeRelative().toString());
        }
        if (this.importManager.getViewModelName() != null && !this.viewModelFileText.getText().equals(this.importManager.getViewModelName())) {
            this.viewModelFileText.setText(this.importManager.getViewModelName());
        }
        this.setSourceModelHelpMessage();
        this.setViewModelHelpMessage();
        this.updateDesignerProperties();
        this.refreshing = false;
    }

    private void setSourceModelHelpMessage() {
        String message = NLS.bind((String)Messages.Status_SourceModelDoesNotExistAndWillBeCreated, (Object)this.sourceModelFileText.getText());
        if (this.sourceModelExists()) {
            message = !this.sourceModelHasConnectionProfile() ? NLS.bind((String)Messages.Status_ExistingSourceModelHasNoProfile, (Object)this.sourceModelFileText.getText()) : (!this.sourceModelHasSameConnectionProfile() ? NLS.bind((String)Messages.Status_ExistingSourceModelHasWrongProfile, (Object)this.sourceModelFileText.getText()) : (this.sourceHasProcedure() ? NLS.bind((String)Messages.Status_ExistingSourceModelAlreadyContainsInvoke, (Object)this.sourceModelFileText.getText()) : NLS.bind((String)Messages.Status_ExistingSourceModelMissingInvoke, (Object)this.sourceModelFileText.getText())));
        } else if (this.importManager.getSourceModelName() == null || this.importManager.getSourceModelName().length() == 0) {
            message = Messages.Status_SourceModelNameCannotBeNullOrEmpty;
        }
        this.sourceModelHelpText.setText(message);
    }

    private void setViewModelHelpMessage() {
        String message = NLS.bind((String)Messages.Status_ViewModelDoesNotExistAndWillBeCreated, (Object)this.viewModelFileText.getText());
        if (this.viewModelExists()) {
            message = NLS.bind((String)Messages.Statis_ViewModelAlreadyExists, (Object)this.viewModelFileText.getText());
        } else if (this.importManager.getViewModelName() == null || this.importManager.getViewModelName().length() == 0) {
            message = Messages.Status_ViewModelNameCannotBeNullOrEmpty;
        }
        this.viewModelHelpText.setText(message);
    }

    private boolean sourceHasProcedure() {
        if (!this.sourceModelExists()) {
            return false;
        }
        try {
            IFile sourceModel = ModelUtilities.getModelFile((String)this.importManager.getSourceModelLocation().getFullPath().toOSString(), (String)this.sourceModelFileText.getText());
            ModelResource smr = ModelUtilities.getModelResourceForIFile((IFile)sourceModel, (boolean)false);
            if (smr != null) {
                return FlatFileRelationalModelFactory.procedureExists((ModelResource)smr, (String)"invoke");
            }
        }
        catch (ModelWorkspaceException ex) {
            ModelGeneratorWsdlUiConstants.UTIL.log(4, (Throwable)ex, NLS.bind((String)Messages.Error_DeterminingSourceModelHas_0_Procedure, (Object)"invoke"));
        }
        return false;
    }

    private boolean sourceModelHasConnectionProfile() {
        if (!this.sourceModelExists()) {
            return false;
        }
        try {
            IFile sourceModel = ModelUtilities.getModelFile((String)this.importManager.getSourceModelLocation().getFullPath().toOSString(), (String)this.sourceModelFileText.getText());
            ModelResource smr = ModelUtilities.getModelResourceForIFile((IFile)sourceModel, (boolean)false);
            if (smr != null) {
                IConnectionProfile profile = this.connectionInfoHelper.getConnectionProfile(smr);
                return profile != null && this.importManager.getConnectionProfile() != null;
            }
        }
        catch (ModelWorkspaceException ex) {
            ModelGeneratorWsdlUiConstants.UTIL.log(4, (Throwable)ex, Messages.Error_DeterminingSourceModelHasProfile);
        }
        return false;
    }

    private boolean sourceModelHasSameConnectionProfile() {
        block5: {
            IConnectionProfile profile;
            block6: {
                if (!this.sourceModelExists()) {
                    return false;
                }
                IFile sourceModel = ModelUtilities.getModelFile((String)this.importManager.getSourceModelLocation().getFullPath().toOSString(), (String)this.sourceModelFileText.getText());
                ModelResource smr = ModelUtilities.getModelResourceForIFile((IFile)sourceModel, (boolean)false);
                if (smr == null) break block5;
                profile = this.connectionInfoHelper.getConnectionProfile(smr);
                if (profile != null && this.importManager.getConnectionProfile() != null) break block6;
                return false;
            }
            try {
                if (profile.getName().equalsIgnoreCase(this.importManager.getConnectionProfile().getName())) {
                    return true;
                }
            }
            catch (ModelWorkspaceException ex) {
                ModelGeneratorWsdlUiConstants.UTIL.log(4, (Throwable)ex, Messages.Error_DeterminingSourceModelHasMatchingProfile);
            }
        }
        return false;
    }

    private void updateDesignerProperties() {
        Properties designerProperties = this.importManager.getDesignerProperties();
        if (designerProperties != null) {
            if (this.sourceModelFileText.getText() != null) {
                DesignerPropertiesUtil.setSourceModelName((Properties)designerProperties, (String)this.sourceModelFileText.getText());
            }
            if (this.importManager.getSourceModelLocation() != null) {
                DesignerPropertiesUtil.setProjectName((Properties)designerProperties, (String)this.importManager.getSourceModelLocation().getProject().getName());
            }
            if (this.viewModelFileText.getText() != null) {
                DesignerPropertiesUtil.setViewModelName((Properties)designerProperties, (String)this.viewModelFileText.getText());
            }
        }
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.refreshing = true;
        this.refreshUiFromManager();
        this.refreshing = false;
    }

    public void notifyChanged() {
        this.importManager.notifyChanged();
    }

    private IProject getProject(IPath path) {
        if (path == null) {
            return null;
        }
        Path actualPath = new Path(String.valueOf('/') + path.toString());
        ModelWorkspaceItem item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem((IPath)actualPath, 2);
        if (item == null) {
            item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem((IPath)actualPath, 4);
        }
        if (item != null) {
            return item.getResource().getProject();
        }
        return null;
    }
}

