/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.xsd.impl.XSDAttributeUseImpl;
import org.eclipse.xsd.impl.XSDElementDeclarationImpl;
import org.eclipse.xsd.impl.XSDParticleImpl;
import org.teiid.designer.modelgenerator.wsdl.ui.Messages;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ImportWsdlSchemaHandler;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.OperationsDetailsPage;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ProcedureInfo;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.SchemaTreeModel;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels.ElementsInfoPanel;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class RequestSchemaContentsGroup {
    TreeViewer schemaTreeViewer;
    Action createElementAction;
    ElementsInfoPanel elementsInfoPanel;
    int type;
    final OperationsDetailsPage detailsPage;

    public RequestSchemaContentsGroup(Composite parent, int type, OperationsDetailsPage detailsPage) {
        this.type = type;
        this.detailsPage = detailsPage;
        this.createPanel(parent);
    }

    private void createPanel(Composite parent) {
        Group schemaContentsGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.SchemaContents, (int)0, (int)1, (int)4);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 120;
        schemaContentsGroup.setLayoutData((Object)gd);
        this.schemaTreeViewer = new TreeViewer((Composite)schemaContentsGroup, 4);
        this.schemaTreeViewer.setContentProvider(this.detailsPage.getSchemaContentProvider());
        this.schemaTreeViewer.setLabelProvider((IBaseLabelProvider)this.detailsPage.getSchemaLabelProvider());
        this.schemaTreeViewer.setAutoExpandLevel(3);
        GridData data = new GridData(1808);
        data.horizontalSpan = 4;
        this.schemaTreeViewer.getControl().setLayoutData((Object)data);
        this.schemaTreeViewer.setInput(null);
        final MenuManager columnMenuManager = new MenuManager();
        this.schemaTreeViewer.getControl().setMenu(columnMenuManager.createContextMenu((Control)parent));
        this.schemaTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object element;
                columnMenuManager.removeAll();
                IStructuredSelection selection = (IStructuredSelection)RequestSchemaContentsGroup.this.schemaTreeViewer.getSelection();
                if (selection.size() == 1 && selection.getFirstElement() instanceof SchemaTreeModel.SchemaNode && ((element = ((SchemaTreeModel.SchemaNode)selection.getFirstElement()).getElement()) instanceof XSDParticleImpl || element instanceof XSDElementDeclarationImpl || element instanceof XSDAttributeUseImpl)) {
                    columnMenuManager.add((IAction)RequestSchemaContentsGroup.this.createElementAction);
                }
            }
        });
        this.schemaTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof SchemaTreeModel.SchemaNode && ImportWsdlSchemaHandler.shouldCreateRequestColumn(element = ((SchemaTreeModel.SchemaNode)selection.getFirstElement()).getElement())) {
                    RequestSchemaContentsGroup.this.createRequestColumn();
                }
            }
        });
        this.createElementAction = new Action(Messages.AddAsNewElement){

            public void run() {
                RequestSchemaContentsGroup.this.createRequestColumn();
            }
        };
    }

    public void setElementsInfoPanel(ElementsInfoPanel panel) {
        this.elementsInfoPanel = panel;
    }

    public String createRequestColumn() {
        return this.detailsPage.getSchemaHandler().createRequestColumn(this.type, (IStructuredSelection)this.schemaTreeViewer.getSelection(), this.getRequestInfo());
    }

    public void setInput(Object value) {
        this.schemaTreeViewer.setInput(value);
        this.elementsInfoPanel.disableButtons();
    }

    private ProcedureInfo getRequestInfo() {
        return this.detailsPage.getProcedureGenerator().getRequestInfo();
    }

    public void setEnabled(boolean enable) {
        this.schemaTreeViewer.getTree().setEnabled(enable);
        this.elementsInfoPanel.setEnabled(enable);
    }
}

