/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels;

import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.modelgenerator.wsdl.model.Operation;
import org.teiid.designer.modelgenerator.wsdl.ui.Messages;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.OperationsDetailsPage;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlTextViewer;
import org.teiid.designer.ui.common.graphics.ColorManager;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;

public class WrapperProcedurePanel {
    Text wrapperProcedureText;
    SqlTextViewer sqlTextViewer;
    IDocument sqlDocument;
    IStatus status;
    final OperationsDetailsPage detailsPage;

    public WrapperProcedurePanel(Composite parent, OperationsDetailsPage detailsPage) {
        this.detailsPage = detailsPage;
        this.init(parent);
    }

    private void init(Composite parent) {
        Label procedureNameLabel = new Label(parent, 0);
        procedureNameLabel.setText(Messages.GeneratedProcedureName);
        this.wrapperProcedureText = new Text(parent, 2052);
        GridData gridData = new GridData(768);
        this.wrapperProcedureText.setLayoutData((Object)gridData);
        this.wrapperProcedureText.setForeground(WidgetUtil.getDarkBlueColor());
        this.wrapperProcedureText.setEditable(true);
        this.wrapperProcedureText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WrapperProcedurePanel.this.handleWrapperProcedureNameChanged();
            }
        });
        this.wrapperProcedureText.setEnabled(true);
        Group group = WidgetFactory.createGroup((Composite)parent, (String)Messages.GeneratedSQLStatement, (int)0, (int)2);
        GridData gd = new GridData(1808);
        group.setLayoutData((Object)gd);
        ColorManager colorManager = new ColorManager();
        int styles = 68162;
        this.sqlTextViewer = new SqlTextViewer((Composite)group, (IVerticalRuler)new VerticalRuler(0), styles, colorManager);
        this.sqlDocument = new Document();
        this.sqlTextViewer.setInput((Object)this.sqlDocument);
        this.sqlTextViewer.setEditable(false);
        this.sqlTextViewer.getTextWidget().setEnabled(true);
        this.sqlTextViewer.getTextWidget().setBackground(Display.getCurrent().getSystemColor(19));
        this.sqlDocument.set("");
        this.sqlTextViewer.getControl().setLayoutData((Object)new GridData(1808));
    }

    public void notifyOperationChanged(Operation operation) {
        this.validate();
        this.updateUi();
    }

    private void updateUi() {
        this.wrapperProcedureText.setText(this.detailsPage.getProcedureGenerator().getWrapperProcedureName());
        this.sqlTextViewer.getDocument().set(this.detailsPage.getProcedureGenerator().getWrapperSqlString());
    }

    private void handleWrapperProcedureNameChanged() {
        this.detailsPage.getProcedureGenerator().setWrapperProcedureName(this.wrapperProcedureText.getText());
        this.sqlTextViewer.getDocument().set(this.detailsPage.getProcedureGenerator().getWrapperSqlString());
        this.validate();
    }

    private void validate() {
        this.detailsPage.updateStatus();
        this.updateDesignerProperties();
    }

    public IStatus getStatus() {
        return this.status;
    }

    private void updateDesignerProperties() {
        Properties designerProperties;
        if (this.detailsPage.getProcedureGenerator().getWrapperProcedureName() != null && (designerProperties = this.detailsPage.getImportManager().getDesignerProperties()) != null) {
            DesignerPropertiesUtil.setPreviewTargetObjectName((Properties)designerProperties, (String)this.detailsPage.getProcedureGenerator().getWrapperProcedureName());
            DesignerPropertiesUtil.setPreviewTargetModelName((Properties)designerProperties, (String)this.detailsPage.getImportManager().getViewModelName());
        }
    }

    public void setVisible() {
        this.validate();
    }
}

