/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.designer.modelgenerator.wsdl.model.Fault;
import org.teiid.designer.modelgenerator.wsdl.model.Model;
import org.teiid.designer.modelgenerator.wsdl.model.ModelGenerationException;
import org.teiid.designer.modelgenerator.wsdl.model.Operation;
import org.teiid.designer.modelgenerator.wsdl.model.WSDLElement;
import org.teiid.designer.modelgenerator.wsdl.ui.Messages;
import org.teiid.designer.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiConstants;
import org.teiid.designer.modelgenerator.wsdl.ui.util.ModelGeneratorWsdlUiUtil;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.WSDLImportWizardManager;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.WsdlDefinitionPage;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.common.widget.Label;

public class WsdlOperationsPanel
implements FileUtils.Constants,
CoreStringUtil.Constants,
ModelGeneratorWsdlUiConstants,
ModelGeneratorWsdlUiConstants.Images {
    Text defaultBindingText;
    Combo defaultServiceModeCombo;
    TableViewerBuilder operationsViewerBuilder;
    TableViewerColumn operationNameColumn;
    Button selectAllButton;
    Button deselectAllButton;
    Text detailsTextBox;
    Composite parentComposite;
    WSDLImportWizardManager importManager;
    WsdlDefinitionPage wsdlPage;
    Model wsdlModel = null;
    private IStatus panelStatus;

    public WsdlOperationsPanel(Composite parent, WsdlDefinitionPage wsdlPage, WSDLImportWizardManager theImportManager) {
        this.parentComposite = parent;
        this.wsdlPage = wsdlPage;
        this.importManager = theImportManager;
        this.importManager.setSelectedOperations(new ArrayList<Operation>());
        Composite portPanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)768);
        GridLayout layout = new GridLayout(4, false);
        portPanel.setLayout((Layout)layout);
        Label label = WidgetFactory.createLabel((Composite)portPanel, (String)Messages.DefaultBinding);
        GridData gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        label.setLayoutData((Object)gd);
        label.setToolTipText(Messages.DefaultBinding_tooltip);
        this.defaultBindingText = new Text(portPanel, 2052);
        this.defaultBindingText.setBackground(Display.getCurrent().getSystemColor(19));
        this.defaultBindingText.setForeground(Display.getCurrent().getSystemColor(10));
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.widthHint = 200;
        this.defaultBindingText.setLayoutData((Object)gd);
        this.defaultBindingText.setToolTipText(Messages.DefaultBinding_tooltip);
        label = WidgetFactory.createLabel((Composite)portPanel, (String)Messages.DefaultServiceMode);
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        label.setLayoutData((Object)gd);
        label.setToolTipText(Messages.DefaultServiceMode_tooltip);
        this.defaultServiceModeCombo = WidgetFactory.createCombo((Composite)portPanel, (int)8, (int)768, (Object[])WSDLImportWizardManager.SERVICE_MODES, (Object)true);
        this.defaultServiceModeCombo.setForeground(Display.getCurrent().getSystemColor(10));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.defaultServiceModeCombo.setToolTipText(Messages.DefaultServiceMode_tooltip);
        this.defaultServiceModeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WsdlOperationsPanel.this.handleDefaultServiceModeSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.defaultServiceModeCombo.select(1);
        this.createPanel(parent);
    }

    void updateTreeSelectionDetails() {
        TableItem[] selections = this.operationsViewerBuilder.getTable().getSelection();
        if (selections != null && selections.length > 0) {
            if (selections.length == 1) {
                TableItem selectedItem = selections[0];
                this.updateSelectionDetailsArea(selectedItem.getData());
            } else {
                this.detailsTextBox.setText(Messages.MultipleOperationsSelected_msg);
            }
        } else {
            this.detailsTextBox.setText(Messages.NoOperationsSelected_msg);
        }
    }

    public void createPanel(Composite theParent) {
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        GridLayout layout = new GridLayout(1, false);
        pnlMain.setLayout((Layout)layout);
        this.createCheckboxTableComposite(pnlMain, Messages.WsdlOperationsPage_checkboxTreeGroup_title);
    }

    private void createCheckboxTableComposite(Composite parent, String title) {
        Group group = WidgetFactory.createGroup((Composite)parent, (String)title, (int)1808, (int)1, (int)2);
        Composite buttonComposite = WidgetFactory.createPanel((Composite)group, (int)0, (int)1040);
        GridLayout layout = new GridLayout(1, false);
        buttonComposite.setLayout((Layout)layout);
        this.selectAllButton = WidgetFactory.createButton((Composite)buttonComposite, (String)Messages.WsdlOperationsPage_selectAllButton_text, (int)768);
        this.selectAllButton.setToolTipText(Messages.WsdlOperationsPage_selectAllButton_tipText);
        this.deselectAllButton = WidgetFactory.createButton((Composite)buttonComposite, (String)Messages.WsdlOperationsPage_deselectAllButton_text, (int)768);
        this.deselectAllButton.setToolTipText(Messages.WsdlOperationsPage_deselectAllButton_tipText);
        this.selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WsdlOperationsPanel.this.setAllNodesSelected(true);
                WsdlOperationsPanel.this.updateImportManager();
                WsdlOperationsPanel.this.setPageStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WsdlOperationsPanel.this.setAllNodesSelected(false);
                WsdlOperationsPanel.this.updateImportManager();
                WsdlOperationsPanel.this.setPageStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.operationsViewerBuilder = new TableViewerBuilder((Composite)group, 2850);
        this.operationsViewerBuilder.setContentProvider((IContentProvider)new CheckboxTreeContentProvider());
        this.operationsViewerBuilder.setLabelProvider((IBaseLabelProvider)new CheckboxTreeLabelProvider());
        this.operationsViewerBuilder.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WsdlOperationsPanel.this.updateTreeSelectionDetails();
                if (e.detail == 32) {
                    WsdlOperationsPanel.this.updateImportManager();
                    WsdlOperationsPanel.this.setPageStatus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.operationNameColumn = this.operationsViewerBuilder.createColumn(16384, 100, 50, false);
        this.operationNameColumn.getColumn().setText(Messages.Operation);
        this.operationNameColumn.setLabelProvider((CellLabelProvider)new OperationsColumnLabelProvider());
        CLabel theLabel = new CLabel((Composite)group, 0);
        theLabel.setText(Messages.WsdlOperationsPage_detailsTextbox_title);
        GridData gridData = new GridData(0);
        gridData.horizontalSpan = 1;
        theLabel.setLayoutData((Object)gridData);
        this.detailsTextBox = new Text((Composite)group, 2818);
        gridData = new GridData(768);
        gridData.heightHint = 70;
        gridData.horizontalSpan = 2;
        this.detailsTextBox.setLayoutData((Object)gridData);
        this.detailsTextBox.setEditable(false);
    }

    private void updateSelectionDetailsArea(Object selectedObject) {
        StringBuffer sb = new StringBuffer();
        if (selectedObject instanceof Operation) {
            this.addOperationDetails((Operation)selectedObject, sb);
        }
        this.detailsTextBox.setText(sb.toString());
    }

    private void addOperationDetails(Operation operation, StringBuffer sb) {
        sb.append("Operation: " + operation.getName() + '\n');
        sb.append("\tbinding: \t\t" + operation.getBinding().getName() + '\n');
        sb.append("\tport: \t\t\t" + operation.getBinding().getPort().getName() + '\n');
        sb.append("\tservice: \t\t\t" + operation.getBinding().getPort().getService().getName() + '\n');
        sb.append("\tid: \t\t\t\t" + operation.getId() + '\n');
        sb.append("\tinput message: \t" + operation.getInputMessage().getName() + '\n');
        String outputMsg = "<none>";
        if (operation.getOutputMessage() != null) {
            outputMsg = operation.getOutputMessage().getName();
        }
        sb.append("\toutput message: \t" + outputMsg + '\n');
        Fault[] faults = operation.getFaults();
        sb.append("\tfault names: \t\t");
        if (faults == null || faults.length == 0) {
            sb.append("none");
        } else {
            int i = 0;
            while (i < faults.length) {
                Fault theFault = faults[i];
                sb.append(theFault.getName());
                if (i != faults.length - 1) {
                    sb.append(", ");
                }
                ++i;
            }
        }
        if (!operation.canModel()) {
            String[] errorMsgs = operation.getProblemMessages();
            int i = 0;
            while (i < errorMsgs.length) {
                sb.append('\n');
                sb.append(errorMsgs[i]);
                ++i;
            }
        }
    }

    private void updateImportManager() {
        this.importManager.setSelectedOperations(this.getSelectedOperations());
    }

    private List<Operation> getSelectedOperations() {
        ArrayList<Operation> ops = new ArrayList<Operation>();
        TableItem[] tableItemArray = this.operationsViewerBuilder.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                ops.add((Operation)item.getData());
            }
            ++n2;
        }
        return ops;
    }

    public void notifyWsdlChanged(final boolean profileChanged) {
        UiBusyIndicator.showWhile((Display)this.parentComposite.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                String binding;
                WsdlOperationsPanel.this.panelStatus = Status.OK_STATUS;
                try {
                    WsdlOperationsPanel.this.wsdlModel = WsdlOperationsPanel.this.importManager.getWSDLModel();
                }
                catch (ModelGenerationException e) {
                    WsdlOperationsPanel.this.wsdlModel = null;
                    Status exStatus = new Status(4, "org.teiid.designer.modelgenerator.wsdl.ui", 0, Messages.WsdlOperationsPage_dialog_wsdlParseError_msg, (Throwable)e);
                    Shell shell = WsdlOperationsPanel.this.parentComposite.getShell();
                    ErrorDialog.openError((Shell)shell, null, (String)Messages.WsdlOperationsPage_dialog_wsdlParseError_title, (IStatus)exStatus);
                    WsdlOperationsPanel.this.panelStatus = (IStatus)exStatus;
                    WsdlOperationsPanel.this.operationsViewerBuilder.getTable().clearAll();
                    WsdlOperationsPanel.this.operationsViewerBuilder.setInput(new Object());
                }
                Properties properties = new Properties();
                if (WsdlOperationsPanel.this.importManager.getConnectionProfile() != null) {
                    properties = WsdlOperationsPanel.this.importManager.getConnectionProfile().getBaseProperties();
                }
                if ((binding = properties.getProperty("DefaultBinding")) == null) {
                    binding = "SOAP11";
                }
                WidgetUtil.setText((Text)WsdlOperationsPanel.this.defaultBindingText, (String)binding);
                String portName = properties.getProperty("EndPointName");
                Operation[] operations = new Operation[]{};
                if (WsdlOperationsPanel.this.wsdlModel != null && portName != null) {
                    operations = WsdlOperationsPanel.this.wsdlModel.getModelableOperations(portName);
                }
                WsdlOperationsPanel.this.operationsViewerBuilder.setInput((Object)new OperationsContainer(operations));
                WsdlOperationsPanel.this.operationsViewerBuilder.getTableViewer().refresh(true);
                if (profileChanged || WsdlOperationsPanel.this.importManager.getSelectedOperations().isEmpty()) {
                    WsdlOperationsPanel.this.importManager.setSelectedOperations(new ArrayList<Operation>());
                    WsdlOperationsPanel.this.setAllNodesSelected(true);
                } else {
                    WsdlOperationsPanel.this.selectNodesFromImportManager();
                }
                WsdlOperationsPanel.this.updateImportManager();
            }
        });
    }

    private void handleDefaultServiceModeSelected() {
        this.importManager.setTranslatorDefaultServiceMode(this.defaultServiceModeCombo.getText());
    }

    private void setPageStatus() {
        if (this.panelStatus.isOK()) {
            this.panelStatus = Status.OK_STATUS;
        }
        this.wsdlPage.setPageStatus();
    }

    public IStatus getStatus() {
        return this.panelStatus;
    }

    private void selectNodesFromImportManager() {
        for (Operation oper : this.importManager.getSelectedOperations()) {
            TableItem[] tableItemArray = this.operationsViewerBuilder.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (oper == item.getData()) {
                    item.setChecked(true);
                }
                ++n2;
            }
        }
    }

    private void setAllNodesSelected(boolean bSelected) {
        if (bSelected) {
            TableItem[] tableItemArray = this.operationsViewerBuilder.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                item.setChecked(true);
                ++n2;
            }
        } else {
            TableItem[] tableItemArray = this.operationsViewerBuilder.getTable().getItems();
            int n = tableItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                TableItem item = tableItemArray[n3];
                item.setChecked(false);
                ++n3;
            }
        }
        this.operationsViewerBuilder.getTableViewer().refresh();
    }

    class CheckboxTreeContentProvider
    implements ITreeContentProvider {
        CheckboxTreeContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object node) {
            if (WsdlOperationsPanel.this.wsdlModel != null && node instanceof OperationsContainer) {
                return ((OperationsContainer)node).getOperations();
            }
            return EMPTY_STRING_ARRAY;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof OperationsContainer) {
                return ((OperationsContainer)inputElement).getOperations();
            }
            return new Object[0];
        }

        public Object getParent(Object node) {
            return null;
        }

        public boolean hasChildren(Object node) {
            if (WsdlOperationsPanel.this.wsdlModel != null && node instanceof OperationsContainer) {
                return ((OperationsContainer)node).getOperations().length > 0;
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class CheckboxTreeLabelProvider
    extends LabelProvider {
        private final Image OPERATION_ICON_IMG = ModelGeneratorWsdlUiUtil.getImage("icons/full/obj16/operation_obj.gif");
        final WorkbenchLabelProvider workbenchProvider = new WorkbenchLabelProvider();

        CheckboxTreeLabelProvider() {
        }

        public Image getImage(Object node) {
            if (node instanceof Operation) {
                return this.OPERATION_ICON_IMG;
            }
            return null;
        }

        public String getText(Object node) {
            if (node instanceof Model) {
                return "theModel";
            }
            if (node instanceof WSDLElement) {
                return ((WSDLElement)node).getName();
            }
            return "unknownElement";
        }
    }

    class OperationsColumnLabelProvider
    extends ColumnLabelProvider {
        private final Image PORT_ICON_IMG = ModelGeneratorWsdlUiUtil.getImage("icons/full/obj16/port_obj.gif");

        public String getText(Object element) {
            if (element instanceof Operation) {
                Operation op = (Operation)element;
                StringBuilder sb = new StringBuilder(op.getName());
                return sb.toString();
            }
            return "";
        }

        public String getToolTipText(Object element) {
            return "";
        }

        public Image getImage(Object element) {
            return this.PORT_ICON_IMG;
        }
    }

    class OperationsContainer {
        Operation[] operations;

        public OperationsContainer(Operation[] ops) {
            this.operations = ops;
        }

        public Operation[] getOperations() {
            return this.operations;
        }
    }
}

