/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.common.core.jobs;

import org.apache.directory.studio.common.core.jobs.StudioBulkRunnableWithProgress;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.core.jobs.StudioRunnableWithProgress;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class StudioJob<T extends StudioRunnableWithProgress>
extends Job {
    protected T[] runnables;

    public StudioJob(T ... runnables) {
        super(runnables[0].getName());
        this.runnables = runnables;
    }

    protected IStatus run(IProgressMonitor ipm) {
        StudioProgressMonitor monitor = new StudioProgressMonitor(ipm);
        if (!monitor.errorsReported()) {
            try {
                T[] TArray = this.runnables;
                int n = this.runnables.length;
                int n2 = 0;
                while (n2 < n) {
                    T runnable = TArray[n2];
                    if (runnable instanceof StudioBulkRunnableWithProgress) {
                        StudioBulkRunnableWithProgress bulkRunnable = (StudioBulkRunnableWithProgress)runnable;
                        this.suspendEventFiringInCurrentThread();
                        try {
                            bulkRunnable.run(monitor);
                        }
                        finally {
                            this.resumeEventFiringInCurrentThread();
                        }
                        bulkRunnable.runNotification(monitor);
                    } else {
                        runnable.run(monitor);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                monitor.reportError(e);
            }
        }
        monitor.done();
        ipm.done();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (monitor.errorsReported()) {
            return monitor.getErrorStatus(this.runnables[0].getErrorMessage());
        }
        return Status.OK_STATUS;
    }

    protected void suspendEventFiringInCurrentThread() {
    }

    protected void resumeEventFiringInCurrentThread() {
    }

    public void execute() {
        this.setUser(true);
        this.schedule();
    }

    public boolean shouldSchedule() {
        T[] TArray = this.runnables;
        int n = this.runnables.length;
        int n2 = 0;
        while (n2 < n) {
            T runnable = TArray[n2];
            Object[] myLockedObjects = runnable.getLockedObjects();
            String[] myLockedObjectsIdentifiers = this.getLockIdentifiers(myLockedObjects);
            Job[] jobs = StudioJob.getJobManager().find(null);
            int i = 0;
            while (i < jobs.length) {
                Job job = jobs[i];
                if (job instanceof StudioJob) {
                    StudioJob otherJob = (StudioJob)job;
                    T[] TArray2 = otherJob.runnables;
                    int n3 = otherJob.runnables.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        T otherRunnable = TArray2[n4];
                        if (runnable.getClass() == otherRunnable.getClass() && runnable != otherRunnable) {
                            Object[] otherLockedObjects = otherRunnable.getLockedObjects();
                            String[] otherLockedObjectIdentifiers = this.getLockIdentifiers(otherLockedObjects);
                            int j = 0;
                            while (j < otherLockedObjectIdentifiers.length) {
                                String other = otherLockedObjectIdentifiers[j];
                                int k = 0;
                                while (k < myLockedObjectsIdentifiers.length) {
                                    String my = myLockedObjectsIdentifiers[k];
                                    if (other.startsWith(my) || my.startsWith(other)) {
                                        return false;
                                    }
                                    ++k;
                                }
                                ++j;
                            }
                        }
                        ++n4;
                    }
                }
                ++i;
            }
            ++n2;
        }
        return super.shouldSchedule();
    }

    protected String[] getLockIdentifiers(Object[] objects) {
        String[] identifiers = new String[objects.length];
        int i = 0;
        while (i < identifiers.length) {
            identifiers[i] = this.getLockIdentifier(objects[i]);
            ++i;
        }
        return identifiers;
    }

    private String getLockIdentifier(Object object) {
        return object != null ? object.toString() : "null";
    }

    public boolean belongsTo(Object family) {
        return this.getFamily().equals(family);
    }

    public Object getFamily() {
        return "org.apache.directory.studio.common.core.jobs.family";
    }
}

