/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.util.LinkedList;
import java.util.List;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.util.collections.ListUtil;
import org.mockito.internal.verification.api.InOrderContext;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;

public class InvocationsFinder {
    public List<Invocation> findInvocations(List<Invocation> invocations, InvocationMatcher wanted) {
        return ListUtil.filter(invocations, new RemoveNotMatching(wanted));
    }

    public List<Invocation> findAllMatchingUnverifiedChunks(List<Invocation> invocations, InvocationMatcher wanted, InOrderContext orderingContext) {
        List<Invocation> unverified = this.removeVerifiedInOrder(invocations, orderingContext);
        return ListUtil.filter(unverified, new RemoveNotMatching(wanted));
    }

    public List<Invocation> findMatchingChunk(List<Invocation> invocations, InvocationMatcher wanted, int wantedCount, InOrderContext context) {
        List<Invocation> unverified = this.removeVerifiedInOrder(invocations, context);
        List<Invocation> firstChunk = this.getFirstMatchingChunk(wanted, unverified);
        if (wantedCount != firstChunk.size()) {
            return this.findAllMatchingUnverifiedChunks(invocations, wanted, context);
        }
        return firstChunk;
    }

    private List<Invocation> getFirstMatchingChunk(InvocationMatcher wanted, List<Invocation> unverified) {
        LinkedList<Invocation> firstChunk = new LinkedList<Invocation>();
        for (Invocation invocation : unverified) {
            if (wanted.matches(invocation)) {
                firstChunk.add(invocation);
                continue;
            }
            if (!firstChunk.isEmpty()) break;
        }
        return firstChunk;
    }

    public Invocation findFirstMatchingUnverifiedInvocation(List<Invocation> invocations, InvocationMatcher wanted, InOrderContext context) {
        for (Invocation invocation : this.removeVerifiedInOrder(invocations, context)) {
            if (!wanted.matches(invocation)) continue;
            return invocation;
        }
        return null;
    }

    public Invocation findSimilarInvocation(List<Invocation> invocations, InvocationMatcher wanted) {
        Invocation firstSimilar = null;
        for (Invocation invocation : invocations) {
            if (!wanted.hasSimilarMethod(invocation)) continue;
            if (firstSimilar == null) {
                firstSimilar = invocation;
            }
            if (!wanted.hasSameMethod(invocation)) continue;
            return invocation;
        }
        return firstSimilar;
    }

    public Invocation findFirstUnverified(List<Invocation> invocations) {
        return this.findFirstUnverified(invocations, null);
    }

    Invocation findFirstUnverified(List<Invocation> invocations, Object mock) {
        for (Invocation i : invocations) {
            boolean mockIsValid;
            boolean bl = mockIsValid = mock == null || mock == i.getMock();
            if (i.isVerified() || !mockIsValid) continue;
            return i;
        }
        return null;
    }

    public Location getLastLocation(List<Invocation> invocations) {
        if (invocations.isEmpty()) {
            return null;
        }
        Invocation last = invocations.get(invocations.size() - 1);
        return last.getLocation();
    }

    public Invocation findPreviousVerifiedInOrder(List<Invocation> invocations, InOrderContext context) {
        LinkedList<Invocation> verifiedOnly = ListUtil.filter(invocations, new RemoveUnverifiedInOrder(context));
        if (verifiedOnly.isEmpty()) {
            return null;
        }
        return verifiedOnly.getLast();
    }

    private List<Invocation> removeVerifiedInOrder(List<Invocation> invocations, InOrderContext orderingContext) {
        LinkedList<Invocation> unverified = new LinkedList<Invocation>();
        for (Invocation i : invocations) {
            if (orderingContext.isVerified(i)) {
                unverified.clear();
                continue;
            }
            unverified.add(i);
        }
        return unverified;
    }

    public Invocation findFirstUnverifiedInOrder(InOrderContext context, List<Invocation> orderedInvocations) {
        Invocation candidate = null;
        for (Invocation i : orderedInvocations) {
            candidate = !context.isVerified(i) ? (candidate != null ? candidate : i) : null;
        }
        return candidate;
    }

    private class RemoveNotMatching
    implements ListUtil.Filter<Invocation> {
        private final InvocationMatcher wanted;

        private RemoveNotMatching(InvocationMatcher wanted) {
            this.wanted = wanted;
        }

        @Override
        public boolean isOut(Invocation invocation) {
            return !this.wanted.matches(invocation);
        }
    }

    private class RemoveUnverifiedInOrder
    implements ListUtil.Filter<Invocation> {
        private final InOrderContext orderingContext;

        public RemoveUnverifiedInOrder(InOrderContext orderingContext) {
            this.orderingContext = orderingContext;
        }

        @Override
        public boolean isOut(Invocation invocation) {
            return !this.orderingContext.isVerified(invocation);
        }
    }
}

