/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wizards.Messages;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wizards.NewJbpmProcessWizardPage1;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.osgi.service.prefs.BackingStoreException;

public class NewJbpmProcessWizard
extends Wizard
implements INewWizard {
    private NewJbpmProcessWizardPage1 page;
    private ISelection selection;
    private String processName;
    private String processId;
    private String packageName;
    private boolean isSetJbpmRuntime;

    public NewJbpmProcessWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new NewJbpmProcessWizardPage1(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "org.eclipse.bpmn2.modeler.help.JBPM_New_File_Wizard");
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        this.processName = this.page.getProcessName();
        this.processId = this.page.getProcessId();
        this.packageName = this.page.getPackageName();
        this.isSetJbpmRuntime = this.page.isSetJbpmRuntime();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewJbpmProcessWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewJbpmProcessWizard_Error_Title, (String)realException.getMessage());
            Activator.logError((Exception)e);
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(NLS.bind((String)Messages.NewJbpmProcessWizard_Monitor_Title, (Object)fileName), 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException(NLS.bind((String)Messages.NewJbpmProcessWizard_Error_No_Container, (Object)containerName));
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        if (this.isSetJbpmRuntime) {
            monitor.setTaskName(Messages.NewJbpmProcessWizard_Configuring_Project_Message);
            Bpmn2Preferences prefs = Bpmn2Preferences.getInstance((IProject)container.getProject());
            prefs.useProjectPreferences();
            TargetRuntime rt = TargetRuntime.getRuntime((String)"org.jboss.runtime.jbpm5");
            prefs.setRuntime(rt);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                this.throwCoreException(e.getMessage());
            }
        }
        monitor.worked(1);
        monitor.setTaskName(Messages.NewJbpmProcessWizard_Opening_File_Message);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() {
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<bpmn2:definitions\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txmlns:bpmn2=\"http://www.omg.org/spec/BPMN/20100524/MODEL\"\n\txmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\"\n\txmlns:dc=\"http://www.omg.org/spec/DD/20100524/DC\"\n\txmlns:di=\"http://www.omg.org/spec/DD/20100524/DI\"\n\txmlns:tns=\"http://www.jboss.org/drools\"\n\txmlns=\"http://www.jboss.org/drools\"\n\txsi:schemaLocation=\"http://www.omg.org/spec/BPMN/20100524/MODEL BPMN20.xsd http://www.jboss.org/drools drools.xsd http://www.bpsim.org/schemas/1.0 bpsim.xsd\"\n\tid=\"Definition\"\n\texpressionLanguage=\"http://www.mvel.org/2.0\"\n\ttargetNamespace=\"http://www.jboss.org/drools\"\n\ttypeLanguage=\"http://www.java.com/javaTypes\">\n\n  <bpmn2:process processType=\"Private\" isExecutable=\"true\" id=\"" + this.processId + "\"" + " name=\"" + this.processName + "\"" + " tns:packageName=\"" + this.packageName + "\"" + " >\n" + "    <bpmn2:startEvent id=\"StartEvent_1\" name=\"StartProcess\"/>\n" + "  </bpmn2:process>\n" + "\n" + "  <bpmndi:BPMNDiagram>\n" + "    <bpmndi:BPMNPlane bpmnElement=\"" + this.processId + "\" >\n" + "      <bpmndi:BPMNShape bpmnElement=\"StartEvent_1\" >\n" + "        <dc:Bounds x=\"45\" y=\"45\" />\n" + "      </bpmndi:BPMNShape>\n" + "      </bpmndi:BPMNPlane>\n" + "  </bpmndi:BPMNDiagram>\n" + "\n" + "</bpmn2:definitions>\n";
        return new ByteArrayInputStream(contents.getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

