/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.internal.utils;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import junit.framework.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.util.FileUtil;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.ide.eclipse.as.core.util.ServerCreationUtils;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.TestConstants;
import org.jboss.tools.as.test.core.internal.utils.BundleUtils;
import org.jboss.tools.as.test.core.internal.utils.IOUtil;

public class ServerCreationTestUtils
extends Assert {
    private static final IPath mockedServers = ASMatrixTests.getDefault().getStateLocation().append("mockedServers");
    private static HashMap<String, String> asSystemJar = new HashMap();
    private static HashMap<String, String> serverRuntimeMap = new HashMap();
    private static final String twiddle_suffix = ".mf.twiddle.jar";
    private static final String twiddle_3_2_8 = "3.2.8.mf.twiddle.jar";
    private static final String twiddle_4_0_5 = "4.0.5.mf.twiddle.jar";
    private static final String twiddle_4_2_3 = "4.2.3.mf.twiddle.jar";
    private static final String twiddle_5_0_0 = "5.0.0.mf.twiddle.jar";
    private static final String twiddle_5_0_1 = "5.0.1.mf.twiddle.jar";
    private static final String twiddle_5_1_0 = "5.1.0.mf.twiddle.jar";
    private static final String twiddle_6_0_0 = "6.0.0.mf.twiddle.jar";
    private static final String as_server_7_0_jar = "7.0.0.mf.jboss-as-server.jar";
    private static final String as_server_7_1_jar = "7.1.0.mf.jboss-as-server.jar";
    private static final String wildfly_8_0_jar = "wf8.0.0.mf.jboss-as-server.jar";
    private static final String wildfly_9_0_jar = "wf9.0.0.mf.jboss-as-server.jar";
    private static final String wildfly_10_0_jar = "wf10.0.0.mf.jboss-as-server.jar";
    private static final String twiddle_eap_4_3 = "eap4.3.mf.twiddle.jar";
    private static final String twiddle_eap_5_0 = "eap5.0.mf.twiddle.jar";
    private static final String twiddle_eap_5_1 = "eap5.1.mf.twiddle.jar";
    private static final String eap_server_6_0_jar = "eap6.0.0.mf.jboss-as-server.jar";
    private static final String eap_server_6_1_jar = "eap6.1.0.mf.jboss-as-server.jar";
    private static final String eap_server_7_0_jar = "eap7.0.0.mf.jboss-as-server.jar";
    private static final String jpp_server_6_0_jar = "jpp6.0.0.mf.jboss-as-server.jar";
    private static final String jpp_server_6_1_jar = "jpp6.1.0.mf.jboss-as-server.jar";
    private static final String gatein_3_4_0_jar = "gatein3.4.0.mf.jboss-as7-integration.jar";
    private static final String run_jar = "run.jar";
    private static final String service_xml = "service.xml";
    public static final String TEST_SERVER_TYPE_GATEIN_34 = "TEST_SERVER_TYPE_GATEIN_34";
    public static final String TEST_SERVER_TYPE_GATEIN_35 = "TEST_SERVER_TYPE_GATEIN_35";
    public static final String TEST_SERVER_TYPE_GATEIN_36 = "TEST_SERVER_TYPE_GATEIN_36";
    public static final String TEST_SERVER_TYPE_JPP_60 = "TEST_SERVER_TYPE_JPP_60";
    public static final String TEST_SERVER_TYPE_JPP_61 = "TEST_SERVER_TYPE_JPP_61";
    public static final String TEST_SERVER_TYPE_EAP_65 = "TEST_SERVER_TYPE_EAP_65";
    public static final String TEST_SERVER_TYPE_WONKA_1 = "TEST_SERVER_TYPE_WONKA_1_MISMATCH";
    public static final String[] TEST_SERVER_TYPES_TO_MOCK = new String[]{"TEST_SERVER_TYPE_GATEIN_34", "TEST_SERVER_TYPE_GATEIN_35", "TEST_SERVER_TYPE_GATEIN_36", "TEST_SERVER_TYPE_JPP_60", "TEST_SERVER_TYPE_JPP_61", "TEST_SERVER_TYPE_EAP_65", "TEST_SERVER_TYPE_WONKA_1_MISMATCH"};

    static {
        asSystemJar.put("org.jboss.ide.eclipse.as.32", twiddle_3_2_8);
        asSystemJar.put("org.jboss.ide.eclipse.as.40", twiddle_4_0_5);
        asSystemJar.put("org.jboss.ide.eclipse.as.42", twiddle_4_2_3);
        asSystemJar.put("org.jboss.ide.eclipse.as.50", twiddle_5_0_0);
        asSystemJar.put("org.jboss.ide.eclipse.as.51", twiddle_5_1_0);
        asSystemJar.put("org.jboss.ide.eclipse.as.60", twiddle_6_0_0);
        asSystemJar.put("org.jboss.ide.eclipse.as.70", as_server_7_0_jar);
        asSystemJar.put("org.jboss.ide.eclipse.as.71", as_server_7_1_jar);
        asSystemJar.put("org.jboss.ide.eclipse.as.wildfly.80", wildfly_8_0_jar);
        asSystemJar.put("org.jboss.ide.eclipse.as.wildfly.90", wildfly_9_0_jar);
        asSystemJar.put("org.jboss.ide.eclipse.as.wildfly.100", wildfly_10_0_jar);
        asSystemJar.put("org.jboss.ide.eclipse.as.eap.43", twiddle_eap_4_3);
        asSystemJar.put("org.jboss.ide.eclipse.as.eap.50", twiddle_eap_5_1);
        asSystemJar.put("org.jboss.ide.eclipse.as.eap.60", eap_server_6_0_jar);
        asSystemJar.put("org.jboss.ide.eclipse.as.eap.61", eap_server_6_1_jar);
        asSystemJar.put("org.jboss.ide.eclipse.as.eap.70", eap_server_7_0_jar);
        asSystemJar.put(TEST_SERVER_TYPE_EAP_65, eap_server_6_1_jar);
        asSystemJar.put(TEST_SERVER_TYPE_JPP_60, jpp_server_6_0_jar);
        asSystemJar.put(TEST_SERVER_TYPE_JPP_61, jpp_server_6_1_jar);
        asSystemJar.put(TEST_SERVER_TYPE_WONKA_1, eap_server_6_1_jar);
        asSystemJar.put(TEST_SERVER_TYPE_GATEIN_34, gatein_3_4_0_jar);
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.32", "org.jboss.ide.eclipse.as.runtime.32");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.40", "org.jboss.ide.eclipse.as.runtime.40");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.42", "org.jboss.ide.eclipse.as.runtime.42");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.50", "org.jboss.ide.eclipse.as.runtime.50");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.51", "org.jboss.ide.eclipse.as.runtime.51");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.60", "org.jboss.ide.eclipse.as.runtime.60");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.70", "org.jboss.ide.eclipse.as.runtime.70");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.71", "org.jboss.ide.eclipse.as.runtime.71");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.wildfly.80", "org.jboss.ide.eclipse.as.runtime.wildfly.80");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.wildfly.90", "org.jboss.ide.eclipse.as.runtime.wildfly.90");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.wildfly.100", "org.jboss.ide.eclipse.as.runtime.wildfly.100");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.eap.43", "org.jboss.ide.eclipse.as.runtime.eap.43");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.eap.50", "org.jboss.ide.eclipse.as.runtime.eap.50");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.eap.60", "org.jboss.ide.eclipse.as.runtime.eap.60");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.eap.61", "org.jboss.ide.eclipse.as.runtime.eap.61");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.eap.70", "org.jboss.ide.eclipse.as.runtime.eap.70");
    }

    private static IServer createDeployOnlyServer() throws CoreException {
        return ServerCreationTestUtils.createDeployOnlyServer(ServerCreationTestUtils.getDeployFolder(), ServerCreationTestUtils.getTmpDeployFolder());
    }

    public static File createMockServerLayout(String serverType) {
        boolean isEap = false;
        if (serverType.startsWith("org.jboss.ide.eclipse.as.eap.")) {
            isEap = true;
        }
        String name = serverType;
        IPath serverDir = null;
        if ("org.jboss.ide.eclipse.as.32".equals(serverType) || "org.jboss.ide.eclipse.as.40".equals(serverType) || "org.jboss.ide.eclipse.as.42".equals(serverType) || "org.jboss.ide.eclipse.as.50".equals(serverType) || "org.jboss.ide.eclipse.as.51".equals(serverType) || "org.jboss.ide.eclipse.as.60".equals(serverType) || "org.jboss.ide.eclipse.as.eap.43".equals(serverType) || "org.jboss.ide.eclipse.as.eap.50".equals(serverType)) {
            name = String.valueOf(name) + (isEap ? "/jbossas" : "");
            serverDir = ServerCreationTestUtils.createAS6AndBelowMockServerDirectory(String.valueOf(serverType) + ServerCreationTestUtils.getRandomString(), asSystemJar.get(serverType), "default");
        } else if ("org.jboss.ide.eclipse.as.70".equals(serverType) || "org.jboss.ide.eclipse.as.71".equals(serverType)) {
            serverDir = ServerCreationTestUtils.createAS7StyleMockServerDirectory(name, serverType, asSystemJar.get(serverType));
        } else if ("org.jboss.ide.eclipse.as.eap.60".equals(serverType)) {
            serverDir = ServerCreationTestUtils.createEAP6StyleMockServerDirectory(name, serverType, asSystemJar.get(serverType));
        } else if ("org.jboss.ide.eclipse.as.eap.61".equals(serverType)) {
            serverDir = ServerCreationTestUtils.createAS72EAP61StyleMockServerDirectory(name, serverType, asSystemJar.get(serverType));
        } else if ("org.jboss.ide.eclipse.as.eap.70".equals(serverType)) {
            serverDir = ServerCreationTestUtils.createEAP70StyleMockServerDirectory(name, serverType, asSystemJar.get(serverType));
        } else if ("org.jboss.ide.eclipse.as.wildfly.80".equals(serverType)) {
            serverDir = ServerCreationTestUtils.createWildfly80MockServerDirectory(name, serverType, asSystemJar.get(serverType));
        } else if ("org.jboss.ide.eclipse.as.wildfly.90".equals(serverType)) {
            serverDir = ServerCreationTestUtils.createWildfly90MockServerDirectory(name, serverType, asSystemJar.get(serverType));
        } else if ("org.jboss.ide.eclipse.as.wildfly.100".equals(serverType)) {
            serverDir = ServerCreationTestUtils.createWildfly100MockServerDirectory(name, serverType, asSystemJar.get(serverType));
        } else if (TEST_SERVER_TYPE_GATEIN_34.equals(serverType)) {
            serverDir = ServerCreationTestUtils.createGateIn34MockServerDirectory(name);
        } else if (TEST_SERVER_TYPE_GATEIN_35.equals(serverType)) {
            serverDir = ServerCreationTestUtils.createGateIn35MockServerDirectory(name);
        } else if (TEST_SERVER_TYPE_GATEIN_36.equals(serverType)) {
            serverDir = ServerCreationTestUtils.createGateIn36MockServerDirectory(name);
        } else if (TEST_SERVER_TYPE_JPP_60.equals(serverType)) {
            serverDir = ServerCreationTestUtils.createJPP60MockServerDirectory(name, serverType, asSystemJar.get(serverType));
        } else if (TEST_SERVER_TYPE_JPP_61.equals(serverType)) {
            serverDir = ServerCreationTestUtils.createJPP61MockServerDirectory(name, serverType, asSystemJar.get(serverType));
        } else if (TEST_SERVER_TYPE_EAP_65.equals(serverType)) {
            serverDir = ServerCreationTestUtils.createAS72EAP65StyleMockServerDirectory(name, serverType, asSystemJar.get(serverType));
        } else if (TEST_SERVER_TYPE_WONKA_1.equals(serverType)) {
            serverDir = ServerCreationTestUtils.createAS72Wonka1MockServerDirectory(name, serverType, asSystemJar.get(serverType));
        }
        return serverDir == null ? null : serverDir.toFile();
    }

    public static IServer createMockServerWithRuntime(String serverType, String name) {
        try {
            if (serverType.equals("org.jboss.ide.eclipse.as.systemCopyServer")) {
                return ServerCreationTestUtils.createDeployOnlyServer();
            }
            File f = ServerCreationTestUtils.createMockServerLayout(serverType);
            return ServerCreationTestUtils.createServerWithRuntime(serverType, name, f);
        }
        catch (CoreException ce) {
            throw new RuntimeException("Unable to create IServer " + name + " of type " + serverType, ce);
        }
    }

    public static IServer createServerWithRuntime(String serverType, String name) throws CoreException {
        if (serverType.equals("org.jboss.ide.eclipse.as.systemCopyServer")) {
            return ServerCreationTestUtils.createDeployOnlyServer();
        }
        String loc = TestConstants.getServerHome(serverType);
        ServerCreationTestUtils.assertNotNull((String)("Runtime location for server type " + serverType + " not set in test suite"), (Object)loc);
        File locFile = new Path(loc).toFile();
        ServerCreationTestUtils.assertTrue((String)("Runtime location for server type " + serverType + " (" + locFile.getAbsolutePath() + "), does not exist"), (boolean)locFile.exists());
        return ServerCreationTestUtils.createServerWithRuntime(serverType, name, locFile);
    }

    public static IServer createServerWithRuntime(String serverType, String name, File f) throws CoreException {
        if (f != null) {
            IServerType type = ServerCore.findServerType((String)serverType);
            if (ServerUtil.isJBoss7((IServerType)type)) {
                return ServerCreationTestUtils.createJBoss7IServer(type, f.getAbsolutePath(), name);
            }
            return ServerCreationTestUtils.createServer(serverType, f.getAbsolutePath(), "default", name);
        }
        return null;
    }

    private static IPath createAS6AndBelowMockServerDirectory(String name, String twiddleJar, String configurationName) {
        IPath loc = mockedServers.append(name);
        try {
            loc.toFile().mkdirs();
            loc.append("bin").toFile().mkdirs();
            loc.append("server").toFile().mkdirs();
            loc.append("server").append(configurationName).toFile().mkdirs();
            IPath configConf = loc.append("server").append(configurationName).append("conf");
            configConf.toFile().mkdirs();
            File twiddleLoc = BundleUtils.getFileLocation("serverMock/" + twiddleJar);
            FileUtil.fileSafeCopy((File)twiddleLoc, (File)loc.append("bin").append("twiddle.jar").toFile());
            File runJar = BundleUtils.getFileLocation("serverMock/run.jar");
            FileUtil.fileSafeCopy((File)runJar, (File)loc.append("bin").append(run_jar).toFile());
            File serviceXml = BundleUtils.getFileLocation("serverMock/jboss-service.xml");
            FileUtil.fileSafeCopy((File)serviceXml, (File)configConf.append("jboss-service.xml").toFile());
            return loc;
        }
        catch (CoreException coreException) {
            FileUtil.completeDelete((File)loc.toFile());
            return null;
        }
    }

    private static IPath createGateIn34MockServerDirectory(String name) {
        IPath loc = mockedServers.append(name);
        ServerCreationTestUtils.createAS7xProductStructure(loc, false, asSystemJar.get("org.jboss.ide.eclipse.as.71"), null, null);
        IPath dest = loc.append("/gatein/modules/org/gatein/main/");
        dest.toFile().mkdirs();
        try {
            File serverJarLoc = BundleUtils.getFileLocation("serverMock/" + asSystemJar.get(TEST_SERVER_TYPE_GATEIN_34));
            FileUtil.fileSafeCopy((File)serverJarLoc, (File)dest.append("anything.jar").toFile());
        }
        catch (CoreException coreException) {
            FileUtil.completeDelete((File)loc.toFile());
        }
        return loc;
    }

    private static IPath createGateIn35MockServerDirectory(String name) {
        IPath loc = mockedServers.append(name);
        ServerCreationTestUtils.createAS7xProductStructure(loc, false, asSystemJar.get("org.jboss.ide.eclipse.as.71"), null, null);
        String GATEIN_35_PROPERTY_FILE = "gatein/extensions/gatein-wsrp-integration.ear/extension-war.war/META-INF/maven/org.gatein.integration/extension-war/pom.properties";
        IPath propFile = loc.append(GATEIN_35_PROPERTY_FILE);
        propFile.toFile().getParentFile().mkdirs();
        try {
            IOUtil.setContents(propFile.toFile(), "version=3.5.0");
        }
        catch (IOException iOException) {
            FileUtil.completeDelete((File)loc.toFile());
        }
        return loc;
    }

    private static IPath createGateIn36MockServerDirectory(String name) {
        IPath loc = mockedServers.append(name);
        ServerCreationTestUtils.createAS7xProductStructure(loc, false, asSystemJar.get("org.jboss.ide.eclipse.as.71"), null, null);
        String GATEIN_35_PROPERTY_FILE = "gatein/extensions/gatein-wsrp-integration.ear/extension-war.war/META-INF/maven/org.gatein.integration/extension-war/pom.properties";
        IPath propFile = loc.append(GATEIN_35_PROPERTY_FILE);
        propFile.toFile().getParentFile().mkdirs();
        try {
            IOUtil.setContents(propFile.toFile(), "version=3.6.0");
        }
        catch (IOException iOException) {
            FileUtil.completeDelete((File)loc.toFile());
        }
        return loc;
    }

    private static IPath createAS7StyleMockServerDirectory(String name, String serverTypeId, String serverJar) {
        IPath loc = mockedServers.append(name);
        ServerCreationTestUtils.createAS7xProductStructure(loc, false, serverJar, null, null);
        return loc;
    }

    private static IPath createWildfly80MockServerDirectory(String name, String serverTypeId, String serverJar) {
        IPath loc = mockedServers.append(name);
        ServerCreationTestUtils.createAS7xProductStructure(loc, true, serverJar, null, null);
        return loc;
    }

    private static IPath createWildfly90MockServerDirectory(String name, String serverTypeId, String serverJar) {
        IPath loc = mockedServers.append(name);
        ServerCreationTestUtils.createAS7xProductStructure(loc, true, serverJar, null, null);
        IPath productDir = loc.append("modules/system/layers/base/org/jboss/as/product/wildfly-full/dir/META-INF/");
        productDir.toFile().mkdirs();
        String manString = "JBoss-Product-Release-Name: WildFly Full\nJBoss-Product-Release-Version: 9.0.0.Beta2\n";
        try {
            IOUtil.setContents(new File(productDir.toFile(), "manifest.mf"), manString);
        }
        catch (IOException iOException) {}
        return loc;
    }

    private static IPath createWildfly100MockServerDirectory(String name, String serverTypeId, String serverJar) {
        IPath loc = mockedServers.append(name);
        ServerCreationTestUtils.createAS7xProductStructure(loc, true, serverJar, null, null);
        IPath productDir = loc.append("modules/system/layers/base/org/jboss/as/product/wildfly-full/dir/META-INF/");
        productDir.toFile().mkdirs();
        String manString = "JBoss-Product-Release-Name: WildFly Full\nJBoss-Product-Release-Version: 10.0.0.Beta2\n";
        try {
            IOUtil.setContents(new File(productDir.toFile(), "manifest.mf"), manString);
        }
        catch (IOException iOException) {}
        return loc;
    }

    private static IPath createAS72EAP61StyleMockServerDirectory(String name, String serverTypeId, String serverJar) {
        IPath loc = mockedServers.append(name);
        String manString = "JBoss-Product-Release-Name: EAP\nJBoss-Product-Release-Version: 6.1.0.Alpha\nJBoss-Product-Console-Slot: eap";
        ServerCreationTestUtils.createAS7xProductStructure(loc, true, serverJar, "eap", manString);
        return loc;
    }

    private static IPath createEAP70StyleMockServerDirectory(String name, String serverTypeId, String serverJar) {
        IPath loc = mockedServers.append(name);
        String manString = "JBoss-Product-Release-Name: JBoss EAP\nJBoss-Product-Release-Version: 7.0.0.GA\nJBoss-Product-Console-Slot: eap";
        ServerCreationTestUtils.createAS7xProductStructure(loc, true, serverJar, "eap", manString);
        return loc;
    }

    private static IPath createAS72EAP65StyleMockServerDirectory(String name, String serverTypeId, String serverJar) {
        IPath loc = mockedServers.append(name);
        String manString = "JBoss-Product-Release-Name: EAP\nJBoss-Product-Release-Version: 6.5.0.Alpha\nJBoss-Product-Console-Slot: eap";
        ServerCreationTestUtils.createAS7xProductStructure(loc, true, serverJar, "eap", manString);
        return loc;
    }

    private static IPath createAS72Wonka1MockServerDirectory(String name, String serverTypeId, String serverJar) {
        IPath loc = mockedServers.append(name);
        String wonkaManString = "JBoss-Product-Release-Name: WONKA\nJBoss-Product-Release-Version: 1.0.0.Alpha\nJBoss-Product-Console-Slot: wonka";
        String eapManContents = "JBoss-Product-Release-Name: EAP\nJBoss-Product-Release-Version: 6.1.1.GA\nJBoss-Product-Console-Slot: eap";
        ServerCreationTestUtils.createAS7xProductStructure(loc, true, serverJar, null, null);
        try {
            ServerCreationTestUtils.createProductConfASgt7(loc, "wonka", new String[]{"notwonka"});
            IPath metainf = loc.append(ServerCreationTestUtils.getProductMetaInfFolderPath("eap", true));
            ServerCreationTestUtils.createProductMetaInfFolder(metainf, eapManContents);
            IPath metainf2 = loc.append(ServerCreationTestUtils.getProductMetaInfFolderPath("wonka", true, "notwonka"));
            ServerCreationTestUtils.createProductMetaInfFolder(metainf2, wonkaManString);
        }
        catch (CoreException coreException) {
            FileUtil.completeDelete((File)loc.toFile());
        }
        catch (IOException iOException) {
            FileUtil.completeDelete((File)loc.toFile());
        }
        return loc;
    }

    private static IPath createEAP6StyleMockServerDirectory(String name, String serverTypeId, String serverJar) {
        IPath loc = mockedServers.append(name);
        String manString = "JBoss-Product-Release-Name: EAP\nJBoss-Product-Release-Version: 6.0.0.Alpha\nJBoss-Product-Console-Slot: eap";
        ServerCreationTestUtils.createAS7xProductStructure(loc, false, serverJar, "eap", manString);
        return loc;
    }

    private static IPath createJPP60MockServerDirectory(String name, String serverTypeId, String serverJar) {
        IPath loc = mockedServers.append(name);
        String manString = "JBoss-Product-Release-Name: Portal Platform\nJBoss-Product-Release-Version: 6.0.0.CR01\nJBoss-Product-Console-Slot: jpp";
        ServerCreationTestUtils.createAS7xProductStructure(loc, false, serverJar, "jpp", manString);
        return loc;
    }

    private static IPath createJPP61MockServerDirectory(String name, String serverTypeId, String serverJar) {
        IPath loc = mockedServers.append(name);
        String manString = "JBoss-Product-Release-Name: Portal Platform\nJBoss-Product-Release-Version: 6.1.0.ER03\nJBoss-Product-Console-Slot: jpp";
        ServerCreationTestUtils.createAS7xProductStructure(loc, true, serverJar, "jpp", manString);
        return loc;
    }

    private static void createAS7xProductStructure(IPath loc, boolean includeLayers, String serverJar, String slot, String manifestContents) {
        try {
            ServerCreationTestUtils.createStandaloneXML(loc);
            ServerCreationTestUtils.copyASSystemJar(loc, serverJar, includeLayers);
            loc.append("jboss-modules.jar").toFile().createNewFile();
            loc.append("bin").toFile().mkdirs();
            if (slot != null) {
                ServerCreationTestUtils.createProductConfASgt7(loc, slot, null);
                ServerCreationTestUtils.createProductMetaInfFolder(loc, slot, includeLayers, manifestContents);
            }
        }
        catch (CoreException coreException) {
            FileUtil.completeDelete((File)loc.toFile());
        }
        catch (IOException iOException) {
            FileUtil.completeDelete((File)loc.toFile());
        }
    }

    private static void copyASSystemJar(IPath loc, String serverJar, boolean includeLayers) throws CoreException {
        IPath serverJarBelongs = includeLayers ? loc.append("modules/system/layers/base/org/jboss/as/server/main") : loc.append("modules/org/jboss/as/server/main");
        serverJarBelongs.toFile().mkdirs();
        File serverJarLoc = BundleUtils.getFileLocation("serverMock/" + serverJar);
        FileUtil.fileSafeCopy((File)serverJarLoc, (File)serverJarBelongs.append("anything.jar").toFile());
    }

    private static void createProductMetaInfFolder(IPath loc, String slot, boolean includeLayers, String manifestContents) throws IOException, CoreException {
        IPath metainf = loc.append(ServerCreationTestUtils.getProductMetaInfFolderPath(slot, includeLayers));
        ServerCreationTestUtils.createProductMetaInfFolder(metainf, manifestContents);
    }

    private static void createProductMetaInfFolder(IPath metainf, String manifestContents) throws IOException, CoreException {
        metainf.toFile().mkdirs();
        IPath manifest = metainf.append("MANIFEST.MF");
        IOUtil.setContents(manifest.toFile(), manifestContents);
    }

    private static String getProductMetaInfFolderPath(String slot, boolean includeLayers) {
        return ServerCreationTestUtils.getProductMetaInfFolderPath(slot, includeLayers, null);
    }

    private static String getProductMetaInfFolderPath(String slot, boolean includeLayers, String insideLayer) {
        if (insideLayer == null) {
            if (!includeLayers) {
                return "modules/org/jboss/as/product/" + slot + "/dir/META-INF";
            }
            return "modules/system/layers/base/org/jboss/as/product/" + slot + "/dir/META-INF";
        }
        return "modules/system/layers/" + insideLayer + "/org/jboss/as/product/" + slot + "/dir/META-INF";
    }

    private static void createProductConfASgt7(IPath loc, String slot, String[] layers) throws CoreException, IOException {
        loc.toFile().mkdirs();
        IPath productConf = loc.append("bin/product.conf");
        loc.append("bin").toFile().mkdirs();
        IOUtil.setContents(productConf.toFile(), "slot=" + slot);
        if (layers != null && layers.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("layers=");
            int i = 0;
            while (i < layers.length) {
                sb.append(layers[i]);
                if (i < layers.length - 1) {
                    sb.append(",");
                }
                ++i;
            }
            IPath layersConf = loc.append("modules/layers.conf");
            loc.append("modules").toFile().mkdirs();
            IOUtil.setContents(layersConf.toFile(), sb.toString());
        }
    }

    private static void createStandaloneXML(IPath loc) throws IOException {
        IPath standalonexml = loc.append("standalone").append("configuration").append("standalone.xml");
        standalonexml.toFile().getParentFile().mkdirs();
        IOUtil.setContents(standalonexml.toFile(), "<server></server>");
    }

    private static IServer createServer(String serverType, String location, String configuration, String name) throws CoreException {
        IRuntime runtime = RuntimeUtils.createRuntime((String)serverRuntimeMap.get(serverType), (String)location, (String)configuration);
        IServerType serverType2 = ServerCore.findServerType((String)serverType);
        IServerWorkingCopy swc = ServerCreationUtils.createServerWorkingCopy((IRuntime)runtime, (IServerType)serverType2, (String)name, (String)"local");
        swc.setAttribute("auto-publish-setting", 1);
        return swc.save(true, (IProgressMonitor)new NullProgressMonitor());
    }

    private static IServer createDeployOnlyServer(String deployLocation, String tempDeployLocation) throws CoreException {
        return ServerCreationTestUtils.createDeployOnlyServer(deployLocation, tempDeployLocation, "testRuntime", "testServer");
    }

    private static IServer createDeployOnlyServer(String deployLocation, String tempDeployLocation, String rtName, String serverName) throws CoreException {
        IServerWorkingCopy wc = ServerCreationUtils.createDeployOnlyServerWorkingCopy((String)deployLocation, (String)tempDeployLocation, (String)rtName, (String)serverName);
        wc.setAttribute("auto-publish-setting", 1);
        return wc.save(true, (IProgressMonitor)new NullProgressMonitor());
    }

    private static IServer createJBoss7IServer(IServerType serverType, String rtLoc, String name) throws CoreException {
        IRuntime runtime = RuntimeUtils.createRuntime((String)serverType.getRuntimeType().getId(), (String)rtLoc, null);
        IServerWorkingCopy swc = ServerCreationUtils.createServerWorkingCopy((IRuntime)runtime, (IServerType)serverType, (String)name, (String)"local");
        swc.setServerConfiguration(null);
        swc.setAttribute("auto-publish-setting", 1);
        IServer server = swc.save(true, null);
        return server;
    }

    public static IPath getRandomAbsoluteFolder() {
        return ServerCreationTestUtils.getBaseDir().append(ServerCreationTestUtils.getRandomString());
    }

    private static String getDeployFolder() {
        return ServerCreationTestUtils.getRandomAbsoluteFolder().append("deploy").toOSString();
    }

    private static String getTmpDeployFolder() {
        return ServerCreationTestUtils.getRandomAbsoluteFolder().append("tmpDeploy").toOSString();
    }

    private static String getRandomString() {
        return String.valueOf(System.currentTimeMillis());
    }

    private static IPath getBaseDir() {
        return ASMatrixTests.getDefault().getStateLocation().append("testDeployments");
    }

    public static void deleteAllServersAndRuntimes() throws Exception {
        ServerCreationTestUtils.deleteAllServers();
        ServerCreationTestUtils.deleteAllRuntimes();
    }

    public static void deleteAllServers() throws CoreException {
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            servers[i].delete();
            ++i;
        }
    }

    public static void deleteAllRuntimes() throws CoreException {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        int i = 0;
        while (i < runtimes.length) {
            runtimes[i].delete();
            ++i;
        }
    }
}

