/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.server.bean.JBossServerType;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanLoader;
import org.jboss.tools.as.runtimes.integration.util.RuntimeMatcher;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.osgi.framework.Version;

@RunWith(value=Parameterized.class)
public class ServerBeanRuntimeMatcherTest
extends TestCase {
    private HashMap<String, Data> expected = new HashMap();
    private String serverType;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection(ServerParameterUtils.getJBossServerTypeParametersPlusAdditionalMocks());
    }

    public ServerBeanRuntimeMatcherTest(String serverType) {
        this.serverType = serverType;
    }

    @After
    public void tearDown() throws Exception {
        ASMatrixTests.cleanup();
    }

    @Before
    public void setUp() {
        this.expected.put("org.jboss.ide.eclipse.as.32", new Data(JBossServerType.AS, "3.2"));
        this.expected.put("org.jboss.ide.eclipse.as.40", new Data(JBossServerType.AS, "4.0"));
        this.expected.put("org.jboss.ide.eclipse.as.42", new Data(JBossServerType.AS, "4.2"));
        this.expected.put("org.jboss.ide.eclipse.as.50", new Data(JBossServerType.AS, "5.0"));
        this.expected.put("org.jboss.ide.eclipse.as.51", new Data(JBossServerType.AS, "5.1"));
        this.expected.put("org.jboss.ide.eclipse.as.60", new Data(JBossServerType.AS, "6.0"));
        this.expected.put("org.jboss.ide.eclipse.as.70", new Data(JBossServerType.AS7, "7.0"));
        this.expected.put("org.jboss.ide.eclipse.as.71", new Data(JBossServerType.AS7, "7.1"));
        this.expected.put("org.jboss.ide.eclipse.as.wildfly.80", new Data(JBossServerType.WILDFLY80, "8.0"));
        this.expected.put("org.jboss.ide.eclipse.as.wildfly.90", new Data(JBossServerType.WILDFLY90, "9.0"));
        this.expected.put("org.jboss.ide.eclipse.as.wildfly.100", new Data(JBossServerType.WILDFLY100, "10.0"));
        this.expected.put("org.jboss.ide.eclipse.as.eap.43", new Data(JBossServerType.EAP_STD, "4.3"));
        this.expected.put("org.jboss.ide.eclipse.as.eap.50", new Data(JBossServerType.EAP_STD, "5.1"));
        this.expected.put("org.jboss.ide.eclipse.as.eap.60", new Data(JBossServerType.EAP6, "6.0"));
        this.expected.put("org.jboss.ide.eclipse.as.eap.61", new Data(JBossServerType.EAP61, "6.1"));
        this.expected.put("org.jboss.ide.eclipse.as.eap.70", new Data(JBossServerType.EAP70, "7.0"));
        this.expected.put("TEST_SERVER_TYPE_EAP_65", new Data(JBossServerType.EAP61, "6.5"));
        this.expected.put("TEST_SERVER_TYPE_GATEIN_34", new Data(JBossServerType.AS7GateIn, "3.4"));
        this.expected.put("TEST_SERVER_TYPE_GATEIN_35", new Data(JBossServerType.AS7GateIn, "3.5"));
        this.expected.put("TEST_SERVER_TYPE_GATEIN_36", new Data(JBossServerType.AS7GateIn, "3.6"));
        this.expected.put("TEST_SERVER_TYPE_JPP_60", new Data(JBossServerType.JPP6, "6.0"));
        this.expected.put("TEST_SERVER_TYPE_JPP_61", new Data(JBossServerType.JPP61, "6.1", "JPP"));
        this.expected.put("TEST_SERVER_TYPE_WONKA_1_MISMATCH", new Data(JBossServerType.UNKNOWN_AS72_PRODUCT, "1.0", "WONKA"));
    }

    @Test
    public void testServerBeanRuntimeMatcherForMocks() {
        File serverDir = ServerCreationTestUtils.createMockServerLayout(this.serverType);
        if (serverDir == null || !serverDir.exists()) {
            ServerBeanRuntimeMatcherTest.fail((String)("Creation of mock server type " + this.serverType + " has failed."));
        }
        Data p = this.expected.get(this.serverType);
        try {
            ServerCreationTestUtils.createServerWithRuntime(p.type.getServerAdapterTypeId(p.version), this.serverType, serverDir);
        }
        catch (CoreException coreException) {}
        this.inner_testServerBeanRuntimeMatcherForMocks(serverDir, p.type, p.version, p.overrideId);
    }

    private void inner_testServerBeanRuntimeMatcherForMocks(File serverDir, JBossServerType expectedType, String expectedVersion, String underlyingId) {
        ServerBeanRuntimeMatcherTest.assertNotNull((Object)this.serverType);
        IServerType itype = ServerCore.findServerType((String)expectedType.getServerAdapterTypeId(expectedVersion));
        if (itype == null) {
            ServerBeanRuntimeMatcherTest.fail((String)("Server type " + itype + " not found in the build"));
        }
        if (this.expected.get(this.serverType) == null) {
            ServerBeanRuntimeMatcherTest.fail((String)"Test Case needs to be updated for new adapter or mock test");
        }
        ServerBeanLoader loader = new ServerBeanLoader(serverDir);
        JBossServerType type = loader.getServerType();
        ServerBeanRuntimeMatcherTest.assertEquals((String)("Expected and actual server beans do not match for server type " + this.serverType), (Object)expectedType, (Object)type);
        String fullVersion = loader.getFullServerVersion();
        ServerBeanRuntimeMatcherTest.assertTrue((String)(String.valueOf(fullVersion) + " does not begin with " + expectedVersion + " for server type " + this.serverType), (boolean)fullVersion.startsWith(expectedVersion));
        ServerBeanRuntimeMatcherTest.assertEquals((String)loader.getServerAdapterId(), (String)itype.getId());
        RuntimeMatcher matcher = new RuntimeMatcher();
        String serverTypeId = loader.getServerAdapterId();
        IServerType stype = ServerCore.findServerType((String)serverTypeId);
        String rtTypeId = stype.getRuntimeType().getId();
        ServerBeanRuntimeMatcherTest.assertEquals((int)1, (int)matcher.findExistingRuntimes(rtTypeId).length);
        ServerBeanRuntimeMatcherTest.assertEquals((int)0, (int)matcher.findExistingRuntimes(String.valueOf(rtTypeId) + "0").length);
        String expectedTypeOverride = underlyingId == null ? expectedType.getId() : underlyingId;
        ServerBeanRuntimeMatcherTest.assertEquals((int)1, (int)matcher.findExistingRuntimes(matcher.createPattern(rtTypeId, expectedTypeOverride)).length);
        ServerBeanRuntimeMatcherTest.assertEquals((int)0, (int)matcher.findExistingRuntimes(matcher.createPattern(rtTypeId, String.valueOf(expectedTypeOverride) + "0")).length);
        ServerBeanRuntimeMatcherTest.assertEquals((int)1, (int)matcher.findExistingRuntimes(matcher.createPattern(rtTypeId, expectedTypeOverride, expectedVersion, true, this.incrementMinor(expectedVersion), false)).length);
        ServerBeanRuntimeMatcherTest.assertEquals((int)0, (int)matcher.findExistingRuntimes(matcher.createPattern(rtTypeId, expectedTypeOverride, this.incrementMajor(expectedVersion), true, this.incrementMajor(expectedVersion, 2), false)).length);
    }

    private String incrementMajor(String v) {
        return this.incrementMajor(v, 1);
    }

    private String incrementMinor(String v) {
        return this.incrementMinor(v, 1);
    }

    private String incrementMicro(String v) {
        return this.incrementMicro(v, 1);
    }

    private String incrementMajor(String v, int c) {
        Version vers = new Version(v);
        Version vers2 = new Version(vers.getMajor() + c, 0, 0, "Final");
        return vers2.toString();
    }

    private String incrementMinor(String v, int c) {
        Version vers = new Version(v);
        Version vers2 = new Version(vers.getMajor(), vers.getMinor() + c, 0, "Final");
        return vers2.toString();
    }

    private String incrementMicro(String v, int c) {
        Version vers = new Version(v);
        Version vers2 = new Version(vers.getMajor(), vers.getMinor(), vers.getMicro() + c, "Final");
        return vers2.toString();
    }

    private class Data {
        private JBossServerType type;
        private String version;
        private String overrideId;

        public Data(JBossServerType type, String version) {
            this.type = type;
            this.version = version;
            this.overrideId = null;
        }

        public Data(JBossServerType type, String version, String oid) {
            this(type, version);
            this.overrideId = oid;
        }
    }
}

