/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server.publishing.defect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.IOUtil;
import org.jboss.tools.as.test.core.internal.utils.MatrixUtils;
import org.jboss.tools.as.test.core.internal.utils.MockModule;
import org.jboss.tools.as.test.core.internal.utils.MockModuleUtil;
import org.jboss.tools.as.test.core.parametized.server.publishing.AbstractPublishingTest;
import org.jboss.tools.as.test.core.subsystems.impl.CustomPublishController;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DeployNameTest
extends AbstractPublishingTest {
    private IModule[] module;

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        String[] zipOption = new String[]{"unzipped", "zipped"};
        Object[][] allOptions = new Object[][]{zipOption};
        return MatrixUtils.toMatrix(allOptions);
    }

    public DeployNameTest(String zip) {
        super("org.jboss.ide.eclipse.as.71", zip, "metadata", "permod_default");
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp(false);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void createProjects() throws Exception {
        this.module = this.createUtilInWebModule("TestWeb", "TestUtil");
        this.addModuleToServer(this.module[0]);
    }

    @Test
    public void testPublish() throws Exception {
        CustomPublishController controller = new CustomPublishController();
        controller.initialize((IServerAttributes)this.server, null, null);
        IModule[] web = new IModule[]{this.module[0]};
        IModule[] utilInWeb = new IModule[]{this.module[0], this.module[1]};
        this.setUnderlyingVersion(1);
        this.setUtilUnderlyingVersion(1);
        controller.publishStart((IProgressMonitor)new NullProgressMonitor());
        controller.publishServer(1, (IProgressMonitor)new NullProgressMonitor());
        int resultWeb = controller.publishModule(2, 1, web, (IProgressMonitor)new NullProgressMonitor());
        int resultUtil = controller.publishModule(2, 1, utilInWeb, (IProgressMonitor)new NullProgressMonitor());
        controller.publishFinish((IProgressMonitor)new NullProgressMonitor());
        DeployNameTest.assertEquals((int)resultWeb, (int)1);
        DeployNameTest.assertEquals((int)resultUtil, (int)1);
        IPath webPath = controller.getDeployPathController().getDeployDirectory(web);
        DeployNameTest.assertTrue((boolean)webPath.toString().contains("TestWeb"));
        DeployNameTest.assertTrue((boolean)webPath.toFile().exists());
        IPath utilJar = webPath.append("WEB-INF/lib/util.jar");
        if (!this.isZipped()) {
            DeployNameTest.assertTrue((boolean)utilJar.toFile().exists());
        }
    }

    private IPath getUnderlying() {
        IPath underlying = ASMatrixTests.getDefault().getStateLocation().append("underlying.txt");
        return underlying;
    }

    private IPath getUtilUnderlying() {
        IPath underlying = ASMatrixTests.getDefault().getStateLocation().append("\u7b28.txt");
        return underlying;
    }

    private IPath setUnderlyingVersion(int v) throws Exception {
        IPath underlying = this.getUnderlying();
        underlying.toFile().getParentFile().mkdirs();
        IOUtil.setContents(underlying.toFile(), "version" + v);
        return underlying;
    }

    private IPath setUtilUnderlyingVersion(int v) throws Exception {
        IPath underlying = this.getUtilUnderlying();
        underlying.toFile().getParentFile().mkdirs();
        IOUtil.setContents(underlying.toFile(), "version" + v);
        return underlying;
    }

    private IPath[] getUtilLeafPaths() {
        return new IPath[]{new Path("\u7b28.txt")};
    }

    private IPath[] getWebLeafPaths() {
        IPath[] leafs = new IPath[]{new Path("w.txt")};
        return leafs;
    }

    private MockModule[] createUtilInWebModule(String webName, String utilName) throws Exception {
        IPath underlying = this.setUnderlyingVersion(1);
        IPath utilUnderlying = this.setUtilUnderlyingVersion(1);
        MockModule web = MockModuleUtil.createMockWebModule();
        web.setProperty("org.eclipse.wst.server.core.deployName", webName);
        MockModule util = MockModuleUtil.createMockUtilModule();
        util.setProperty("org.eclipse.wst.server.core.deployName", utilName);
        web.addChildModule(util, "WEB-INF/lib/util.jar");
        IPath[] webLeafs = this.getWebLeafPaths();
        IModuleResource[] webR = MockModuleUtil.createMockResources(webLeafs, new IPath[0], underlying.toFile());
        web.setMembers(webR);
        web.setExists(true);
        IPath[] utilLeafs = this.getUtilLeafPaths();
        IModuleResource[] utilR = MockModuleUtil.createMockResources(utilLeafs, new IPath[0], utilUnderlying.toFile());
        util.setMembers(utilR);
        util.setExists(true);
        return new MockModule[]{web, util};
    }

    protected void verifyListRelativePath(IPath root, List<IPath> list, boolean exists) {
        ArrayList<IPath> list2 = new ArrayList<IPath>();
        Iterator<IPath> i = list.iterator();
        while (i.hasNext()) {
            list2.add(root.append(i.next()));
        }
        super.verifyList(root, list2, exists);
    }
}

