/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.function.aspects.validation.rules;

import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.function.FunctionParameter;
import org.teiid.designer.metamodels.function.FunctionPlugin;

public class FunctionParameterRule
implements ObjectValidationRule {
    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(FunctionParameter.class, (Object)eObject);
        ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
        FunctionParameter param = (FunctionParameter)eObject;
        String paramType = param.getType();
        if (paramType == null || paramType.length() == 0) {
            String msg = FunctionPlugin.Util.getString("FunctionParameterRule.Parameter_type_may_not_be_null_or_empty_1", new Object[0]);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem((ValidationProblem)problem);
        } else {
            try {
                DatatypeManager manager = context.getDatatypeManager();
                EObject builtInType = manager.getBuiltInDatatype(paramType);
                if (builtInType == null) {
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, String.valueOf(FunctionPlugin.Util.getString("FunctionParameterRule.Function_parameter_type_is_not_a_builtinType___1", new Object[0])) + paramType);
                    result.addProblem((ValidationProblem)problem);
                }
            }
            catch (ModelerCoreException modelerCoreException) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, String.valueOf(FunctionPlugin.Util.getString("FunctionParameterRule.Error_trying_to_get_builtinType_for_function_parameter_type___2", new Object[0])) + paramType);
                result.addProblem((ValidationProblem)problem);
            }
        }
        context.addResult((ValidationResult)result);
    }
}

