/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.function.extension;

import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.extension.EmfModelObjectExtensionAssistant;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.NamespaceProvider;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.function.ScalarFunction;
import org.teiid.designer.metamodels.function.extension.FunctionModelExtensionConstants;

public class FunctionModelExtensionAssistant
extends EmfModelObjectExtensionAssistant {
    private static String getPropertyId(String propName) {
        return ModelExtensionPropertyDefinition.Utils.getPropertyId((NamespaceProvider)FunctionModelExtensionConstants.NAMESPACE_PROVIDER, (String)propName);
    }

    public void applyMedIfNecessary(IResource model) throws Exception {
        ModelResource modelResource;
        if (model != null && (modelResource = ModelerCore.getModelWorkspace().findModelResource(model)) != null && !modelResource.isReadOnly() && ModelType.FUNCTION_LITERAL == modelResource.getModelType() && "http://www.metamatrix.com/metamodels/MetaMatrixFunction".equals(modelResource.getPrimaryMetamodelUri()) && !this.supportsMyNamespace(model)) {
            this.saveModelExtensionDefinition(model);
        }
    }

    protected ModelExtensionPropertyDefinition getPropertyDefinition(Object modelObject, String propId) throws Exception {
        CoreArgCheck.isInstanceOf(EObject.class, (Object)modelObject);
        ModelExtensionPropertyDefinition propDefn = super.getPropertyDefinition(modelObject, propId);
        if (propDefn != null && modelObject instanceof ScalarFunction) {
            if (PropertyName.same(PropertyName.ANALYTIC, propId) || PropertyName.same(PropertyName.ALLOWS_ORDER_BY, propId) || PropertyName.same(PropertyName.USES_DISTINCT_ROWS, propId) || PropertyName.same(PropertyName.ALLOWS_DISTINCT, propId) || PropertyName.same(PropertyName.DECOMPOSABLE, propId)) {
                String isAggregate = this.getPropertyValue(modelObject, PropertyName.AGGREGATE.toString());
                if (Boolean.parseBoolean(isAggregate)) {
                    return propDefn;
                }
                this.removeProperty(modelObject, PropertyName.ANALYTIC.toString());
                this.removeProperty(modelObject, PropertyName.ALLOWS_ORDER_BY.toString());
                this.removeProperty(modelObject, PropertyName.USES_DISTINCT_ROWS.toString());
                this.removeProperty(modelObject, PropertyName.DECOMPOSABLE.toString());
                this.removeProperty(modelObject, PropertyName.ALLOWS_DISTINCT.toString());
                return null;
            }
            return propDefn;
        }
        return null;
    }

    public void setPropertyValue(Object modelObject, String propId, String newValue) throws Exception {
        super.setPropertyValue(modelObject, propId, newValue);
        if (PropertyName.same(PropertyName.AGGREGATE, propId) && !Boolean.parseBoolean(newValue)) {
            this.removeProperty(modelObject, PropertyName.ANALYTIC.toString());
            this.removeProperty(modelObject, PropertyName.ALLOWS_ORDER_BY.toString());
            this.removeProperty(modelObject, PropertyName.USES_DISTINCT_ROWS.toString());
            this.removeProperty(modelObject, PropertyName.ALLOWS_DISTINCT.toString());
            this.removeProperty(modelObject, PropertyName.DECOMPOSABLE.toString());
        }
    }

    public boolean supportsMedOperation(String proposedOperationName, Object context) {
        CoreArgCheck.isNotEmpty((String)proposedOperationName, (String)"proposedOperationName is empty");
        return "SHOW_IN_REGISTRY".equals(proposedOperationName);
    }

    static /* synthetic */ String access$0(String string) {
        return FunctionModelExtensionAssistant.getPropertyId(string);
    }

    private static enum PropertyName {
        UDF_JAR_PATH(FunctionModelExtensionAssistant.access$0("udfJarPath")),
        AGGREGATE(FunctionModelExtensionAssistant.access$0("aggregate")),
        ALLOWS_ORDER_BY(FunctionModelExtensionAssistant.access$0("allows-orderby")),
        ALLOWS_DISTINCT(FunctionModelExtensionAssistant.access$0("allows-distinct")),
        ANALYTIC(FunctionModelExtensionAssistant.access$0("analytic")),
        DECOMPOSABLE(FunctionModelExtensionAssistant.access$0("decomposable")),
        USES_DISTINCT_ROWS(FunctionModelExtensionAssistant.access$0("uses-distinct-rows")),
        VARARGS(FunctionModelExtensionAssistant.access$0("varargs")),
        NULL_ON_NULL(FunctionModelExtensionAssistant.access$0("null-on-null"));

        private final String propName;

        public static boolean same(PropertyName propName, String value) {
            return propName.toString().equals(value);
        }

        private PropertyName(String propName) {
            this.propName = propName;
        }

        public String toString() {
            return this.propName;
        }
    }
}

