/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.teiid.adminapi.AdminObject;
import org.teiid.adminapi.impl.KeyBuilder;
import org.teiid.adminapi.impl.ListOverMap;
import org.teiid.adminapi.impl.PropertyMetadata;
import org.teiid.core.util.CopyOnWriteLinkedHashMap;
import org.teiid.designer.annotation.Removed;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;

public abstract class AdminObjectImpl
implements AdminObject,
Serializable {
    private static final long serialVersionUID = -6381303538713462682L;
    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    private transient ListOverMap<PropertyMetadata> sevenProperties = new ListOverMap<PropertyMetadata>(new KeyBuilder<PropertyMetadata>(){
        private static final long serialVersionUID = 3687928367250819142L;

        @Override
        public String getKey(PropertyMetadata entry) {
            return entry.getName();
        }
    });
    private String name;
    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    private String serverGroup;
    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    private String serverName;
    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    private String hostName;
    private Map<String, String> properties = new CopyOnWriteLinkedHashMap<String, String>();
    protected transient Map<Class<?>, Object> attachments = new CopyOnWriteLinkedHashMap();

    protected boolean isListOverMap(Object obj) {
        return obj instanceof ListOverMap;
    }

    protected boolean isLinkedHashMap(Object obj) {
        return obj instanceof LinkedHashMap;
    }

    protected boolean isMap(Object obj) {
        return obj instanceof Map;
    }

    private Map<String, String> convertProperties(ListOverMap<PropertyMetadata> overMap) {
        CopyOnWriteLinkedHashMap<String, String> newMap = new CopyOnWriteLinkedHashMap<String, String>();
        for (Map.Entry<String, PropertyMetadata> entry : overMap.getMap().entrySet()) {
            PropertyMetadata propertyMetadata = entry.getValue();
            newMap.put(propertyMetadata.getName(), propertyMetadata.getValue());
        }
        return Collections.synchronizedMap(newMap);
    }

    protected <K, V> CopyOnWriteLinkedHashMap<K, V> newCopyOnWriteLinkedHashMap(Map<K, V> oldMap) {
        if (oldMap instanceof CopyOnWriteLinkedHashMap) {
            return (CopyOnWriteLinkedHashMap)oldMap;
        }
        CopyOnWriteLinkedHashMap<K, V> newMap = new CopyOnWriteLinkedHashMap<K, V>();
        newMap.putAll(oldMap);
        return newMap;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField serFields = ois.readFields();
        this.name = (String)serFields.get("name", null);
        this.serverGroup = (String)serFields.get("serverGroup", null);
        this.serverName = (String)serFields.get("serverName", null);
        this.hostName = (String)serFields.get("hostName", null);
        Object serProps = serFields.get("properties", null);
        if (serProps instanceof Map) {
            this.properties = this.newCopyOnWriteLinkedHashMap((Map)serProps);
            return;
        }
        if (serProps instanceof ListOverMap) {
            ListOverMap overMap = (ListOverMap)serProps;
            this.properties = this.convertProperties(overMap);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getServerGroup() {
        return this.serverGroup;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setServerGroup(String group) {
        this.serverGroup = group;
    }

    public void setServerName(String name) {
        this.serverName = name;
    }

    public void setHostName(String name) {
        this.hostName = name;
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll(this.properties);
        return props;
    }

    public void setProperties(Properties props) {
        this.properties.clear();
        if (props != null && !props.isEmpty()) {
            for (String key : props.stringPropertyNames()) {
                this.addProperty(key, props.getProperty(key));
            }
        }
    }

    public Map<String, String> getPropertiesMap() {
        return this.properties;
    }

    @Override
    public String getPropertyValue(String key) {
        return this.properties.get(key);
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public <T> T addAttchment(Class<T> type, T attachment) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        Object result = this.attachments.put(type, attachment);
        return type.cast(result);
    }

    public <T> T removeAttachment(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        Object result = this.attachments.remove(type);
        return type.cast(result);
    }

    public <T> T getAttachment(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        Object result = this.attachments.get(type);
        return type.cast(result);
    }
}

