/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.AdminObjectImpl;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.EntryMetaData;
import org.teiid.adminapi.impl.KeyBuilder;
import org.teiid.adminapi.impl.ListOverMap;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBImportMetadata;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.core.util.CopyOnWriteLinkedHashMap;
import org.teiid.core.util.StringUtil;
import org.teiid.designer.annotation.Removed;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;

public class VDBMetaData
extends AdminObjectImpl
implements VDB,
Cloneable {
    private static final String VERSION_DELIM = ".";
    private static final long serialVersionUID = -4723595252013356436L;
    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    private transient ListOverMap<ModelMetaData> sevenModels = new ListOverMap<ModelMetaData>(new KeyBuilder<ModelMetaData>(){
        private static final long serialVersionUID = 846247100420118961L;

        @Override
        public String getKey(ModelMetaData entry) {
            return entry.getName();
        }
    });
    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    private transient ListOverMap<VDBTranslatorMetaData> sevenTranslators = new ListOverMap<VDBTranslatorMetaData>(new KeyBuilder<VDBTranslatorMetaData>(){
        private static final long serialVersionUID = 3890502172003653563L;

        @Override
        public String getKey(VDBTranslatorMetaData entry) {
            return entry.getName();
        }
    });
    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    private transient ListOverMap<DataPolicyMetadata> sevenDataPolicies = new ListOverMap<DataPolicyMetadata>(new KeyBuilder<DataPolicyMetadata>(){
        private static final long serialVersionUID = 4954591545242715254L;

        @Override
        public String getKey(DataPolicyMetadata entry) {
            return entry.getName();
        }
    });
    private LinkedHashMap<String, ModelMetaData> models = new LinkedHashMap();
    private LinkedHashMap<String, VDBTranslatorMetaData> translators = new LinkedHashMap();
    private LinkedHashMap<String, DataPolicyMetadata> dataPolicies = new LinkedHashMap();
    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    private List<VDBImportMetadata> imports = new ArrayList<VDBImportMetadata>(2);
    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    private List<EntryMetaData> entries = new ArrayList<EntryMetaData>(2);
    private int version = 1;
    private String description;
    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    private String fileUrl;
    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    private boolean xmlDeployment = false;
    private volatile VDB.Status status = VDB.Status.ACTIVE;
    private VDB.ConnectionType connectionType = VDB.ConnectionType.BY_VERSION;
    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    private boolean removed;
    private long queryTimeout = Long.MIN_VALUE;
    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    private Set<String> importedModels = Collections.emptySet();
    @Since(value=TeiidServerVersion.Version.TEIID_8_9)
    private Map<String, Boolean> visibilityOverrides = new HashMap<String, Boolean>(2);

    private LinkedHashMap<String, ModelMetaData> convertModels(ListOverMap<ModelMetaData> overMap) {
        LinkedHashMap<String, ModelMetaData> newMap = new LinkedHashMap<String, ModelMetaData>();
        for (Map.Entry<String, ModelMetaData> entry : overMap.getMap().entrySet()) {
            newMap.put(entry.getKey(), entry.getValue());
        }
        return newMap;
    }

    private LinkedHashMap<String, DataPolicyMetadata> convertDataPolicies(ListOverMap<DataPolicyMetadata> overMap) {
        LinkedHashMap<String, DataPolicyMetadata> newMap = new LinkedHashMap<String, DataPolicyMetadata>();
        for (Map.Entry<String, DataPolicyMetadata> entry : overMap.getMap().entrySet()) {
            newMap.put(entry.getKey(), entry.getValue());
        }
        return newMap;
    }

    private LinkedHashMap<String, VDBTranslatorMetaData> convertTranslators(ListOverMap<VDBTranslatorMetaData> overMap) {
        LinkedHashMap<String, VDBTranslatorMetaData> newMap = new LinkedHashMap<String, VDBTranslatorMetaData>();
        for (Map.Entry<String, VDBTranslatorMetaData> entry : overMap.getMap().entrySet()) {
            newMap.put(entry.getKey(), entry.getValue());
        }
        return newMap;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField readFields = ois.readFields();
        Object serModels = readFields.get("models", null);
        if (this.isLinkedHashMap(serModels)) {
            this.models = (LinkedHashMap)serModels;
        } else if (this.isListOverMap(serModels)) {
            ListOverMap overMap = (ListOverMap)serModels;
            this.models = this.convertModels(overMap);
        } else {
            throw new IllegalStateException();
        }
        Object serTranslators = readFields.get("translators", null);
        if (this.isLinkedHashMap(serModels)) {
            this.translators = (LinkedHashMap)serTranslators;
        } else if (this.isListOverMap(serModels)) {
            ListOverMap overMap = (ListOverMap)serTranslators;
            this.translators = this.convertTranslators(overMap);
        } else {
            throw new IllegalStateException();
        }
        Object serDataPolicies = readFields.get("dataPolicies", null);
        if (this.isLinkedHashMap(serModels)) {
            this.dataPolicies = (LinkedHashMap)serDataPolicies;
        } else if (this.isListOverMap(serModels)) {
            ListOverMap overMap = (ListOverMap)serDataPolicies;
            this.dataPolicies = this.convertDataPolicies(overMap);
        } else {
            throw new IllegalStateException();
        }
        this.version = readFields.get("version", 1);
        this.description = (String)readFields.get("description", null);
        this.fileUrl = (String)readFields.get("fileUrl", null);
        this.imports = (List)readFields.get("imports", null);
        this.entries = (List)readFields.get("entries", null);
        this.xmlDeployment = readFields.get("xmlDeployment", false);
        this.status = (VDB.Status)((Object)readFields.get("status", null));
        this.connectionType = (VDB.ConnectionType)((Object)readFields.get("connectionType", null));
        this.removed = readFields.get("removed", false);
        this.queryTimeout = readFields.get("queryTimeout", Long.MIN_VALUE);
        this.importedModels = (Set)readFields.get("importedModels", null);
    }

    public String getFullName() {
        return String.valueOf(this.getName()) + VERSION_DELIM + this.getVersion();
    }

    @Override
    public VDB.ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(VDB.ConnectionType allowConnections) {
        this.connectionType = allowConnections;
    }

    public void setConnectionType(String allowConnections) {
        this.connectionType = VDB.ConnectionType.valueOf(allowConnections);
    }

    @Override
    public VDB.Status getStatus() {
        return this.status;
    }

    public synchronized void setStatus(VDB.Status s) {
        this.notifyAll();
        this.status = s;
    }

    public void setStatus(String s) {
        this.setStatus(VDB.Status.valueOf(s));
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    public String getUrl() {
        return this.fileUrl;
    }

    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    public void setUrl(String url) {
        this.fileUrl = url;
    }

    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    public void setUrl(URL url) {
        String fileName;
        String[] parts;
        this.setUrl(url.toExternalForm());
        String path = url.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((parts = (fileName = StringUtil.getLastToken(path, "/")).split("\\."))[0].equalsIgnoreCase(this.getName()) && parts.length >= 3) {
            try {
                int fileVersion = Integer.parseInt(parts[parts.length - 2]);
                this.setVersion(fileVersion);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public List<Model> getModels() {
        return new ArrayList<Model>(this.models.values());
    }

    public LinkedHashMap<String, ModelMetaData> getModelMetaDatas() {
        return this.models;
    }

    public void setModels(Collection<ModelMetaData> models) {
        this.models.clear();
        for (ModelMetaData obj : models) {
            this.addModel(obj);
        }
    }

    public ModelMetaData addModel(ModelMetaData m) {
        return this.models.put(m.getName(), m);
    }

    @Override
    public List<Translator> getOverrideTranslators() {
        return new ArrayList<Translator>(this.translators.values());
    }

    public LinkedHashMap<String, VDBTranslatorMetaData> getOverrideTranslatorsMap() {
        return this.translators;
    }

    public void setOverrideTranslators(List<Translator> translators) {
        for (Translator t : translators) {
            this.translators.put(t.getName(), (VDBTranslatorMetaData)t);
        }
    }

    public void addOverideTranslator(VDBTranslatorMetaData t) {
        this.translators.put(t.getName(), t);
    }

    public boolean isOverideTranslator(String name) {
        return this.translators.containsKey(name);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    @Override
    public List<String> getValidityErrors() {
        ArrayList<String> allErrors = new ArrayList<String>();
        for (ModelMetaData model : this.models.values()) {
            List<ModelMetaData.Message> errors = model.getMessages();
            if (errors == null || errors.isEmpty()) continue;
            for (ModelMetaData.Message m : errors) {
                if (m.getSeverity() != ModelMetaData.Message.Severity.ERROR) continue;
                allErrors.add(m.getValue());
            }
        }
        return allErrors;
    }

    @Override
    public boolean isValid() {
        return this.status == VDB.Status.ACTIVE && !this.hasErrors();
    }

    public boolean hasErrors() {
        for (ModelMetaData model : this.models.values()) {
            if (!model.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getName()) + VERSION_DELIM + this.getVersion() + this.models.values();
    }

    @Override
    public boolean isVisible(String modelName) {
        Boolean result;
        ModelMetaData model = this.getModel(modelName);
        if (model == null) {
            return true;
        }
        if (!this.visibilityOverrides.isEmpty() && (result = this.visibilityOverrides.get(modelName)) != null) {
            return result;
        }
        return model.isVisible();
    }

    public ModelMetaData getModel(String modelName) {
        return this.models.get(modelName);
    }

    public boolean isXmlDeployment() {
        return this.xmlDeployment;
    }

    public void setXmlDeployment(boolean dynamic) {
        this.xmlDeployment = dynamic;
    }

    @Override
    public List<DataPolicy> getDataPolicies() {
        return new ArrayList<DataPolicy>(this.dataPolicies.values());
    }

    public void setDataPolicies(List<DataPolicy> policies) {
        this.dataPolicies.clear();
        for (DataPolicy policy : policies) {
            this.dataPolicies.put(policy.getName(), (DataPolicyMetadata)policy);
        }
    }

    public DataPolicyMetadata addDataPolicy(DataPolicyMetadata policy) {
        return this.dataPolicies.put(policy.getName(), policy);
    }

    public LinkedHashMap<String, DataPolicyMetadata> getDataPolicyMap() {
        return this.dataPolicies;
    }

    public VDBTranslatorMetaData getTranslator(String name) {
        return this.translators.get(name);
    }

    public boolean isPreview() {
        return Boolean.valueOf(this.getPropertyValue("preview"));
    }

    public long getQueryTimeout() {
        if (this.queryTimeout == Long.MIN_VALUE) {
            String timeout = this.getPropertyValue("query-timeout");
            this.queryTimeout = timeout != null ? Math.max(0L, Long.parseLong(timeout)) : 0L;
        }
        return this.queryTimeout;
    }

    public List<VDBImportMetadata> getVDBImports() {
        return this.imports;
    }

    public Set<String> getImportedModels() {
        return this.importedModels;
    }

    public void setImportedModels(Set<String> importedModels) {
        this.importedModels = importedModels;
    }

    public List<EntryMetaData> getEntries() {
        return this.entries;
    }

    public void setEntries(List<EntryMetaData> entries) {
        this.entries = entries;
    }

    public VDBMetaData clone() {
        try {
            VDBMetaData clone = (VDBMetaData)super.clone();
            clone.models = new LinkedHashMap<String, ModelMetaData>(this.models);
            clone.attachments = new CopyOnWriteLinkedHashMap();
            clone.attachments.putAll(this.attachments);
            clone.dataPolicies = new LinkedHashMap<String, DataPolicyMetadata>(this.dataPolicies);
            clone.visibilityOverrides = new HashMap<String, Boolean>(this.visibilityOverrides);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_9)
    public void setVisibilityOverride(String name, boolean visible) {
        this.visibilityOverrides.put(name, visible);
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_9)
    public Map<String, Boolean> getVisibilityOverrides() {
        return this.visibilityOverrides;
    }
}

