/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.jboss;

import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.Request;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.AdminObjectImpl;
import org.teiid.adminapi.impl.CacheStatisticsMetadata;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.EngineStatisticsMetadata;
import org.teiid.adminapi.impl.EntryMetaData;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.TransactionMetadata;
import org.teiid.adminapi.impl.VDBImportMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.adminapi.impl.WorkerPoolStatisticsMetadata;
import org.teiid.adminapi.jboss.MetadataMapper;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.runtime.client.Messages;

public class VDBMetadataMapper
implements MetadataMapper<VDBMetaData> {
    private static final String VDBNAME = "vdb-name";
    private static final String CONNECTIONTYPE = "connection-type";
    private static final String STATUS = "status";
    private static final String VERSION = "vdb-version";
    private static final String MODELS = "models";
    private static final String IMPORT_VDBS = "import-vdbs";
    private static final String OVERRIDE_TRANSLATORS = "override-translators";
    private static final String VDB_DESCRIPTION = "vdb-description";
    private static final String PROPERTIES = "properties";
    private static final String XML_DEPLOYMENT = "xml-deployment";
    private static final String DATA_POLICIES = "data-policies";
    private static final String DESCRIPTION = "description";
    private static final String ENTRIES = "entries";
    public static VDBMetadataMapper INSTANCE = new VDBMetadataMapper();
    private static final String SERVER_GROUP = "server-group";
    private static final String HOST_NAME = "host-name";
    private static final String SERVER_NAME = "server-name";
    private static final String UNDERSCORE_DESC = "_describe";
    private static final String TYPE = "type";
    private static final String REQUIRED = "required";
    private static final String ALLOWED = "allowed";
    private static final String VALUE_TYPE = "value-type";

    @Override
    public VDBMetaData unwrap(ITeiidServerVersion teiidVersion, ModelNode node) {
        List modelNodes;
        if (node == null) {
            return null;
        }
        VDBMetaData vdb = new VDBMetaData();
        if (node.has(VDBNAME)) {
            vdb.setName(node.get(VDBNAME).asString());
        }
        if (node.has(CONNECTIONTYPE)) {
            vdb.setConnectionType(node.get(CONNECTIONTYPE).asString());
        }
        if (node.has(STATUS)) {
            vdb.setStatus(node.get(STATUS).asString());
        }
        if (node.has(VERSION)) {
            vdb.setVersion(node.get(VERSION).asInt());
        }
        if (node.has(VDB_DESCRIPTION)) {
            vdb.setDescription(node.get(VDB_DESCRIPTION).asString());
        }
        if (node.has(XML_DEPLOYMENT)) {
            vdb.setXmlDeployment(node.get(XML_DEPLOYMENT).asBoolean());
        }
        if (node.get(PROPERTIES).isDefined()) {
            List propNodes = node.get(PROPERTIES).asList();
            for (ModelNode propNode : propNodes) {
                String[] prop = PropertyMetaDataMapper.INSTANCE.unwrap(teiidVersion, propNode);
                if (prop == null) continue;
                vdb.addProperty(prop[0], prop[1]);
            }
        }
        if (node.get(IMPORT_VDBS).isDefined()) {
            modelNodes = node.get(IMPORT_VDBS).asList();
            for (ModelNode modelNode : modelNodes) {
                VDBImportMetadata vdbImport = VDBImportMapper.INSTANCE.unwrap(teiidVersion, modelNode);
                if (vdbImport == null) continue;
                vdb.getVDBImports().add(vdbImport);
            }
        }
        if (node.get(ENTRIES).isDefined()) {
            modelNodes = node.get(ENTRIES).asList();
            for (ModelNode modelNode : modelNodes) {
                EntryMetaData entry = EntryMapper.INSTANCE.unwrap(teiidVersion, modelNode);
                if (entry == null) continue;
                vdb.getEntries().add(entry);
            }
        }
        if (node.get(MODELS).isDefined()) {
            modelNodes = node.get(MODELS).asList();
            for (ModelNode modelNode : modelNodes) {
                ModelMetaData model = ModelMetadataMapper.INSTANCE.unwrap(teiidVersion, modelNode);
                if (model == null) continue;
                vdb.addModel(model);
            }
        }
        if (node.get(OVERRIDE_TRANSLATORS).isDefined()) {
            List translatorNodes = node.get(OVERRIDE_TRANSLATORS).asList();
            for (ModelNode translatorNode : translatorNodes) {
                VDBTranslatorMetaData translator = VDBTranslatorMetaDataMapper.INSTANCE.unwrap(teiidVersion, translatorNode);
                if (translator == null) continue;
                vdb.addOverideTranslator(translator);
            }
        }
        if (node.get(DATA_POLICIES).isDefined()) {
            List policiesNodes = node.get(DATA_POLICIES).asList();
            for (ModelNode policyNode : policiesNodes) {
                DataPolicyMetadata policy = DataPolicyMetadataMapper.INSTANCE.unwrap(teiidVersion, policyNode);
                if (policy == null) continue;
                vdb.addDataPolicy(policy);
            }
        }
        VDBMetadataMapper.unwrapDomain(vdb, node);
        return vdb;
    }

    @Override
    public ModelNode describe(ITeiidServerVersion teiidVersion, ModelNode node) {
        VDBMetadataMapper.addAttribute(node, VDBNAME, ModelType.STRING, true);
        ModelNode connectionsAllowed = new ModelNode();
        connectionsAllowed.add(VDB.ConnectionType.NONE.toString());
        connectionsAllowed.add(VDB.ConnectionType.ANY.toString());
        connectionsAllowed.add(VDB.ConnectionType.BY_VERSION.toString());
        VDBMetadataMapper.addAttribute(node, CONNECTIONTYPE, ModelType.STRING, false);
        node.get(CONNECTIONTYPE).get(ALLOWED).set(connectionsAllowed);
        ModelNode statusAllowed = new ModelNode();
        statusAllowed.add(VDB.Status.ACTIVE.toString());
        statusAllowed.add(VDB.Status.LOADING.toString());
        statusAllowed.add(VDB.Status.FAILED.toString());
        statusAllowed.add(VDB.Status.REMOVED.toString());
        VDBMetadataMapper.addAttribute(node, STATUS, ModelType.STRING, true);
        node.get(STATUS).get(ALLOWED).set(statusAllowed);
        VDBMetadataMapper.addAttribute(node, VERSION, ModelType.INT, true);
        VDBMetadataMapper.addAttribute(node, VDB_DESCRIPTION, ModelType.STRING, false);
        VDBMetadataMapper.addAttribute(node, XML_DEPLOYMENT, ModelType.BOOLEAN, false);
        ModelNode props = node.get(PROPERTIES);
        props.get(TYPE).set(ModelType.LIST);
        props.get(DESCRIPTION).set(Messages.getString(Messages.VDBMetadata.properties_describe, new Object[0]));
        PropertyMetaDataMapper.INSTANCE.describe(teiidVersion, props.get(VALUE_TYPE));
        ModelNode vdbImports = node.get(IMPORT_VDBS);
        vdbImports.get(TYPE).set(ModelType.LIST);
        VDBImportMapper.INSTANCE.describe(teiidVersion, vdbImports.get(VALUE_TYPE));
        vdbImports.get(DESCRIPTION).set(Messages.getString(Messages.VDBMetadata.import_vdbs_describe, new Object[0]));
        ModelNode models = node.get(MODELS);
        models.get(TYPE).set(ModelType.LIST);
        ModelMetadataMapper.INSTANCE.describe(teiidVersion, models.get(VALUE_TYPE));
        models.get(DESCRIPTION).set(Messages.getString(Messages.VDBMetadata.models_describe, new Object[0]));
        ModelNode translators = node.get(OVERRIDE_TRANSLATORS);
        translators.get(TYPE).set(ModelType.LIST);
        translators.get(DESCRIPTION).set(Messages.getString(Messages.VDBMetadata.override_translators_describe, new Object[0]));
        VDBTranslatorMetaDataMapper.INSTANCE.describe(teiidVersion, translators.get(VALUE_TYPE));
        ModelNode dataPolicies = node.get(DATA_POLICIES);
        dataPolicies.get(TYPE).set(ModelType.LIST);
        dataPolicies.get(DESCRIPTION).set(Messages.getString(Messages.VDBMetadata.data_policies_describe, new Object[0]));
        DataPolicyMetadataMapper.INSTANCE.describe(teiidVersion, dataPolicies.get(VALUE_TYPE));
        return node;
    }

    public AttributeDefinition[] getAttributeDefinitions() {
        ObjectListAttributeDefinition properties = ObjectListAttributeDefinition.Builder.of((String)PROPERTIES, (ObjectTypeAttributeDefinition)PropertyMetaDataMapper.INSTANCE.getAttributeDefinition()).build();
        ObjectListAttributeDefinition vdbimports = ObjectListAttributeDefinition.Builder.of((String)IMPORT_VDBS, (ObjectTypeAttributeDefinition)VDBImportMapper.INSTANCE.getAttributeDefinition()).build();
        ObjectListAttributeDefinition models = ObjectListAttributeDefinition.Builder.of((String)MODELS, (ObjectTypeAttributeDefinition)ModelMetadataMapper.INSTANCE.getAttributeDefinition()).build();
        ObjectListAttributeDefinition translators = ObjectListAttributeDefinition.Builder.of((String)OVERRIDE_TRANSLATORS, (ObjectTypeAttributeDefinition)VDBTranslatorMetaDataMapper.INSTANCE.getAttributeDefinition()).build();
        ObjectListAttributeDefinition policies = ObjectListAttributeDefinition.Builder.of((String)DATA_POLICIES, (ObjectTypeAttributeDefinition)DataPolicyMetadataMapper.INSTANCE.getAttributeDefinition()).build();
        return new AttributeDefinition[]{new SimpleAttributeDefinition(VDBNAME, ModelType.STRING, false), new SimpleAttributeDefinition(CONNECTIONTYPE, ModelType.INT, false), new SimpleAttributeDefinition(STATUS, ModelType.BOOLEAN, false), new SimpleAttributeDefinition(VERSION, ModelType.BOOLEAN, false), new SimpleAttributeDefinition(VDB_DESCRIPTION, ModelType.BOOLEAN, true), new SimpleAttributeDefinition(XML_DEPLOYMENT, ModelType.BOOLEAN, true), properties, vdbimports, models, translators, policies};
    }

    private static void addProperties(ModelNode node, AdminObjectImpl object) {
        Map<String, String> properties = object.getPropertiesMap();
        if (properties != null && !properties.isEmpty()) {
            ModelNode propsNode = node.get(PROPERTIES);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                propsNode.add(PropertyMetaDataMapper.INSTANCE.wrap(entry.getKey(), entry.getValue(), new ModelNode()));
            }
        }
    }

    public static void wrapDomain(AdminObjectImpl anObj, ModelNode node) {
        if (anObj.getServerGroup() != null) {
            node.get(SERVER_GROUP).set(anObj.getServerGroup());
        }
        if (anObj.getHostName() != null) {
            node.get(HOST_NAME).set(anObj.getHostName());
        }
        if (anObj.getServerName() != null) {
            node.get(SERVER_NAME).set(anObj.getServerName());
        }
    }

    public static void unwrapDomain(AdminObjectImpl anObj, ModelNode node) {
        if (node.get(SERVER_GROUP).isDefined()) {
            anObj.setServerGroup(node.get(SERVER_GROUP).asString());
        }
        if (node.get(HOST_NAME).isDefined()) {
            anObj.setHostName(node.get(HOST_NAME).asString());
        }
        if (node.get(SERVER_NAME).isDefined()) {
            anObj.setServerName(node.get(SERVER_NAME).asString());
        }
    }

    static ModelNode addAttribute(ModelNode node, String name, ModelType dataType, boolean required) {
        node.get(new String[]{name, TYPE}).set(dataType);
        String nameKey = String.valueOf(name.replaceAll("-", "_")) + UNDERSCORE_DESC;
        Messages.VDBMetadata nameEnum = Messages.VDBMetadata.valueOf(nameKey);
        node.get(new String[]{name, DESCRIPTION}).set(Messages.getString(nameEnum, new Object[0]));
        node.get(new String[]{name, REQUIRED}).set(required);
        return node;
    }

    public static class CacheStatisticsMetadataMapper
    implements MetadataMapper<CacheStatisticsMetadata> {
        private static final String HITRATIO = "hit-ratio";
        private static final String TOTAL_ENTRIES = "total-entries";
        private static final String REQUEST_COUNT = "request-count";
        public static CacheStatisticsMetadataMapper INSTANCE = new CacheStatisticsMetadataMapper();

        @Override
        public CacheStatisticsMetadata unwrap(ITeiidServerVersion teiidVersion, ModelNode node) {
            if (node == null) {
                return null;
            }
            CacheStatisticsMetadata cache = new CacheStatisticsMetadata();
            cache.setTotalEntries(node.get(TOTAL_ENTRIES).asInt());
            cache.setHitRatio(node.get(HITRATIO).asDouble());
            cache.setRequestCount(node.get(REQUEST_COUNT).asInt());
            VDBMetadataMapper.unwrapDomain(cache, node);
            return cache;
        }

        @Override
        public ModelNode describe(ITeiidServerVersion teiidVersion, ModelNode node) {
            VDBMetadataMapper.addAttribute(node, TOTAL_ENTRIES, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, HITRATIO, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, REQUEST_COUNT, ModelType.STRING, true);
            return node;
        }

        public AttributeDefinition[] getAttributeDefinitions() {
            return new AttributeDefinition[]{new SimpleAttributeDefinition(TOTAL_ENTRIES, ModelType.STRING, false), new SimpleAttributeDefinition(HITRATIO, ModelType.STRING, false), new SimpleAttributeDefinition(REQUEST_COUNT, ModelType.STRING, false)};
        }
    }

    public static class DataPolicyMetadataMapper
    implements MetadataMapper<DataPolicyMetadata> {
        private static final String POLICY_NAME = "policy-name";
        private static final String DATA_PERMISSIONS = "data-permissions";
        private static final String MAPPED_ROLE_NAMES = "mapped-role-names";
        private static final String ALLOW_CREATE_TEMP_TABLES = "allow-create-temp-tables";
        private static final String ANY_AUTHENTICATED = "any-authenticated";
        private static final String POLICY_DESCRIPTION = "policy-description";
        public static DataPolicyMetadataMapper INSTANCE = new DataPolicyMetadataMapper();

        @Override
        public DataPolicyMetadata unwrap(ITeiidServerVersion teiidVersion, ModelNode node) {
            if (node == null) {
                return null;
            }
            DataPolicyMetadata policy = new DataPolicyMetadata();
            if (node.has(POLICY_NAME)) {
                policy.setName(node.get(POLICY_NAME).asString());
            }
            if (node.has(POLICY_DESCRIPTION)) {
                policy.setDescription(node.get(POLICY_DESCRIPTION).asString());
            }
            if (node.has(ALLOW_CREATE_TEMP_TABLES)) {
                policy.setAllowCreateTemporaryTables(node.get(ALLOW_CREATE_TEMP_TABLES).asBoolean());
            }
            if (node.has(ANY_AUTHENTICATED)) {
                policy.setAnyAuthenticated(node.get(ANY_AUTHENTICATED).asBoolean());
            }
            if (node.get(DATA_PERMISSIONS).isDefined()) {
                List permissionNodes = node.get(DATA_PERMISSIONS).asList();
                for (ModelNode permissionNode : permissionNodes) {
                    DataPolicyMetadata.PermissionMetaData permission = PermissionMetaDataMapper.INSTANCE.unwrap(teiidVersion, permissionNode);
                    if (permission == null) continue;
                    policy.addPermission(permission);
                }
            }
            if (node.get(MAPPED_ROLE_NAMES).isDefined()) {
                List roleNameNodes = node.get(MAPPED_ROLE_NAMES).asList();
                for (ModelNode roleNameNode : roleNameNodes) {
                    policy.addMappedRoleName(roleNameNode.asString());
                }
            }
            return policy;
        }

        @Override
        public ModelNode describe(ITeiidServerVersion teiidVersion, ModelNode node) {
            VDBMetadataMapper.addAttribute(node, POLICY_NAME, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, POLICY_DESCRIPTION, ModelType.STRING, false);
            VDBMetadataMapper.addAttribute(node, ALLOW_CREATE_TEMP_TABLES, ModelType.BOOLEAN, false);
            VDBMetadataMapper.addAttribute(node, ANY_AUTHENTICATED, ModelType.BOOLEAN, false);
            ModelNode permissions = node.get(DATA_PERMISSIONS);
            permissions.get(VDBMetadataMapper.TYPE).set(ModelType.LIST);
            permissions.get(VDBMetadataMapper.DESCRIPTION).set(Messages.getString(Messages.VDBMetadata.data_permissions_describe, new Object[0]));
            PermissionMetaDataMapper.INSTANCE.describe(teiidVersion, permissions.get(VDBMetadataMapper.VALUE_TYPE));
            ModelNode roleNames = node.get(MAPPED_ROLE_NAMES);
            roleNames.get(VDBMetadataMapper.TYPE).set(ModelType.LIST);
            roleNames.get(VDBMetadataMapper.DESCRIPTION).set(Messages.getString(Messages.VDBMetadata.mapped_role_names_describe, new Object[0]));
            roleNames.get(VDBMetadataMapper.VALUE_TYPE).set(ModelType.STRING);
            return node;
        }

        public ObjectTypeAttributeDefinition getAttributeDefinition() {
            ObjectListAttributeDefinition dataPermisstions = ObjectListAttributeDefinition.Builder.of((String)DATA_PERMISSIONS, (ObjectTypeAttributeDefinition)PermissionMetaDataMapper.INSTANCE.getAttributeDefinition()).build();
            StringListAttributeDefinition roleNames = new StringListAttributeDefinition.Builder(MAPPED_ROLE_NAMES).build();
            return ObjectTypeAttributeDefinition.Builder.of((String)"DataPolicyMetadataMapper", (AttributeDefinition[])new AttributeDefinition[]{new SimpleAttributeDefinition(POLICY_NAME, ModelType.STRING, true), new SimpleAttributeDefinition(POLICY_DESCRIPTION, ModelType.STRING, true), new SimpleAttributeDefinition(ALLOW_CREATE_TEMP_TABLES, ModelType.BOOLEAN, true), new SimpleAttributeDefinition(ANY_AUTHENTICATED, ModelType.BOOLEAN, true), dataPermisstions, roleNames}).build();
        }
    }

    public static class EngineStatisticsMetadataMapper
    implements MetadataMapper<EngineStatisticsMetadata> {
        private static final String SESSION_COUNT = "session-count";
        private static final String TOTAL_MEMORY_USED_IN_KB = "total-memory-inuse-kb";
        private static final String MEMORY_IN_USE_BY_ACTIVE_PLANS = "total-memory-inuse-active-plans-kb";
        private static final String DISK_WRITE_COUNT = "buffermgr-disk-write-count";
        private static final String DISK_READ_COUNT = "buffermgr-disk-read-count";
        private static final String CACHE_WRITE_COUNT = "buffermgr-cache-write-count";
        private static final String CACHE_READ_COUNT = "buffermgr-cache-read-count";
        private static final String DISK_SPACE_USED = "buffermgr-diskspace-used-mb";
        private static final String ACTIVE_PLAN_COUNT = "active-plans-count";
        private static final String WAITING_PLAN_COUNT = "waiting-plans-count";
        private static final String MAX_WAIT_PLAN_COUNT = "max-waitplan-watermark";
        public static EngineStatisticsMetadataMapper INSTANCE = new EngineStatisticsMetadataMapper();

        @Override
        public EngineStatisticsMetadata unwrap(ITeiidServerVersion teiidVersion, ModelNode node) {
            if (node == null) {
                return null;
            }
            EngineStatisticsMetadata stats = new EngineStatisticsMetadata();
            stats.setSessionCount(node.get(SESSION_COUNT).asInt());
            stats.setTotalMemoryUsedInKB(node.get(TOTAL_MEMORY_USED_IN_KB).asLong());
            stats.setMemoryUsedByActivePlansInKB(node.get(MEMORY_IN_USE_BY_ACTIVE_PLANS).asLong());
            stats.setDiskWriteCount(node.get(DISK_WRITE_COUNT).asLong());
            stats.setDiskReadCount(node.get(DISK_READ_COUNT).asLong());
            stats.setCacheReadCount(node.get(CACHE_READ_COUNT).asLong());
            stats.setCacheWriteCount(node.get(CACHE_WRITE_COUNT).asLong());
            stats.setDiskSpaceUsedInMB(node.get(DISK_SPACE_USED).asLong());
            stats.setActivePlanCount(node.get(ACTIVE_PLAN_COUNT).asInt());
            stats.setWaitPlanCount(node.get(WAITING_PLAN_COUNT).asInt());
            stats.setMaxWaitPlanWaterMark(node.get(MAX_WAIT_PLAN_COUNT).asInt());
            VDBMetadataMapper.unwrapDomain(stats, node);
            return stats;
        }

        @Override
        public ModelNode describe(ITeiidServerVersion teiidVersion, ModelNode node) {
            VDBMetadataMapper.addAttribute(node, SESSION_COUNT, ModelType.INT, true);
            VDBMetadataMapper.addAttribute(node, TOTAL_MEMORY_USED_IN_KB, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, MEMORY_IN_USE_BY_ACTIVE_PLANS, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, DISK_WRITE_COUNT, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, DISK_READ_COUNT, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, CACHE_READ_COUNT, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, CACHE_WRITE_COUNT, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, DISK_SPACE_USED, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, ACTIVE_PLAN_COUNT, ModelType.INT, true);
            VDBMetadataMapper.addAttribute(node, WAITING_PLAN_COUNT, ModelType.INT, true);
            VDBMetadataMapper.addAttribute(node, MAX_WAIT_PLAN_COUNT, ModelType.INT, true);
            return node;
        }

        public AttributeDefinition[] getAttributeDefinitions() {
            return new AttributeDefinition[]{new SimpleAttributeDefinition(SESSION_COUNT, ModelType.INT, false), new SimpleAttributeDefinition(TOTAL_MEMORY_USED_IN_KB, ModelType.LONG, false), new SimpleAttributeDefinition(MEMORY_IN_USE_BY_ACTIVE_PLANS, ModelType.LONG, false), new SimpleAttributeDefinition(DISK_WRITE_COUNT, ModelType.LONG, false), new SimpleAttributeDefinition(DISK_READ_COUNT, ModelType.LONG, false), new SimpleAttributeDefinition(CACHE_READ_COUNT, ModelType.LONG, false), new SimpleAttributeDefinition(CACHE_WRITE_COUNT, ModelType.LONG, false), new SimpleAttributeDefinition(DISK_SPACE_USED, ModelType.LONG, false), new SimpleAttributeDefinition(ACTIVE_PLAN_COUNT, ModelType.INT, false), new SimpleAttributeDefinition(WAITING_PLAN_COUNT, ModelType.INT, false), new SimpleAttributeDefinition(MAX_WAIT_PLAN_COUNT, ModelType.INT, false)};
        }
    }

    public static class EntryMapper
    implements MetadataMapper<EntryMetaData> {
        private static final String PATH = "path";
        public static EntryMapper INSTANCE = new EntryMapper();

        @Override
        public EntryMetaData unwrap(ITeiidServerVersion teiidVersion, ModelNode node) {
            if (node == null) {
                return null;
            }
            EntryMetaData entry = new EntryMetaData();
            if (node.has(PATH)) {
                entry.setPath(node.get(PATH).asString());
            }
            if (node.has(VDBMetadataMapper.DESCRIPTION)) {
                entry.setDescription(node.get(VDBMetadataMapper.DESCRIPTION).asString());
            }
            if (node.get(VDBMetadataMapper.PROPERTIES).isDefined()) {
                List propNodes = node.get(VDBMetadataMapper.PROPERTIES).asList();
                for (ModelNode propNode : propNodes) {
                    String[] prop = PropertyMetaDataMapper.INSTANCE.unwrap(teiidVersion, propNode);
                    if (prop == null) continue;
                    entry.addProperty(prop[0], prop[1]);
                }
            }
            return entry;
        }

        @Override
        public ModelNode describe(ITeiidServerVersion teiidVersion, ModelNode node) {
            VDBMetadataMapper.addAttribute(node, PATH, ModelType.STRING, true);
            ModelNode props = node.get(VDBMetadataMapper.PROPERTIES);
            props.get(VDBMetadataMapper.TYPE).set(ModelType.LIST);
            props.get(VDBMetadataMapper.DESCRIPTION).set(Messages.getString(Messages.VDBMetadata.properties_describe, new Object[0]));
            PropertyMetaDataMapper.INSTANCE.describe(teiidVersion, props.get(VDBMetadataMapper.VALUE_TYPE));
            return node;
        }

        public ObjectTypeAttributeDefinition getAttributeDefinition() {
            ObjectListAttributeDefinition properties = ObjectListAttributeDefinition.Builder.of((String)VDBMetadataMapper.PROPERTIES, (ObjectTypeAttributeDefinition)PropertyMetaDataMapper.INSTANCE.getAttributeDefinition()).build();
            return ObjectTypeAttributeDefinition.Builder.of((String)"EntryMapper", (AttributeDefinition[])new AttributeDefinition[]{new SimpleAttributeDefinition(PATH, ModelType.STRING, false), properties}).build();
        }
    }

    public static class ModelMetadataMapper
    implements MetadataMapper<ModelMetaData> {
        private static final String MODEL_NAME = "model-name";
        private static final String DESCRIPTION = "description";
        private static final String VISIBLE = "visible";
        private static final String MODEL_TYPE = "model-type";
        private static final String MODELPATH = "model-path";
        private static final String PROPERTIES = "properties";
        private static final String SOURCE_MAPPINGS = "source-mappings";
        private static final String VALIDITY_ERRORS = "validity-errors";
        private static final String METADATAS = "metadatas";
        private static final String METADATA = "metadata";
        private static final String METADATA_TYPE = "metadata-type";
        private static final String METADATA_STATUS = "metadata-status";
        public static ModelMetadataMapper INSTANCE = new ModelMetadataMapper();

        @Override
        public ModelMetaData unwrap(ITeiidServerVersion teiidVersion, ModelNode node) {
            if (node == null) {
                return null;
            }
            ModelMetaData model = new ModelMetaData();
            if (node.has(MODEL_NAME)) {
                model.setName(node.get(MODEL_NAME).asString());
            }
            if (node.has("description")) {
                model.setDescription(node.get("description").asString());
            }
            if (node.has(VISIBLE)) {
                model.setVisible(node.get(VISIBLE).asBoolean());
            }
            if (node.has(MODEL_TYPE)) {
                model.setModelType(node.get(MODEL_TYPE).asString());
            }
            if (node.has(MODELPATH)) {
                model.setPath(node.get(MODELPATH).asString());
            }
            if (node.get("properties").isDefined()) {
                List propNodes = node.get("properties").asList();
                for (ModelNode propNode : propNodes) {
                    String[] prop = PropertyMetaDataMapper.INSTANCE.unwrap(teiidVersion, propNode);
                    if (prop == null) continue;
                    model.addProperty(prop[0], prop[1]);
                }
            }
            if (node.get(SOURCE_MAPPINGS).isDefined()) {
                List sourceMappingNodes = node.get(SOURCE_MAPPINGS).asList();
                for (ModelNode sourceMapping : sourceMappingNodes) {
                    SourceMappingMetadata source = SourceMappingMetadataMapper.INSTANCE.unwrap(teiidVersion, sourceMapping);
                    if (source == null) continue;
                    model.addSourceMapping(source);
                }
            }
            if (node.get(VALIDITY_ERRORS).isDefined()) {
                List errorNodes = node.get(VALIDITY_ERRORS).asList();
                for (ModelNode errorNode : errorNodes) {
                    ModelMetaData.Message error = ValidationErrorMapper.INSTANCE.unwrap(teiidVersion, errorNode);
                    if (error == null) continue;
                    model.addMessage(error);
                }
            }
            if (teiidVersion.isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_11)) {
                if (node.get(METADATAS).isDefined()) {
                    List metadataNodes = node.get(METADATAS).asList();
                    for (ModelNode modelNode : metadataNodes) {
                        String text = null;
                        String type = null;
                        if (modelNode.get(METADATA).isDefined()) {
                            text = modelNode.get(METADATA).asString();
                        }
                        if (modelNode.get(METADATA_TYPE).isDefined()) {
                            type = modelNode.get(METADATA_TYPE).asString();
                        }
                        model.addSourceMetadata(type, text);
                    }
                }
            } else {
                if (node.get(METADATA).isDefined()) {
                    model.setSchemaText(node.get(METADATA).asString());
                }
                if (node.get(METADATA_TYPE).isDefined()) {
                    model.setSchemaSourceType(node.get(METADATA_TYPE).asString());
                }
            }
            if (node.get(METADATA_STATUS).isDefined()) {
                model.setMetadataStatus(node.get(METADATA_STATUS).asString());
            }
            return model;
        }

        @Override
        public ModelNode describe(ITeiidServerVersion teiidVersion, ModelNode node) {
            ModelNode modelTypes = new ModelNode();
            modelTypes.add(Model.Type.PHYSICAL.toString());
            modelTypes.add(Model.Type.VIRTUAL.toString());
            modelTypes.add(Model.Type.FUNCTION.toString());
            modelTypes.add(Model.Type.OTHER.toString());
            VDBMetadataMapper.addAttribute(node, MODEL_NAME, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, "description", ModelType.STRING, false);
            VDBMetadataMapper.addAttribute(node, VISIBLE, ModelType.BOOLEAN, false);
            VDBMetadataMapper.addAttribute(node, MODEL_TYPE, ModelType.STRING, true);
            node.get(MODEL_TYPE).get(VDBMetadataMapper.ALLOWED).set(modelTypes);
            VDBMetadataMapper.addAttribute(node, MODELPATH, ModelType.STRING, false);
            ModelNode props = node.get("properties");
            props.get(VDBMetadataMapper.TYPE).set(ModelType.LIST);
            props.get("description").set(Messages.getString(Messages.VDBMetadata.properties_describe, new Object[0]));
            PropertyMetaDataMapper.INSTANCE.describe(teiidVersion, props.get(VDBMetadataMapper.VALUE_TYPE));
            ModelNode source = node.get(SOURCE_MAPPINGS);
            source.get(VDBMetadataMapper.TYPE).set(ModelType.LIST);
            source.get("description").set(Messages.getString(Messages.VDBMetadata.source_mappings_describe, new Object[0]));
            SourceMappingMetadataMapper.INSTANCE.describe(teiidVersion, source.get(VDBMetadataMapper.VALUE_TYPE));
            ModelNode errors = node.get(VALIDITY_ERRORS);
            errors.get(VDBMetadataMapper.TYPE).set(ModelType.LIST);
            errors.get("description").set(Messages.getString(Messages.VDBMetadata.validity_errors_describe, new Object[0]));
            ValidationErrorMapper.INSTANCE.describe(teiidVersion, errors.get(VDBMetadataMapper.VALUE_TYPE));
            ModelNode status = new ModelNode();
            status.add(Model.MetadataStatus.LOADING.name());
            status.add(Model.MetadataStatus.LOADED.name());
            status.add(Model.MetadataStatus.FAILED.name());
            status.add(Model.MetadataStatus.RETRYING.name());
            VDBMetadataMapper.addAttribute(node, METADATA_STATUS, ModelType.STRING, true);
            node.get(METADATA_STATUS).get(VDBMetadataMapper.ALLOWED).set(status);
            return node;
        }

        public ObjectTypeAttributeDefinition getAttributeDefinition() {
            ObjectListAttributeDefinition properties = ObjectListAttributeDefinition.Builder.of((String)"properties", (ObjectTypeAttributeDefinition)PropertyMetaDataMapper.INSTANCE.getAttributeDefinition()).build();
            ObjectListAttributeDefinition sourceMappings = ObjectListAttributeDefinition.Builder.of((String)SOURCE_MAPPINGS, (ObjectTypeAttributeDefinition)SourceMappingMetadataMapper.INSTANCE.getAttributeDefinition()).build();
            ObjectListAttributeDefinition errors = ObjectListAttributeDefinition.Builder.of((String)VALIDITY_ERRORS, (ObjectTypeAttributeDefinition)ValidationErrorMapper.INSTANCE.getAttributeDefinition()).build();
            return ObjectTypeAttributeDefinition.Builder.of((String)"ModelMetadataMapper", (AttributeDefinition[])new AttributeDefinition[]{new SimpleAttributeDefinition(MODEL_NAME, ModelType.STRING, false), new SimpleAttributeDefinition("description", ModelType.INT, true), new SimpleAttributeDefinition(VISIBLE, ModelType.INT, true), new SimpleAttributeDefinition(MODEL_TYPE, ModelType.BOOLEAN, false), new SimpleAttributeDefinition(MODELPATH, ModelType.BOOLEAN, true), new SimpleAttributeDefinition(METADATA_STATUS, ModelType.STRING, true), ObjectTypeAttributeDefinition.Builder.of((String)"properties", (AttributeDefinition[])new AttributeDefinition[]{properties}).build(), ObjectTypeAttributeDefinition.Builder.of((String)SOURCE_MAPPINGS, (AttributeDefinition[])new AttributeDefinition[]{sourceMappings}).build(), ObjectTypeAttributeDefinition.Builder.of((String)VALIDITY_ERRORS, (AttributeDefinition[])new AttributeDefinition[]{errors}).build()}).build();
        }
    }

    public static class PermissionMetaDataMapper
    implements MetadataMapper<DataPolicyMetadata.PermissionMetaData> {
        private static final String RESOURCE_NAME = "resource-name";
        private static final String ALLOW_CREATE = "allow-create";
        private static final String ALLOW_DELETE = "allow-delete";
        private static final String ALLOW_UPADTE = "allow-update";
        private static final String ALLOW_READ = "allow-read";
        private static final String ALLOW_EXECUTE = "allow-execute";
        private static final String ALLOW_ALTER = "allow-alter";
        private static final String ALLOW_LANGUAGE = "allow-language";
        private static final String CONDITION = "condition";
        private static final String MASK = "mask";
        private static final String ORDER = "order";
        private static final String CONSTRAINT = "constraint";
        public static PermissionMetaDataMapper INSTANCE = new PermissionMetaDataMapper();

        @Override
        public DataPolicyMetadata.PermissionMetaData unwrap(ITeiidServerVersion teiidVersion, ModelNode node) {
            if (node == null) {
                return null;
            }
            DataPolicyMetadata.PermissionMetaData permission = new DataPolicyMetadata.PermissionMetaData();
            if (node.get(RESOURCE_NAME) != null) {
                permission.setResourceName(node.get(RESOURCE_NAME).asString());
            }
            if (node.has(ALLOW_LANGUAGE)) {
                permission.setAllowLanguage(node.get(ALLOW_LANGUAGE).asBoolean());
                return permission;
            }
            if (node.has(ALLOW_CREATE)) {
                permission.setAllowCreate(node.get(ALLOW_CREATE).asBoolean());
            }
            if (node.has(ALLOW_DELETE)) {
                permission.setAllowDelete(node.get(ALLOW_DELETE).asBoolean());
            }
            if (node.has(ALLOW_UPADTE)) {
                permission.setAllowUpdate(node.get(ALLOW_UPADTE).asBoolean());
            }
            if (node.has(ALLOW_READ)) {
                permission.setAllowRead(node.get(ALLOW_READ).asBoolean());
            }
            if (node.has(ALLOW_EXECUTE)) {
                permission.setAllowExecute(node.get(ALLOW_EXECUTE).asBoolean());
            }
            if (node.has(ALLOW_ALTER)) {
                permission.setAllowAlter(node.get(ALLOW_ALTER).asBoolean());
            }
            if (node.has(CONDITION)) {
                permission.setCondition(node.get(CONDITION).asString());
            }
            if (node.has(MASK)) {
                permission.setMask(node.get(MASK).asString());
            }
            if (node.has(ORDER)) {
                permission.setOrder(node.get(ORDER).asInt());
            }
            if (node.has(CONSTRAINT)) {
                permission.setConstraint(node.get(CONSTRAINT).asBoolean());
            }
            return permission;
        }

        @Override
        public ModelNode describe(ITeiidServerVersion teiidVersion, ModelNode node) {
            VDBMetadataMapper.addAttribute(node, RESOURCE_NAME, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, ALLOW_CREATE, ModelType.BOOLEAN, false);
            VDBMetadataMapper.addAttribute(node, ALLOW_DELETE, ModelType.BOOLEAN, false);
            VDBMetadataMapper.addAttribute(node, ALLOW_UPADTE, ModelType.BOOLEAN, false);
            VDBMetadataMapper.addAttribute(node, ALLOW_READ, ModelType.BOOLEAN, false);
            VDBMetadataMapper.addAttribute(node, ALLOW_EXECUTE, ModelType.BOOLEAN, false);
            VDBMetadataMapper.addAttribute(node, ALLOW_ALTER, ModelType.BOOLEAN, false);
            VDBMetadataMapper.addAttribute(node, ALLOW_LANGUAGE, ModelType.BOOLEAN, false);
            return node;
        }

        public ObjectTypeAttributeDefinition getAttributeDefinition() {
            return ObjectTypeAttributeDefinition.Builder.of((String)"PermissionMetaData", (AttributeDefinition[])new AttributeDefinition[]{new SimpleAttributeDefinition(RESOURCE_NAME, ModelType.STRING, false), new SimpleAttributeDefinition(ALLOW_CREATE, ModelType.BOOLEAN, true), new SimpleAttributeDefinition(ALLOW_DELETE, ModelType.BOOLEAN, true), new SimpleAttributeDefinition(ALLOW_UPADTE, ModelType.BOOLEAN, true), new SimpleAttributeDefinition(ALLOW_READ, ModelType.BOOLEAN, true), new SimpleAttributeDefinition(ALLOW_EXECUTE, ModelType.BOOLEAN, true), new SimpleAttributeDefinition(ALLOW_ALTER, ModelType.BOOLEAN, true), new SimpleAttributeDefinition(ALLOW_LANGUAGE, ModelType.BOOLEAN, true)}).build();
        }
    }

    public static class PropertyMetaDataMapper {
        private static final String PROPERTY_NAME = "property-name";
        private static final String PROPERTY_VALUE = "property-value";
        public static PropertyMetaDataMapper INSTANCE = new PropertyMetaDataMapper();

        public ModelNode wrap(String key, String value, ModelNode node) {
            node.get(PROPERTY_NAME).set(key);
            node.get(PROPERTY_VALUE).set(value);
            return node;
        }

        public String[] unwrap(ITeiidServerVersion teiidVersion, ModelNode node) {
            if (node == null) {
                return null;
            }
            String key = null;
            String value = null;
            if (node.has(PROPERTY_NAME)) {
                key = node.get(PROPERTY_NAME).asString();
            }
            if (node.has(PROPERTY_VALUE)) {
                value = node.get(PROPERTY_VALUE).asString();
            }
            return new String[]{key, value};
        }

        public ModelNode describe(ITeiidServerVersion teiidVersion, ModelNode node) {
            VDBMetadataMapper.addAttribute(node, PROPERTY_NAME, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, PROPERTY_VALUE, ModelType.STRING, true);
            return node;
        }

        public ObjectTypeAttributeDefinition getAttributeDefinition() {
            return ObjectTypeAttributeDefinition.Builder.of((String)"PropertyMetaDataMapper", (AttributeDefinition[])new AttributeDefinition[]{new SimpleAttributeDefinition(PROPERTY_NAME, ModelType.STRING, false), new SimpleAttributeDefinition(PROPERTY_VALUE, ModelType.STRING, false)}).build();
        }
    }

    public static class RequestMetadataMapper
    implements MetadataMapper<RequestMetadata> {
        private static final String TRANSACTION_ID = "transaction-id";
        private static final String NODE_ID = "node-id";
        private static final String SOURCE_REQUEST = "source-request";
        private static final String COMMAND = "command";
        private static final String START_TIME = "start-time";
        private static final String SESSION_ID = "session-id";
        private static final String EXECUTION_ID = "execution-id";
        private static final String STATE = "processing-state";
        private static final String THREAD_STATE = "thread-state";
        public static RequestMetadataMapper INSTANCE = new RequestMetadataMapper();

        @Override
        public RequestMetadata unwrap(ITeiidServerVersion teiidVersion, ModelNode node) {
            if (node == null) {
                return null;
            }
            RequestMetadata request = new RequestMetadata();
            request.setExecutionId(node.get(EXECUTION_ID).asLong());
            request.setSessionId(node.get(SESSION_ID).asString());
            request.setStartTime(node.get(START_TIME).asLong());
            request.setCommand(node.get(COMMAND).asString());
            request.setSourceRequest(node.get(SOURCE_REQUEST).asBoolean());
            if (node.has(NODE_ID)) {
                request.setNodeId(node.get(NODE_ID).asInt());
            }
            if (node.has(TRANSACTION_ID)) {
                request.setTransactionId(node.get(TRANSACTION_ID).asString());
            }
            request.setState(Request.ProcessingState.valueOf(node.get(STATE).asString()));
            request.setThreadState(Request.ThreadState.valueOf(node.get(THREAD_STATE).asString()));
            VDBMetadataMapper.unwrapDomain(request, node);
            return request;
        }

        @Override
        public ModelNode describe(ITeiidServerVersion teiidVersion, ModelNode node) {
            VDBMetadataMapper.addAttribute(node, EXECUTION_ID, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, SESSION_ID, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, START_TIME, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, COMMAND, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, SOURCE_REQUEST, ModelType.BOOLEAN, true);
            VDBMetadataMapper.addAttribute(node, NODE_ID, ModelType.INT, false);
            VDBMetadataMapper.addAttribute(node, TRANSACTION_ID, ModelType.STRING, false);
            VDBMetadataMapper.addAttribute(node, STATE, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, THREAD_STATE, ModelType.STRING, true);
            return node;
        }

        public AttributeDefinition[] getAttributeDefinitions() {
            return new AttributeDefinition[]{new SimpleAttributeDefinition(EXECUTION_ID, ModelType.LONG, false), new SimpleAttributeDefinition(SESSION_ID, ModelType.STRING, false), new SimpleAttributeDefinition(START_TIME, ModelType.LONG, false), new SimpleAttributeDefinition(COMMAND, ModelType.STRING, false), new SimpleAttributeDefinition(SOURCE_REQUEST, ModelType.BOOLEAN, false), new SimpleAttributeDefinition(NODE_ID, ModelType.INT, true), new SimpleAttributeDefinition(TRANSACTION_ID, ModelType.STRING, true), new SimpleAttributeDefinition(STATE, ModelType.STRING, false), new SimpleAttributeDefinition(THREAD_STATE, ModelType.STRING, false)};
        }
    }

    public static class SessionMetadataMapper
    implements MetadataMapper<SessionMetadata> {
        private static final String SECURITY_DOMAIN = "security-domain";
        private static final String VDB_VERSION = "vdb-version";
        private static final String VDB_NAME = "vdb-name";
        private static final String USER_NAME = "user-name";
        private static final String SESSION_ID = "session-id";
        private static final String LAST_PING_TIME = "last-ping-time";
        private static final String IP_ADDRESS = "ip-address";
        private static final String CLIENT_HOST_NAME = "client-host-address";
        private static final String CREATED_TIME = "created-time";
        private static final String APPLICATION_NAME = "application-name";
        private static final String CLIENT_HARDWARE_ADRESS = "client-hardware-address";
        public static SessionMetadataMapper INSTANCE = new SessionMetadataMapper();

        @Override
        public SessionMetadata unwrap(ITeiidServerVersion teiidVersion, ModelNode node) {
            if (node == null) {
                return null;
            }
            SessionMetadata session = new SessionMetadata();
            if (node.has(APPLICATION_NAME)) {
                session.setApplicationName(node.get(APPLICATION_NAME).asString());
            }
            session.setCreatedTime(node.get(CREATED_TIME).asLong());
            if (node.has(CLIENT_HOST_NAME)) {
                session.setClientHostName(node.get(CLIENT_HOST_NAME).asString());
            }
            if (node.has(IP_ADDRESS)) {
                session.setIPAddress(node.get(IP_ADDRESS).asString());
            }
            session.setLastPingTime(node.get(LAST_PING_TIME).asLong());
            session.setSessionId(node.get(SESSION_ID).asString());
            session.setUserName(node.get(USER_NAME).asString());
            session.setVDBName(node.get("vdb-name").asString());
            session.setVDBVersion(node.get("vdb-version").asInt());
            if (node.has(SECURITY_DOMAIN)) {
                session.setSecurityDomain(node.get(SECURITY_DOMAIN).asString());
            }
            if (node.has(CLIENT_HARDWARE_ADRESS)) {
                session.setClientHardwareAddress(node.get(CLIENT_HARDWARE_ADRESS).asString());
            }
            VDBMetadataMapper.unwrapDomain(session, node);
            return session;
        }

        @Override
        public ModelNode describe(ITeiidServerVersion teiidVersion, ModelNode node) {
            VDBMetadataMapper.addAttribute(node, APPLICATION_NAME, ModelType.STRING, false);
            VDBMetadataMapper.addAttribute(node, CREATED_TIME, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, CLIENT_HOST_NAME, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, IP_ADDRESS, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, LAST_PING_TIME, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, SESSION_ID, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, USER_NAME, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, "vdb-name", ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, "vdb-version", ModelType.INT, true);
            VDBMetadataMapper.addAttribute(node, SECURITY_DOMAIN, ModelType.STRING, false);
            return node;
        }

        public AttributeDefinition[] getAttributeDefinitions() {
            return new AttributeDefinition[]{new SimpleAttributeDefinition(APPLICATION_NAME, ModelType.STRING, true), new SimpleAttributeDefinition(CREATED_TIME, ModelType.LONG, false), new SimpleAttributeDefinition(CLIENT_HOST_NAME, ModelType.LONG, false), new SimpleAttributeDefinition(IP_ADDRESS, ModelType.STRING, false), new SimpleAttributeDefinition(LAST_PING_TIME, ModelType.LONG, false), new SimpleAttributeDefinition(SESSION_ID, ModelType.STRING, false), new SimpleAttributeDefinition(USER_NAME, ModelType.STRING, false), new SimpleAttributeDefinition("vdb-name", ModelType.STRING, false), new SimpleAttributeDefinition("vdb-version", ModelType.INT, false), new SimpleAttributeDefinition(SECURITY_DOMAIN, ModelType.STRING, true)};
        }
    }

    public static class SourceMappingMetadataMapper
    implements MetadataMapper<SourceMappingMetadata> {
        private static final String SOURCE_NAME = "source-name";
        private static final String JNDI_NAME = "jndi-name";
        private static final String TRANSLATOR_NAME = "translator-name";
        public static SourceMappingMetadataMapper INSTANCE = new SourceMappingMetadataMapper();

        @Override
        public SourceMappingMetadata unwrap(ITeiidServerVersion teiidVersion, ModelNode node) {
            if (node == null) {
                return null;
            }
            SourceMappingMetadata source = new SourceMappingMetadata();
            if (node.has(SOURCE_NAME)) {
                source.setName(node.get(SOURCE_NAME).asString());
            }
            if (node.has(JNDI_NAME)) {
                source.setConnectionJndiName(node.get(JNDI_NAME).asString());
            }
            if (node.has(TRANSLATOR_NAME)) {
                source.setTranslatorName(node.get(TRANSLATOR_NAME).asString());
            }
            return source;
        }

        @Override
        public ModelNode describe(ITeiidServerVersion teiidVersion, ModelNode node) {
            VDBMetadataMapper.addAttribute(node, SOURCE_NAME, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, JNDI_NAME, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, TRANSLATOR_NAME, ModelType.STRING, true);
            return node;
        }

        public ObjectTypeAttributeDefinition getAttributeDefinition() {
            return ObjectTypeAttributeDefinition.Builder.of((String)"SourceMappingMetadataMapper", (AttributeDefinition[])new AttributeDefinition[]{new SimpleAttributeDefinition(SOURCE_NAME, ModelType.STRING, false), new SimpleAttributeDefinition(JNDI_NAME, ModelType.STRING, false), new SimpleAttributeDefinition(TRANSLATOR_NAME, ModelType.STRING, false)}).build();
        }
    }

    public static class TransactionMetadataMapper
    implements MetadataMapper<TransactionMetadata> {
        private static final String ID = "txn-id";
        private static final String SCOPE = "txn-scope";
        private static final String CREATED_TIME = "txn-created-time";
        private static final String ASSOCIATED_SESSION = "session-id";
        public static TransactionMetadataMapper INSTANCE = new TransactionMetadataMapper();

        @Override
        public TransactionMetadata unwrap(ITeiidServerVersion teiidVersion, ModelNode node) {
            if (node == null) {
                return null;
            }
            TransactionMetadata transaction = new TransactionMetadata();
            transaction.setAssociatedSession(node.get(ASSOCIATED_SESSION).asString());
            transaction.setCreatedTime(node.get(CREATED_TIME).asLong());
            transaction.setScope(node.get(SCOPE).asString());
            transaction.setId(node.get(ID).asString());
            VDBMetadataMapper.unwrapDomain(transaction, node);
            return transaction;
        }

        @Override
        public ModelNode describe(ITeiidServerVersion teiidVersion, ModelNode node) {
            VDBMetadataMapper.addAttribute(node, ASSOCIATED_SESSION, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, CREATED_TIME, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, SCOPE, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, ID, ModelType.STRING, true);
            return node;
        }

        public AttributeDefinition[] getAttributeDefinitions() {
            return new AttributeDefinition[]{new SimpleAttributeDefinition(ASSOCIATED_SESSION, ModelType.STRING, false), new SimpleAttributeDefinition(CREATED_TIME, ModelType.LONG, false), new SimpleAttributeDefinition(SCOPE, ModelType.LONG, false), new SimpleAttributeDefinition(ID, ModelType.STRING, false)};
        }
    }

    public static class VDBImportMapper
    implements MetadataMapper<VDBImportMetadata> {
        private static final String VDB_NAME = "import-vdb-name";
        private static final String VDB_VERSION = "import-vdb-version";
        private static final String IMPORT_POLICIES = "import-policies";
        public static VDBImportMapper INSTANCE = new VDBImportMapper();

        @Override
        public VDBImportMetadata unwrap(ITeiidServerVersion teiidVersion, ModelNode node) {
            if (node == null) {
                return null;
            }
            VDBImportMetadata vdbImport = new VDBImportMetadata();
            if (node.has(VDB_NAME)) {
                vdbImport.setName(node.get(VDB_NAME).asString());
            }
            if (node.has(VDB_VERSION)) {
                vdbImport.setVersion(node.get(VDB_VERSION).asInt());
            }
            if (node.has(IMPORT_POLICIES)) {
                vdbImport.setImportDataPolicies(node.get(IMPORT_POLICIES).asBoolean());
            }
            return vdbImport;
        }

        @Override
        public ModelNode describe(ITeiidServerVersion teiidVersion, ModelNode node) {
            VDBMetadataMapper.addAttribute(node, VDB_NAME, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, VDB_VERSION, ModelType.INT, true);
            VDBMetadataMapper.addAttribute(node, IMPORT_POLICIES, ModelType.BOOLEAN, false);
            return node;
        }

        public ObjectTypeAttributeDefinition getAttributeDefinition() {
            return ObjectTypeAttributeDefinition.Builder.of((String)"VDBImportMapper", (AttributeDefinition[])new AttributeDefinition[]{new SimpleAttributeDefinition(VDB_NAME, ModelType.STRING, false), new SimpleAttributeDefinition(VDB_VERSION, ModelType.INT, false), new SimpleAttributeDefinition(IMPORT_POLICIES, ModelType.BOOLEAN, true)}).build();
        }
    }

    public static class VDBTranslatorMetaDataMapper
    implements MetadataMapper<VDBTranslatorMetaData> {
        private static final String TRANSLATOR_NAME = "translator-name";
        private static final String BASETYPE = "base-type";
        private static final String TRANSLATOR_DESCRIPTION = "translator-description";
        private static final String PROPERTIES = "properties";
        private static final String MODULE_NAME = "module-name";
        public static VDBTranslatorMetaDataMapper INSTANCE = new VDBTranslatorMetaDataMapper();

        @Override
        public VDBTranslatorMetaData unwrap(ITeiidServerVersion teiidVersion, ModelNode node) {
            if (node == null) {
                return null;
            }
            VDBTranslatorMetaData translator = new VDBTranslatorMetaData();
            if (node.has(TRANSLATOR_NAME)) {
                translator.setName(node.get(TRANSLATOR_NAME).asString());
            }
            if (node.has(BASETYPE)) {
                translator.setType(node.get(BASETYPE).asString());
            }
            if (node.has(TRANSLATOR_DESCRIPTION)) {
                translator.setDescription(node.get(TRANSLATOR_DESCRIPTION).asString());
            }
            if (node.has(MODULE_NAME)) {
                translator.setModuleName(node.get(MODULE_NAME).asString());
            }
            if (node.get("properties").isDefined()) {
                List propNodes = node.get("properties").asList();
                for (ModelNode propNode : propNodes) {
                    String[] prop = PropertyMetaDataMapper.INSTANCE.unwrap(teiidVersion, propNode);
                    if (prop == null) continue;
                    translator.addProperty(prop[0], prop[1]);
                }
            }
            VDBMetadataMapper.unwrapDomain(translator, node);
            return translator;
        }

        @Override
        public ModelNode describe(ITeiidServerVersion teiidVersion, ModelNode node) {
            VDBMetadataMapper.addAttribute(node, TRANSLATOR_NAME, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, BASETYPE, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, TRANSLATOR_DESCRIPTION, ModelType.STRING, false);
            VDBMetadataMapper.addAttribute(node, MODULE_NAME, ModelType.STRING, false);
            ModelNode props = node.get("properties");
            props.get(VDBMetadataMapper.TYPE).set(ModelType.LIST);
            props.get(VDBMetadataMapper.DESCRIPTION).set(Messages.getString(Messages.VDBMetadata.properties_describe, new Object[0]));
            PropertyMetaDataMapper.INSTANCE.describe(teiidVersion, props.get(VDBMetadataMapper.VALUE_TYPE));
            return node;
        }

        public ObjectTypeAttributeDefinition getAttributeDefinition() {
            return ObjectTypeAttributeDefinition.Builder.of((String)"VDBTranslatorMetaDataMapper", (AttributeDefinition[])this.getAttributeDefinitions()).build();
        }

        public AttributeDefinition[] getAttributeDefinitions() {
            ObjectListAttributeDefinition properties = ObjectListAttributeDefinition.Builder.of((String)"properties", (ObjectTypeAttributeDefinition)PropertyMetaDataMapper.INSTANCE.getAttributeDefinition()).build();
            return new AttributeDefinition[]{new SimpleAttributeDefinition(TRANSLATOR_NAME, ModelType.STRING, false), new SimpleAttributeDefinition(BASETYPE, ModelType.STRING, false), new SimpleAttributeDefinition(TRANSLATOR_DESCRIPTION, ModelType.STRING, true), new SimpleAttributeDefinition(MODULE_NAME, ModelType.STRING, true), properties};
        }
    }

    public static class ValidationErrorMapper
    implements MetadataMapper<ModelMetaData.Message> {
        private static final String ERROR_PATH = "error-path";
        private static final String SEVERITY = "severity";
        private static final String MESSAGE = "message";
        public static ValidationErrorMapper INSTANCE = new ValidationErrorMapper();

        @Override
        public ModelMetaData.Message unwrap(ITeiidServerVersion teiidVersion, ModelNode node) {
            if (node == null) {
                return null;
            }
            ModelMetaData.Message error = new ModelMetaData.Message();
            if (node.has(ERROR_PATH)) {
                error.setPath(node.get(ERROR_PATH).asString());
            }
            if (node.has(SEVERITY)) {
                error.setSeverity(ModelMetaData.Message.Severity.valueOf(node.get(SEVERITY).asString()));
            }
            if (node.has(MESSAGE)) {
                error.setValue(node.get(MESSAGE).asString());
            }
            return error;
        }

        @Override
        public ModelNode describe(ITeiidServerVersion teiidVersion, ModelNode node) {
            VDBMetadataMapper.addAttribute(node, ERROR_PATH, ModelType.STRING, false);
            VDBMetadataMapper.addAttribute(node, SEVERITY, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, MESSAGE, ModelType.STRING, true);
            return node;
        }

        public ObjectTypeAttributeDefinition getAttributeDefinition() {
            return ObjectTypeAttributeDefinition.Builder.of((String)"ValidationErrorMapper", (AttributeDefinition[])new AttributeDefinition[]{new SimpleAttributeDefinition(ERROR_PATH, ModelType.STRING, true), new SimpleAttributeDefinition(SEVERITY, ModelType.STRING, false), new SimpleAttributeDefinition(MESSAGE, ModelType.STRING, false)}).build();
        }
    }

    public static class WorkerPoolStatisticsMetadataMapper
    implements MetadataMapper<WorkerPoolStatisticsMetadata> {
        private static final String MAX_THREADS = "max-threads";
        private static final String HIGHEST_QUEUED = "highest-queued";
        private static final String QUEUED = "queued";
        private static final String QUEUE_NAME = "queue-name";
        private static final String TOTAL_SUBMITTED = "total-submitted";
        private static final String TOTAL_COMPLETED = "total-completed";
        private static final String HIGHEST_ACTIVE_THREADS = "highest-active-threads";
        private static final String ACTIVE_THREADS = "active-threads";
        public static WorkerPoolStatisticsMetadataMapper INSTANCE = new WorkerPoolStatisticsMetadataMapper();

        @Override
        public WorkerPoolStatisticsMetadata unwrap(ITeiidServerVersion teiidVersion, ModelNode node) {
            if (node == null) {
                return null;
            }
            WorkerPoolStatisticsMetadata stats = new WorkerPoolStatisticsMetadata();
            stats.setActiveThreads(node.get(ACTIVE_THREADS).asInt());
            stats.setHighestActiveThreads(node.get(HIGHEST_ACTIVE_THREADS).asInt());
            stats.setTotalCompleted(node.get(TOTAL_COMPLETED).asLong());
            stats.setTotalSubmitted(node.get(TOTAL_SUBMITTED).asLong());
            stats.setQueueName(node.get(QUEUE_NAME).asString());
            stats.setQueued(node.get(QUEUED).asInt());
            stats.setHighestQueued(node.get(HIGHEST_QUEUED).asInt());
            stats.setMaxThreads(node.get(MAX_THREADS).asInt());
            VDBMetadataMapper.unwrapDomain(stats, node);
            return stats;
        }

        @Override
        public ModelNode describe(ITeiidServerVersion teiidVersion, ModelNode node) {
            VDBMetadataMapper.addAttribute(node, ACTIVE_THREADS, ModelType.INT, true);
            VDBMetadataMapper.addAttribute(node, HIGHEST_ACTIVE_THREADS, ModelType.INT, true);
            VDBMetadataMapper.addAttribute(node, TOTAL_COMPLETED, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, TOTAL_SUBMITTED, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, QUEUE_NAME, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, QUEUED, ModelType.INT, true);
            VDBMetadataMapper.addAttribute(node, HIGHEST_QUEUED, ModelType.INT, true);
            VDBMetadataMapper.addAttribute(node, MAX_THREADS, ModelType.INT, true);
            return node;
        }

        public AttributeDefinition[] getAttributeDefinitions() {
            return new AttributeDefinition[]{new SimpleAttributeDefinition(ACTIVE_THREADS, ModelType.INT, false), new SimpleAttributeDefinition(HIGHEST_ACTIVE_THREADS, ModelType.INT, false), new SimpleAttributeDefinition(TOTAL_COMPLETED, ModelType.LONG, false), new SimpleAttributeDefinition(TOTAL_SUBMITTED, ModelType.LONG, false), new SimpleAttributeDefinition(QUEUE_NAME, ModelType.STRING, false), new SimpleAttributeDefinition(QUEUED, ModelType.INT, false), new SimpleAttributeDefinition(HIGHEST_QUEUED, ModelType.INT, false), new SimpleAttributeDefinition(MAX_THREADS, ModelType.INT, false)};
        }
    }
}

