/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import org.teiid.client.batch.Batch0Serializer;
import org.teiid.client.batch.Batch1Serializer;
import org.teiid.client.batch.Batch2Serializer;
import org.teiid.client.batch.Batch3Serializer;
import org.teiid.client.batch.Batch4Serializer;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;

public abstract class BatchSerializer {
    protected final byte currentVersion;
    private final ITeiidServerVersion teiidVersion;
    protected ColumnSerializer defaultSerializer = new ColumnSerializer();

    protected BatchSerializer(ITeiidServerVersion teiidVersion, byte version) {
        this.teiidVersion = teiidVersion;
        this.currentVersion = version;
    }

    protected ITeiidServerVersion getTeiidVersion() {
        return this.teiidVersion;
    }

    protected byte getCurrentVersion() {
        return this.currentVersion;
    }

    protected DataTypeManagerService getDataTypeManager() {
        return DataTypeManagerService.getInstance(this.getTeiidVersion());
    }

    public static BatchSerializer getInstance(ITeiidServerVersion teiidVersion) {
        if (teiidVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_0)) {
            return new Batch0Serializer(teiidVersion);
        }
        if (teiidVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_2)) {
            return new Batch1Serializer(teiidVersion);
        }
        if (teiidVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_6)) {
            return new Batch2Serializer(teiidVersion);
        }
        if (teiidVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_10)) {
            return new Batch3Serializer(teiidVersion);
        }
        return new Batch4Serializer(teiidVersion);
    }

    protected void writeIsNullData(ObjectOutput out, int offset, Object[] batch) throws IOException {
        int currentByte = 0;
        int mask = 128;
        while (offset < batch.length) {
            if (batch[offset] == null) {
                currentByte |= mask;
            }
            ++offset;
            mask >>= 1;
        }
        out.write(currentByte);
    }

    protected void writeIsNullData(ObjectOutput out, int col, List<? extends List<?>> batch) throws IOException {
        int numBytes = batch.size() / 8;
        int row = 0;
        int currentByte = 0;
        int byteNum = 0;
        while (byteNum < numBytes) {
            int n = currentByte = batch.get(row).get(col) == null ? 128 : 0;
            if (batch.get(row + 1).get(col) == null) {
                currentByte |= 0x40;
            }
            if (batch.get(row + 2).get(col) == null) {
                currentByte |= 0x20;
            }
            if (batch.get(row + 3).get(col) == null) {
                currentByte |= 0x10;
            }
            if (batch.get(row + 4).get(col) == null) {
                currentByte |= 8;
            }
            if (batch.get(row + 5).get(col) == null) {
                currentByte |= 4;
            }
            if (batch.get(row + 6).get(col) == null) {
                currentByte |= 2;
            }
            if (batch.get(row + 7).get(col) == null) {
                currentByte |= 1;
            }
            out.write(currentByte);
            ++byteNum;
            row += 8;
        }
        if (batch.size() % 8 > 0) {
            currentByte = 0;
            int mask = 128;
            while (row < batch.size()) {
                if (batch.get(row).get(col) == null) {
                    currentByte |= mask;
                }
                ++row;
                mask >>= 1;
            }
            out.write(currentByte);
        }
    }

    protected void readIsNullData(ObjectInput in, byte[] isNullBytes) throws IOException {
        int i = 0;
        while (i < isNullBytes.length) {
            isNullBytes[i] = in.readByte();
            ++i;
        }
    }

    protected boolean isNullObject(byte[] isNull, int row) {
        return (isNull[row / 8] & 1 << 7 - row % 8) != 0;
    }

    protected boolean isNullObject(int row, byte b) {
        return (b & 1 << 7 - row % 8) != 0;
    }

    public abstract List<List<Object>> readBatch(ObjectInput var1, String[] var2) throws IOException, ClassNotFoundException;

    public abstract void writeBatch(ObjectOutput var1, String[] var2, List<? extends List<?>> var3) throws IOException;

    public abstract void writeBatch(ObjectOutput var1, String[] var2, List<? extends List<?>> var3, byte var4) throws IOException;

    public class ColumnSerializer {
        public void writeColumn(ObjectOutput out, int col, List<? extends List<?>> batch, Map<Object, Integer> cache, byte version) throws IOException {
            BatchSerializer.this.writeIsNullData(out, col, batch);
            Object obj = null;
            int i = 0;
            while (i < batch.size()) {
                obj = batch.get(i).get(col);
                if (obj != null) {
                    this.writeObject(out, obj, cache, version);
                }
                ++i;
            }
        }

        public void readColumn(ObjectInput in, int col, List<List<Object>> batch, byte[] isNull, List<Object> cache, byte version) throws IOException, ClassNotFoundException {
            BatchSerializer.this.readIsNullData(in, isNull);
            int i = 0;
            while (i < batch.size()) {
                if (!BatchSerializer.this.isNullObject(isNull, i)) {
                    batch.get(i).set(col, this.readObject(in, cache, version));
                }
                ++i;
            }
        }

        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            out.writeObject(obj);
        }

        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException, ClassNotFoundException {
            return in.readObject();
        }

        public boolean usesCache(byte version) {
            return false;
        }
    }
}

