/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client.batch;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.teiid.client.BatchSerializer;
import org.teiid.client.ResizingArrayList;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.XMLType;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.runtime.client.Messages;

public class Batch0Serializer
extends BatchSerializer {
    protected final Map<String, BatchSerializer.ColumnSerializer[]> serializers = new HashMap<String, BatchSerializer.ColumnSerializer[]>(128);
    protected final Map<String, BatchSerializer.ColumnSerializer> version1serializers = new HashMap<String, BatchSerializer.ColumnSerializer>(128);
    protected static final int MAX_UTF = 21845;
    int dateNormalizer = -1;

    protected Batch0Serializer(ITeiidServerVersion teiidVersion, byte version) {
        super(teiidVersion, version);
        this.initDateNormalizer();
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL.getId(), new BatchSerializer.ColumnSerializer[]{new BigDecimalColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.BIG_INTEGER.getId(), new BatchSerializer.ColumnSerializer[]{new BigIntegerColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.BOOLEAN.getId(), new BatchSerializer.ColumnSerializer[]{new BooleanColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.BYTE.getId(), new BatchSerializer.ColumnSerializer[]{new ByteColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.CHAR.getId(), new BatchSerializer.ColumnSerializer[]{new CharColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.DATE.getId(), new BatchSerializer.ColumnSerializer[]{new DateColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.DOUBLE.getId(), new BatchSerializer.ColumnSerializer[]{new DoubleColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.FLOAT.getId(), new BatchSerializer.ColumnSerializer[]{new FloatColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.INTEGER.getId(), new BatchSerializer.ColumnSerializer[]{new IntColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.LONG.getId(), new BatchSerializer.ColumnSerializer[]{new LongColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.SHORT.getId(), new BatchSerializer.ColumnSerializer[]{new ShortColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.TIME.getId(), new BatchSerializer.ColumnSerializer[]{new TimeColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.TIMESTAMP.getId(), new BatchSerializer.ColumnSerializer[]{new TimestampColumnSerializer()});
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.DATE.getId(), new DateColumnSerializer1());
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.TIME.getId(), new TimeColumnSerializer1());
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.STRING.getId(), new StringColumnSerializer1());
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.CLOB.getId(), new ClobColumnSerializer1());
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.BLOB.getId(), new BlobColumnSerializer1());
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.XML.getId(), new XmlColumnSerializer1());
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.NULL.getId(), new NullColumnSerializer1());
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.OBJECT.getId(), new ObjectColumnSerializer1());
    }

    public Batch0Serializer(ITeiidServerVersion teiidVersion) {
        this(teiidVersion, 0);
    }

    protected void initDateNormalizer() {
        if (this.dateNormalizer == -1) {
            Calendar c = Calendar.getInstance();
            c.setTimeZone(TimeZone.getTimeZone("GMT"));
            c.set(1900, 0, 1, 0, 0, 0);
            c.set(14, 0);
            this.dateNormalizer = -((int)(c.getTime().getTime() / 60000L));
        }
    }

    protected BatchSerializer.ColumnSerializer getSerializer(String type, byte version) {
        BatchSerializer.ColumnSerializer[] serializerSet;
        BatchSerializer.ColumnSerializer cs = null;
        if (version == 1) {
            cs = this.version1serializers.get(type == null ? DataTypeManagerService.DefaultDataTypes.OBJECT : type);
        }
        if (cs == null && (serializerSet = this.serializers.get(type == null ? DataTypeManagerService.DefaultDataTypes.OBJECT : type)) != null && serializerSet.length > 0) {
            cs = serializerSet[0];
        }
        if (cs == null) {
            return this.defaultSerializer;
        }
        return cs;
    }

    @Override
    public void writeBatch(ObjectOutput out, String[] types, List<? extends List<?>> batch) throws IOException {
        this.writeBatch(out, types, batch, this.getCurrentVersion());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void writeBatch(ObjectOutput out, String[] types, List<? extends List<?>> batch, byte version) throws IOException {
        if (batch == null) {
            out.writeInt(-1);
        } else {
            if (version > 0 && batch.size() > 0) {
                out.writeInt(-batch.size() - 1);
                out.writeByte(version);
            } else {
                out.writeInt(batch.size());
            }
            if (batch.size() > 0) {
                columns = types.length;
                out.writeInt(columns);
                cache = null;
                i = 0;
                while (i < columns) {
                    block11: {
                        serializer = this.getSerializer(types[i], version);
                        if (cache == null && serializer.usesCache(version)) {
                            cache = new HashMap<Object, Integer>();
                        }
                        try {
                            serializer.writeColumn(out, i, batch, cache, version);
                            break block11;
                        }
                        catch (ClassCastException e) {
                            obj = null;
                            objectClass = null;
                            row = 0;
                            ** while (row < batch.size())
                        }
lbl-1000:
                        // 1 sources

                        {
                            obj = batch.get(row).get(i);
                            if (obj != null) {
                                objectClass = obj.getClass().getName();
                                break;
                            }
                            ++row;
                            continue;
                        }
lbl32:
                        // 2 sources

                        throw new RuntimeException(Messages.gs(Messages.TEIID.TEIID20001, new Object[]{types[i], new Integer(i), objectClass}), e);
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public List<List<Object>> readBatch(ObjectInput in, String[] types) throws IOException, ClassNotFoundException {
        return this.readBatch(in, types, (byte)0);
    }

    private List<List<Object>> readBatch(ObjectInput in, String[] types, byte version) throws IOException, ClassNotFoundException {
        int rows = in.readInt();
        if (rows == 0) {
            return new ArrayList<List<Object>>(0);
        }
        if (rows > 0) {
            int columns = in.readInt();
            ResizingArrayList<List<Object>> batch = new ResizingArrayList<List<Object>>(rows);
            int numBytes = rows / 8;
            int extraRows = rows % 8;
            int currentRow = 0;
            while (currentRow < rows) {
                batch.add(currentRow, Arrays.asList(new Object[columns]));
                ++currentRow;
            }
            byte[] isNullBuffer = new byte[extraRows > 0 ? numBytes + 1 : numBytes];
            int col = 0;
            while (col < columns) {
                this.getSerializer(types[col], version).readColumn(in, col, batch, isNullBuffer, null, version);
                ++col;
            }
            return batch;
        }
        return null;
    }

    protected class BigDecimalColumnSerializer
    extends BatchSerializer.ColumnSerializer {
        protected BigDecimalColumnSerializer() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            BigDecimal val = (BigDecimal)obj;
            out.writeInt(val.scale());
            BigInteger unscaled = val.unscaledValue();
            byte[] bytes = unscaled.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes);
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException {
            int scale = in.readInt();
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            return new BigDecimal(new BigInteger(bytes), scale);
        }
    }

    protected class BigIntegerColumnSerializer
    extends BatchSerializer.ColumnSerializer {
        protected BigIntegerColumnSerializer() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            BigInteger val = (BigInteger)obj;
            byte[] bytes = val.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes);
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException {
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            return new BigInteger(bytes);
        }
    }

    protected class BlobColumnSerializer1
    extends BatchSerializer.ColumnSerializer {
        protected BlobColumnSerializer1() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            ((Externalizable)obj).writeExternal(out);
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException, ClassNotFoundException {
            BlobType bt = new BlobType();
            bt.readExternal(in);
            return bt;
        }
    }

    protected class BooleanColumnSerializer
    extends BatchSerializer.ColumnSerializer {
        protected BooleanColumnSerializer() {
        }

        @Override
        public void writeColumn(ObjectOutput out, int col, List<? extends List<?>> batch, Map<Object, Integer> cache, byte version) throws IOException {
            int currentByte = 0;
            int mask = 128;
            int row = 0;
            while (row < batch.size()) {
                Object obj = batch.get(row).get(col);
                if (obj == null) {
                    currentByte |= mask;
                }
                if ((mask >>= 1) == 0) {
                    out.write(currentByte);
                    currentByte = 0;
                    mask = 128;
                }
                if (obj != null) {
                    if (((Boolean)obj).booleanValue()) {
                        currentByte |= mask;
                    }
                    if ((mask >>= 1) == 0) {
                        out.write(currentByte);
                        currentByte = 0;
                        mask = 128;
                    }
                }
                ++row;
            }
            if (mask != 128) {
                out.write(currentByte);
            }
        }

        @Override
        public void readColumn(ObjectInput in, int col, List<List<Object>> batch, byte[] isNull, List<Object> cache, byte version) throws IOException {
            int currentByte = 0;
            int mask = 0;
            int row = 0;
            while (row < batch.size()) {
                if (mask == 0) {
                    currentByte = in.read();
                    mask = 128;
                }
                boolean isNullVal = (currentByte & mask) != 0;
                mask >>= 1;
                if (!isNullVal) {
                    if (mask == 0) {
                        currentByte = in.read();
                        mask = 128;
                    }
                    batch.get(row).set(col, (currentByte & mask) == 0 ? Boolean.FALSE : Boolean.TRUE);
                    mask >>= 1;
                }
                ++row;
            }
        }
    }

    protected class ByteColumnSerializer
    extends BatchSerializer.ColumnSerializer {
        protected ByteColumnSerializer() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            out.writeByte(((Byte)obj).byteValue());
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException {
            return in.readByte();
        }
    }

    protected class CharColumnSerializer
    extends BatchSerializer.ColumnSerializer {
        protected CharColumnSerializer() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            out.writeChar(((Character)obj).charValue());
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException {
            return Character.valueOf(in.readChar());
        }
    }

    protected class ClobColumnSerializer1
    extends BatchSerializer.ColumnSerializer {
        protected ClobColumnSerializer1() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            ((Externalizable)obj).writeExternal(out);
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException, ClassNotFoundException {
            ClobType ct = new ClobType();
            ct.readExternal(in);
            return ct;
        }
    }

    protected class DateColumnSerializer
    extends BatchSerializer.ColumnSerializer {
        protected DateColumnSerializer() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            out.writeLong(((Date)obj).getTime());
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException {
            return new Date(in.readLong());
        }
    }

    protected class DateColumnSerializer1
    extends BatchSerializer.ColumnSerializer {
        protected DateColumnSerializer1() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            out.writeInt((int)(((Date)obj).getTime() / 60000L) + Batch0Serializer.this.dateNormalizer);
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException {
            return new Date((((long)in.readInt() & 0xFFFFFFFFL) - (long)Batch0Serializer.this.dateNormalizer) * 60000L);
        }
    }

    protected class DoubleColumnSerializer
    extends BatchSerializer.ColumnSerializer {
        protected DoubleColumnSerializer() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            out.writeDouble((Double)obj);
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException {
            return new Double(in.readDouble());
        }
    }

    protected class FloatColumnSerializer
    extends BatchSerializer.ColumnSerializer {
        protected FloatColumnSerializer() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            out.writeFloat(((Float)obj).floatValue());
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException {
            return new Float(in.readFloat());
        }
    }

    protected class IntColumnSerializer
    extends BatchSerializer.ColumnSerializer {
        protected IntColumnSerializer() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            out.writeInt((Integer)obj);
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException {
            return in.readInt();
        }
    }

    protected class LongColumnSerializer
    extends BatchSerializer.ColumnSerializer {
        protected LongColumnSerializer() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            out.writeLong((Long)obj);
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException {
            return in.readLong();
        }
    }

    protected class NullColumnSerializer1
    extends BatchSerializer.ColumnSerializer {
        protected NullColumnSerializer1() {
        }

        @Override
        public void writeColumn(ObjectOutput out, int col, List<? extends List<?>> batch, Map<Object, Integer> cache, byte version) {
        }

        @Override
        public void readColumn(ObjectInput in, int col, List<List<Object>> batch, byte[] isNull, List<Object> cache, byte version) {
        }
    }

    protected class ObjectColumnSerializer1
    extends BatchSerializer.ColumnSerializer {
        protected ObjectColumnSerializer1() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            DataTypeManagerService.DefaultDataTypes dataType = Batch0Serializer.this.getDataTypeManager().getDataType(obj.getClass());
            int code = dataType.ordinal();
            out.writeByte((byte)code);
            if (code == DataTypeManagerService.DefaultDataTypes.BOOLEAN.ordinal()) {
                if (Boolean.TRUE.equals(obj)) {
                    out.write(1);
                } else {
                    out.write(0);
                }
            } else if (code != DataTypeManagerService.DefaultDataTypes.OBJECT.ordinal()) {
                dataType = DataTypeManagerService.DefaultDataTypes.valueOf(Batch0Serializer.this.getTeiidVersion(), code);
                BatchSerializer.ColumnSerializer s = Batch0Serializer.this.getSerializer(dataType.getId(), (byte)1);
                s.writeObject(out, obj, cache, version);
            } else {
                super.writeObject(out, obj, cache, version);
            }
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException, ClassNotFoundException {
            byte code = in.readByte();
            return this.readObject(in, code, cache, version);
        }

        public Object readObject(ObjectInput in, int code, List<Object> cache, byte version) throws IOException, ClassNotFoundException {
            if (code == DataTypeManagerService.DefaultDataTypes.BOOLEAN.ordinal()) {
                if (in.readByte() == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            if (code != DataTypeManagerService.DefaultDataTypes.OBJECT.ordinal()) {
                DataTypeManagerService.DefaultDataTypes dataType = DataTypeManagerService.DefaultDataTypes.valueOf(Batch0Serializer.this.getTeiidVersion(), code);
                BatchSerializer.ColumnSerializer s = Batch0Serializer.this.getSerializer(dataType.getId(), (byte)1);
                return s.readObject(in, cache, version);
            }
            return super.readObject(in, cache, version);
        }
    }

    protected class ShortColumnSerializer
    extends BatchSerializer.ColumnSerializer {
        protected ShortColumnSerializer() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            out.writeShort(((Short)obj).shortValue());
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException {
            return in.readShort();
        }
    }

    protected class StringColumnSerializer1
    extends BatchSerializer.ColumnSerializer {
        protected StringColumnSerializer1() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            String str = (String)obj;
            if (str.length() <= 21845) {
                out.writeByte(116);
                out.writeUTF(str);
            } else {
                out.writeByte(124);
                out.writeObject(obj);
            }
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException, ClassNotFoundException {
            if (in.readByte() == 116) {
                return in.readUTF();
            }
            return super.readObject(in, cache, version);
        }
    }

    protected class TimeColumnSerializer
    extends BatchSerializer.ColumnSerializer {
        protected TimeColumnSerializer() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            out.writeLong(((Time)obj).getTime());
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException {
            return new Time(in.readLong());
        }
    }

    protected class TimeColumnSerializer1
    extends BatchSerializer.ColumnSerializer {
        protected TimeColumnSerializer1() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            out.writeInt((int)(((Time)obj).getTime() / 1000L));
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException {
            return new Time(((long)in.readInt() & 0xFFFFFFFFL) * 1000L);
        }
    }

    protected class TimestampColumnSerializer
    extends BatchSerializer.ColumnSerializer {
        protected TimestampColumnSerializer() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            Timestamp ts = (Timestamp)obj;
            out.writeLong(ts.getTime());
            out.writeInt(ts.getNanos());
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException {
            Timestamp ts = new Timestamp(in.readLong());
            ts.setNanos(in.readInt());
            return ts;
        }
    }

    protected class XmlColumnSerializer1
    extends BatchSerializer.ColumnSerializer {
        protected XmlColumnSerializer1() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            ((Externalizable)obj).writeExternal(out);
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException, ClassNotFoundException {
            XMLType xt = new XMLType();
            xt.readExternal(in);
            return xt;
        }
    }
}

