/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client.batch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.teiid.client.BatchSerializer;
import org.teiid.client.ResizingArrayList;
import org.teiid.client.batch.Batch0Serializer;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.XMLType;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;

public class Batch1Serializer
extends Batch0Serializer {
    protected Batch1Serializer(ITeiidServerVersion teiidVersion, byte version) {
        super(teiidVersion, version);
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.VARBINARY.getId(), new BatchSerializer.ColumnSerializer[]{new BinaryColumnSerializer()});
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.XML.getId(), new XmlColumnSerializer1_B1());
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.OBJECT.getId(), new ObjectColumnSerializer1_B1(DataTypeManagerService.DefaultDataTypes.VARBINARY.ordinal()));
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.VARBINARY.getId(), new BinaryColumnSerializer1());
    }

    public Batch1Serializer(ITeiidServerVersion teiidVersion) {
        this(teiidVersion, 1);
    }

    @Override
    public List<List<Object>> readBatch(ObjectInput in, String[] types) throws IOException, ClassNotFoundException {
        int rows = 0;
        try {
            rows = in.readInt();
        }
        catch (IOException e) {
            if (types == null || types.length == 0) {
                List[] result = (List[])in.readObject();
                ArrayList<List<Object>> batch = new ArrayList<List<Object>>();
                batch.addAll(Arrays.asList(result));
                return batch;
            }
            throw e;
        }
        if (rows == 0) {
            return new ArrayList<List<Object>>(0);
        }
        if (rows == -1) {
            return null;
        }
        byte version = 0;
        if (rows < 0) {
            rows = -(rows + 1);
            version = in.readByte();
        }
        int columns = in.readInt();
        ResizingArrayList<List<Object>> batch = new ResizingArrayList<List<Object>>(rows);
        int numBytes = rows / 8;
        int extraRows = rows % 8;
        int currentRow = 0;
        while (currentRow < rows) {
            batch.add(currentRow, Arrays.asList(new Object[columns]));
            ++currentRow;
        }
        byte[] isNullBuffer = new byte[extraRows > 0 ? numBytes + 1 : numBytes];
        ArrayList<Object> cache = null;
        int col = 0;
        while (col < columns) {
            BatchSerializer.ColumnSerializer serializer = this.getSerializer(types[col], version);
            if (cache == null && serializer.usesCache(version)) {
                cache = new ArrayList<Object>();
            }
            serializer.readColumn(in, col, batch, isNullBuffer, cache, version);
            ++col;
        }
        return batch;
    }

    protected class BinaryColumnSerializer
    extends BatchSerializer.ColumnSerializer {
        protected BinaryColumnSerializer() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            super.writeObject(out, ((BinaryType)obj).getBytesDirect(), cache, version);
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException, ClassNotFoundException {
            byte[] bytes = (byte[])super.readObject(in, cache, version);
            return new BinaryType(bytes);
        }
    }

    protected class BinaryColumnSerializer1
    extends BatchSerializer.ColumnSerializer {
        protected BinaryColumnSerializer1() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            byte[] bytes = ((BinaryType)obj).getBytes();
            out.writeInt(bytes.length);
            out.write(bytes);
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException {
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            return new BinaryType(bytes);
        }
    }

    protected class ObjectColumnSerializer1_B1
    extends Batch0Serializer.ObjectColumnSerializer1 {
        private int highestKnownCode;

        public ObjectColumnSerializer1_B1() {
            super(Batch1Serializer.this);
            this.highestKnownCode = -1;
        }

        public ObjectColumnSerializer1_B1(int highestKnownCode) {
            super(Batch1Serializer.this);
            this.highestKnownCode = highestKnownCode;
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            DataTypeManagerService.DefaultDataTypes dataType = Batch1Serializer.this.getDataTypeManager().getDataType(obj.getClass());
            int code = dataType.ordinal();
            out.writeByte((byte)code);
            this.writeObject(out, obj, code, cache, version);
        }

        public void writeObject(ObjectOutput out, Object obj, int code, Map<Object, Integer> cache, byte version) throws IOException {
            if (code == DataTypeManagerService.DefaultDataTypes.BOOLEAN.ordinal()) {
                if (Boolean.TRUE.equals(obj)) {
                    out.write(1);
                } else {
                    out.write(0);
                }
            } else if (code <= this.highestKnownCode && code != DataTypeManagerService.DefaultDataTypes.OBJECT.ordinal()) {
                DataTypeManagerService.DefaultDataTypes dataType = DataTypeManagerService.DefaultDataTypes.valueOf(Batch1Serializer.this.getTeiidVersion(), code);
                BatchSerializer.ColumnSerializer s = Batch1Serializer.this.getSerializer(dataType.getId(), version);
                s.writeObject(out, obj, cache, version);
            } else {
                super.writeObject(out, obj, cache, version);
            }
        }

        @Override
        public boolean usesCache(byte version) {
            return version >= 3;
        }
    }

    private class XmlColumnSerializer1_B1
    extends Batch0Serializer.XmlColumnSerializer1 {
        private XmlColumnSerializer1_B1() {
            super(Batch1Serializer.this);
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            ((XMLType)obj).writeExternal(out, (byte)1);
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException, ClassNotFoundException {
            XMLType xt = new XMLType();
            xt.readExternal(in, (byte)1);
            return xt;
        }
    }
}

