/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client.batch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.teiid.client.BatchSerializer;
import org.teiid.client.batch.Batch0Serializer;
import org.teiid.client.batch.Batch1Serializer;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.runtime.client.Messages;

public class Batch2Serializer
extends Batch1Serializer {
    protected BatchSerializer.ColumnSerializer arrayColumnSerializer = new BatchSerializer.ColumnSerializer(this){

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            try {
                super.writeObject(out, ((java.sql.Array)obj).getArray(), cache, version);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException, ClassNotFoundException {
            return new ArrayImpl(Batch2Serializer.this.getTeiidVersion(), (Object[])in.readObject());
        }
    };
    private static long MIN_DATE_32;
    private static long MAX_DATE_32;
    private static long MIN_TIME_32;
    private static long MAX_TIME_32;

    protected Batch2Serializer(ITeiidServerVersion teiidVersion, byte version) {
        super(teiidVersion, version);
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL.getId(), new BatchSerializer.ColumnSerializer[]{new Batch0Serializer.BigDecimalColumnSerializer(this)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.BIG_INTEGER.getId(), new BatchSerializer.ColumnSerializer[]{new Batch0Serializer.BigIntegerColumnSerializer(this)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.BOOLEAN.getId(), new BatchSerializer.ColumnSerializer[]{new Batch0Serializer.BooleanColumnSerializer(this)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.BYTE.getId(), new BatchSerializer.ColumnSerializer[]{new Batch0Serializer.ByteColumnSerializer(this)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.CHAR.getId(), new BatchSerializer.ColumnSerializer[]{new Batch0Serializer.CharColumnSerializer(this)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.DATE.getId(), new BatchSerializer.ColumnSerializer[]{new Batch0Serializer.DateColumnSerializer(this), new DateColumnSerializer1_B2(), new Batch0Serializer.DateColumnSerializer(this)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.DOUBLE.getId(), new BatchSerializer.ColumnSerializer[]{new Batch0Serializer.DoubleColumnSerializer(this)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.FLOAT.getId(), new BatchSerializer.ColumnSerializer[]{new Batch0Serializer.FloatColumnSerializer(this)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.INTEGER.getId(), new BatchSerializer.ColumnSerializer[]{new Batch0Serializer.IntColumnSerializer(this)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.LONG.getId(), new BatchSerializer.ColumnSerializer[]{new Batch0Serializer.LongColumnSerializer(this)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.SHORT.getId(), new BatchSerializer.ColumnSerializer[]{new Batch0Serializer.ShortColumnSerializer(this)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.TIME.getId(), new BatchSerializer.ColumnSerializer[]{new Batch0Serializer.TimeColumnSerializer(this), new TimeColumnSerializer1_B2(), new Batch0Serializer.TimeColumnSerializer(this)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.TIMESTAMP.getId(), new BatchSerializer.ColumnSerializer[]{new Batch0Serializer.TimestampColumnSerializer(this)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.STRING.getId(), new BatchSerializer.ColumnSerializer[]{this.defaultSerializer, new Batch0Serializer.StringColumnSerializer1(this)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.CLOB.getId(), new BatchSerializer.ColumnSerializer[]{this.defaultSerializer, new Batch0Serializer.ClobColumnSerializer1(this)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.BLOB.getId(), new BatchSerializer.ColumnSerializer[]{this.defaultSerializer, new Batch0Serializer.BlobColumnSerializer1(this)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.XML.getId(), new BatchSerializer.ColumnSerializer[]{this.defaultSerializer, new Batch0Serializer.XmlColumnSerializer1(this)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.NULL.getId(), new BatchSerializer.ColumnSerializer[]{this.defaultSerializer, new Batch0Serializer.NullColumnSerializer1(this)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.OBJECT.getId(), new BatchSerializer.ColumnSerializer[]{this.defaultSerializer, new Batch1Serializer.ObjectColumnSerializer1_B1(DataTypeManagerService.DefaultDataTypes.VARBINARY.ordinal())});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.VARBINARY.getId(), new BatchSerializer.ColumnSerializer[]{new Batch1Serializer.BinaryColumnSerializer(), new Batch1Serializer.BinaryColumnSerializer1()});
    }

    public Batch2Serializer(ITeiidServerVersion teiidVersion) {
        this(teiidVersion, 2);
    }

    protected BatchSerializer.ColumnSerializer getArrayColumnSerializer2() {
        return new ArrayColumnSerializer2(new Batch1Serializer.ObjectColumnSerializer1_B1(DataTypeManagerService.DefaultDataTypes.VARBINARY.ordinal()));
    }

    @Override
    protected void initDateNormalizer() {
        if (this.dateNormalizer == -1) {
            Calendar c = Calendar.getInstance();
            c.setTimeZone(TimeZone.getTimeZone("GMT"));
            c.set(1900, 0, 1, 0, 0, 0);
            c.set(14, 0);
            MIN_DATE_32 = c.getTimeInMillis();
            MAX_DATE_32 = MIN_DATE_32 + 257698037700000L;
            this.dateNormalizer = -((int)(MIN_DATE_32 / 60000L));
            MAX_TIME_32 = 2147483647000L;
            MIN_TIME_32 = -2147483648000L;
        }
    }

    @Override
    protected BatchSerializer.ColumnSerializer getSerializer(String type, byte version) {
        BatchSerializer.ColumnSerializer[] sers = (BatchSerializer.ColumnSerializer[])this.serializers.get(type);
        if (sers == null) {
            if (DataTypeManagerService.isArrayType(type)) {
                if (version < 2) {
                    return this.arrayColumnSerializer;
                }
                return this.getArrayColumnSerializer2();
            }
            return this.defaultSerializer;
        }
        return sers[Math.min(version, sers.length - 1)];
    }

    protected class ArrayColumnSerializer2
    extends BatchSerializer.ColumnSerializer {
        Batch1Serializer.ObjectColumnSerializer1_B1 ser;

        public ArrayColumnSerializer2(Batch1Serializer.ObjectColumnSerializer1_B1 ser) {
            this.ser = ser;
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            Object[] values = null;
            try {
                values = (Object[])((java.sql.Array)obj).getArray();
            }
            catch (SQLException sQLException) {
                out.writeInt(-1);
                return;
            }
            out.writeInt(values.length);
            DataTypeManagerService.DefaultDataTypes dataType = Batch2Serializer.this.getDataTypeManager().getDataType(values.getClass().getComponentType());
            int code = dataType.ordinal();
            out.writeByte((byte)code);
            int i = 0;
            while (i < values.length) {
                Batch2Serializer.this.writeIsNullData(out, i, values);
                int end = Math.min(values.length, i + 8);
                while (i < end) {
                    if (values[i] != null) {
                        this.ser.writeObject(out, values[i], code, cache, version);
                    }
                    ++i;
                }
            }
            out.writeBoolean(obj instanceof ArrayImpl && ((ArrayImpl)obj).isZeroBased());
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException, ClassNotFoundException {
            int length = in.readInt();
            if (length == -1) {
                return new ArrayImpl(Batch2Serializer.this.getTeiidVersion(), null);
            }
            byte code = in.readByte();
            DataTypeManagerService.DefaultDataTypes dataType = DataTypeManagerService.DefaultDataTypes.valueOf(Batch2Serializer.this.getTeiidVersion(), code);
            Object[] vals = (Object[])Array.newInstance(dataType.getTypeClass(), length);
            int i = 0;
            while (i < length) {
                byte b = in.readByte();
                int end = Math.min(length, i + 8);
                while (i < end) {
                    if (!Batch2Serializer.this.isNullObject(i, b)) {
                        vals[i] = this.ser.readObject(in, code, cache, version);
                    }
                    ++i;
                }
            }
            ArrayImpl result = new ArrayImpl(Batch2Serializer.this.getTeiidVersion(), vals);
            result.setZeroBased(in.readBoolean());
            return result;
        }

        @Override
        public boolean usesCache(byte version) {
            return version >= 3;
        }
    }

    private class DateColumnSerializer1_B2
    extends Batch0Serializer.DateColumnSerializer1 {
        private DateColumnSerializer1_B2() {
            super(Batch2Serializer.this);
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            long time = ((Date)obj).getTime();
            if (time < MIN_DATE_32 || time > MAX_DATE_32) {
                throw new IOException(Messages.gs(Messages.TEIID.TEIID20029, obj.getClass().getName()));
            }
            out.writeInt((int)(time / 60000L) + Batch2Serializer.this.dateNormalizer);
        }
    }

    protected class TimeColumnSerializer1_B2
    extends Batch0Serializer.TimeColumnSerializer1 {
        protected TimeColumnSerializer1_B2() {
            super(Batch2Serializer.this);
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            long time = ((Time)obj).getTime();
            if (time < MIN_TIME_32 || time > MAX_TIME_32) {
                throw new IOException(Messages.gs(Messages.TEIID.TEIID20029, obj.getClass().getName()));
            }
            out.writeInt((int)(time / 1000L));
        }
    }
}

