/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client.batch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import org.teiid.client.BatchSerializer;
import org.teiid.client.batch.Batch0Serializer;
import org.teiid.client.batch.Batch2Serializer;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;

public class Batch3Serializer
extends Batch2Serializer {
    protected Batch3Serializer(ITeiidServerVersion teiidVersion, byte version) {
        super(teiidVersion, version);
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.STRING.getId(), new BatchSerializer.ColumnSerializer[]{this.defaultSerializer, new Batch0Serializer.StringColumnSerializer1(this), new Batch0Serializer.StringColumnSerializer1(this), new StringColumnSerializer3()});
    }

    public Batch3Serializer(ITeiidServerVersion teiidVersion) {
        this(teiidVersion, 3);
    }

    protected class StringColumnSerializer3
    extends Batch0Serializer.StringColumnSerializer1 {
        private int MAX_INLINE_STRING_LENGTH;
        private byte REPEATED_STRING;

        protected StringColumnSerializer3() {
            super(Batch3Serializer.this);
            this.MAX_INLINE_STRING_LENGTH = 5;
            this.REPEATED_STRING = 0;
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException, ClassNotFoundException {
            byte b = in.readByte();
            if (b == 116) {
                String val = in.readUTF();
                if (val.length() > this.MAX_INLINE_STRING_LENGTH) {
                    cache.add(val);
                }
                return val;
            }
            if (b == this.REPEATED_STRING) {
                Integer val = in.readInt();
                return cache.get(val);
            }
            String val = (String)in.readObject();
            if (val.length() > this.MAX_INLINE_STRING_LENGTH) {
                cache.add(val);
            }
            return val;
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            String str = (String)obj;
            Integer val = cache.get(str);
            if (val != null) {
                out.writeByte(this.REPEATED_STRING);
                out.writeInt(val);
                return;
            }
            if (str.length() > this.MAX_INLINE_STRING_LENGTH) {
                cache.put(str, cache.size());
            }
            super.writeObject(out, obj, cache, version);
        }

        @Override
        public boolean usesCache(byte version) {
            return true;
        }
    }
}

