/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client.batch;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Array;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.teiid.client.BatchSerializer;
import org.teiid.client.batch.Batch1Serializer;
import org.teiid.client.batch.Batch2Serializer;
import org.teiid.client.batch.Batch3Serializer;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.GeometryType;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;

public class Batch4Serializer
extends Batch3Serializer {
    private static final byte VERSION_GEOMETRY = 4;

    protected Batch4Serializer(ITeiidServerVersion teiidVersion, byte version) {
        super(teiidVersion, version);
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.GEOMETRY.getId(), new BatchSerializer.ColumnSerializer[]{this.defaultSerializer, new GeometryColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.OBJECT.getId(), new BatchSerializer.ColumnSerializer[]{this.defaultSerializer, new ObjectColumnSerializer_B4(1)});
    }

    public Batch4Serializer(ITeiidServerVersion teiidVersion) {
        this(teiidVersion, 4);
    }

    @Override
    protected BatchSerializer.ColumnSerializer getArrayColumnSerializer2() {
        return new Batch2Serializer.ArrayColumnSerializer2(this, new ObjectColumnSerializer_B4(2));
    }

    protected class ArrayColumnSerializer2_B4
    extends Batch2Serializer.ArrayColumnSerializer2 {
        public ArrayColumnSerializer2_B4(ObjectColumnSerializer_B4 ser) {
            super(Batch4Serializer.this, ser);
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            Object[] values = null;
            try {
                values = (Object[])((Array)obj).getArray();
            }
            catch (SQLException sQLException) {
                out.writeInt(-1);
                return;
            }
            out.writeInt(values.length);
            DataTypeManagerService.DefaultDataTypes dataType = Batch4Serializer.this.getDataTypeManager().getDataType(values.getClass().getComponentType());
            int code = dataType.ordinal();
            if (code == DataTypeManagerService.DefaultDataTypes.GEOMETRY.ordinal() && version < 4) {
                code = DataTypeManagerService.DefaultDataTypes.BLOB.ordinal();
            }
            out.writeByte((byte)code);
            int i = 0;
            while (i < values.length) {
                Batch4Serializer.this.writeIsNullData(out, i, values);
                int end = Math.min(values.length, i + 8);
                while (i < end) {
                    if (values[i] != null) {
                        this.ser.writeObject(out, values[i], code, cache, version);
                    }
                    ++i;
                }
            }
            out.writeBoolean(obj instanceof ArrayImpl && ((ArrayImpl)obj).isZeroBased());
        }
    }

    protected class GeometryColumnSerializer
    extends BatchSerializer.ColumnSerializer {
        protected GeometryColumnSerializer() {
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            ((Externalizable)obj).writeExternal(out);
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException, ClassNotFoundException {
            if (version < 4) {
                BlobType bt = new BlobType();
                bt.readExternal(in);
                return bt;
            }
            GeometryType bt = new GeometryType();
            bt.readExternal(in);
            return bt;
        }
    }

    protected class ObjectColumnSerializer_B4
    extends Batch1Serializer.ObjectColumnSerializer1_B1 {
        byte defaultVersion;

        public ObjectColumnSerializer_B4(byte version) {
            super(Batch4Serializer.this);
            this.defaultVersion = version;
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, Map<Object, Integer> cache, byte version) throws IOException {
            DataTypeManagerService.DefaultDataTypes dataType = Batch4Serializer.this.getDataTypeManager().getDataType(obj.getClass());
            int code = dataType.ordinal();
            if (code == DataTypeManagerService.DefaultDataTypes.GEOMETRY.ordinal() && version < 4) {
                code = DataTypeManagerService.DefaultDataTypes.BLOB.ordinal();
            }
            out.writeByte((byte)code);
            this.writeObject(out, obj, code, cache, version < 4 ? this.defaultVersion : version);
        }

        @Override
        public void writeObject(ObjectOutput out, Object obj, int code, Map<Object, Integer> cache, byte effectiveVersion) throws IOException {
            if (code == DataTypeManagerService.DefaultDataTypes.BOOLEAN.ordinal()) {
                if (Boolean.TRUE.equals(obj)) {
                    out.write(1);
                } else {
                    out.write(0);
                }
            } else if (code == DataTypeManagerService.DefaultDataTypes.OBJECT.ordinal()) {
                super.writeObject(out, obj, cache, effectiveVersion);
            } else {
                String name = Batch4Serializer.this.getDataTypeManager().getDataTypeName(obj.getClass());
                BatchSerializer.ColumnSerializer s = Batch4Serializer.this.getSerializer(name, effectiveVersion);
                s.writeObject(out, obj, cache, effectiveVersion);
            }
        }

        @Override
        public Object readObject(ObjectInput in, List<Object> cache, byte version) throws IOException, ClassNotFoundException {
            byte code = in.readByte();
            return this.readObject(in, code, cache, version < 4 ? this.defaultVersion : version);
        }

        @Override
        public boolean usesCache(byte version) {
            return version >= 3;
        }
    }
}

