/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.crypto;

import java.io.ByteArrayInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;
import org.teiid.core.crypto.CryptoException;
import org.teiid.core.crypto.Cryptor;
import org.teiid.core.util.AccessibleByteArrayOutputStream;
import org.teiid.core.util.Base64;
import org.teiid.core.util.ObjectInputStreamWithClassloader;
import org.teiid.runtime.client.Messages;

public class BasicCryptor
implements Cryptor {
    protected Key decryptKey;
    private Cipher decryptCipher;
    private Key encryptKey;
    protected Cipher encryptCipher;
    protected String cipherAlgorithm;
    public static final String OLD_ENCRYPT_PREFIX = "{mm-encrypt}";
    public static final String ENCRYPT_PREFIX = "{teiid-encrypt}";
    private ClassLoader classLoader = BasicCryptor.class.getClassLoader();
    private boolean useSealedObject = true;

    public BasicCryptor(Key encryptKey, Key decryptKey, String algorithm) throws CryptoException {
        this.encryptKey = encryptKey;
        this.cipherAlgorithm = algorithm;
        this.decryptKey = decryptKey;
        this.initEncryptCipher();
        this.initDecryptCipher();
    }

    public synchronized void setUseSealedObject(boolean useSealedObject) {
        this.useSealedObject = useSealedObject;
    }

    public synchronized void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public synchronized byte[] decrypt(byte[] ciphertext) throws CryptoException {
        try {
            return this.decryptCipher.doFinal(ciphertext);
        }
        catch (Exception e) {
            try {
                this.initDecryptCipher();
            }
            catch (CryptoException cryptoException) {}
            throw new CryptoException(Messages.gs(Messages.TEIID.TEIID10006, e.getClass().getName(), e.getMessage()));
        }
    }

    @Override
    public String decrypt(String ciphertext) throws CryptoException {
        if (ciphertext == null) {
            throw new CryptoException(Messages.gs(Messages.TEIID.TEIID10007, new Object[0]));
        }
        ciphertext = BasicCryptor.stripEncryptionPrefix(ciphertext);
        byte[] cipherBytes = null;
        try {
            cipherBytes = Base64.decode(ciphertext);
        }
        catch (IllegalArgumentException e) {
            throw new CryptoException(Messages.gs(Messages.TEIID.TEIID10008, e.getMessage()));
        }
        byte[] cleartext = this.decrypt(cipherBytes);
        return new String(cleartext);
    }

    public static String stripEncryptionPrefix(String ciphertext) {
        if (ciphertext.startsWith(ENCRYPT_PREFIX)) {
            ciphertext = ciphertext.substring(ENCRYPT_PREFIX.length());
        } else if (ciphertext.startsWith(OLD_ENCRYPT_PREFIX)) {
            ciphertext = ciphertext.substring(OLD_ENCRYPT_PREFIX.length());
        }
        return ciphertext;
    }

    protected void initDecryptCipher() throws CryptoException {
        try {
            this.decryptCipher = Cipher.getInstance(this.cipherAlgorithm);
            this.decryptCipher.init(2, this.decryptKey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoException(Messages.gs(Messages.TEIID.TEIID10009, this.cipherAlgorithm));
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoException(Messages.gs(Messages.TEIID.TEIID10010, this.cipherAlgorithm, e.getClass().getName(), e.getMessage()));
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e, Messages.gs(Messages.TEIID.TEIID10011, e.getClass().getName(), e.getMessage()));
        }
    }

    @Override
    public synchronized Object unsealObject(Object object) throws CryptoException {
        if (this.useSealedObject) {
            if (!(object instanceof SealedObject)) {
                return object;
            }
            SealedObject so = (SealedObject)object;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                if (cl != this.classLoader) {
                    Thread.currentThread().setContextClassLoader(BasicCryptor.class.getClassLoader());
                }
                Object object2 = so.getObject(this.decryptCipher);
                return object2;
            }
            catch (Exception e) {
                try {
                    this.initDecryptCipher();
                }
                catch (CryptoException cryptoException) {}
                throw new CryptoException(Messages.gs(Messages.TEIID.TEIID10006, e.getClass().getName(), e.getMessage()));
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        if (!(object instanceof byte[])) {
            return object;
        }
        byte[] bytes = (byte[])object;
        bytes = this.decrypt(bytes);
        try {
            ObjectInputStreamWithClassloader ois = new ObjectInputStreamWithClassloader(new ByteArrayInputStream(bytes), this.classLoader);
            return ois.readObject();
        }
        catch (Exception e) {
            throw new CryptoException(Messages.gs(Messages.TEIID.TEIID10006, e.getClass().getName(), e.getMessage()));
        }
    }

    @Override
    public byte[] encrypt(byte[] cleartext) throws CryptoException {
        return this.encrypt(cleartext, 0, cleartext.length);
    }

    public synchronized byte[] encrypt(byte[] buffer, int offset, int length) throws CryptoException {
        try {
            return this.encryptCipher.doFinal(buffer, offset, length);
        }
        catch (Exception e) {
            try {
                this.initEncryptCipher();
            }
            catch (CryptoException cryptoException) {}
            throw new CryptoException(Messages.gs(Messages.TEIID.TEIID10013, e.getMessage()));
        }
    }

    @Override
    public String encrypt(String cleartext) throws CryptoException {
        if (cleartext == null) {
            throw new CryptoException(Messages.gs(Messages.TEIID.TEIID10014, new Object[0]));
        }
        String clearString = new String(cleartext);
        if (clearString.trim().length() == 0 && clearString.length() == 0) {
            throw new CryptoException(Messages.gs(Messages.TEIID.TEIID10015, new Object[0]));
        }
        byte[] clearBytes = clearString.getBytes();
        byte[] cipherBytes = this.encrypt(clearBytes);
        String encoded = Base64.encodeBytes(cipherBytes);
        return ENCRYPT_PREFIX + encoded;
    }

    protected void initEncryptCipher() throws CryptoException {
        try {
            this.encryptCipher = Cipher.getInstance(this.cipherAlgorithm);
            this.encryptCipher.init(1, this.encryptKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e, Messages.gs(Messages.TEIID.TEIID10016, this.cipherAlgorithm));
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoException(e, Messages.gs(Messages.TEIID.TEIID10017, this.cipherAlgorithm, e.getMessage()));
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e, Messages.gs(Messages.TEIID.TEIID10018, e.getMessage()));
        }
    }

    @Override
    public synchronized Object sealObject(Object object) throws CryptoException {
        try {
            if (this.useSealedObject) {
                return new SealedObject((Serializable)object, this.encryptCipher);
            }
            AccessibleByteArrayOutputStream baos = new AccessibleByteArrayOutputStream(8192);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.flush();
            oos.close();
            return this.encrypt(baos.getBuffer(), 0, baos.getCount());
        }
        catch (Exception e) {
            try {
                this.initEncryptCipher();
            }
            catch (CryptoException cryptoException) {}
            throw new CryptoException(Messages.gs(Messages.TEIID.TEIID10013, e.getMessage()));
        }
    }
}

