/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialBlob;
import org.teiid.core.types.Streamable;
import org.teiid.core.util.ObjectConverterUtil;

public class BlobType
extends Streamable<Blob>
implements Blob,
Comparable<BlobType> {
    private static final long serialVersionUID = 1294191629070433450L;

    public BlobType() {
    }

    public BlobType(byte[] bytes) {
        super(BlobType.createBlob(bytes));
    }

    public BlobType(Blob blob) {
        super(blob);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return ((Blob)this.reference).getBinaryStream();
    }

    @Override
    public byte[] getBytes(long pos, int len) throws SQLException {
        return ((Blob)this.reference).getBytes(pos, len);
    }

    @Override
    long computeLength() throws SQLException {
        return ((Blob)this.reference).length();
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return ((Blob)this.reference).position(pattern, start);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        return ((Blob)this.reference).position(pattern, start);
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        return ((Blob)this.reference).setBinaryStream(pos);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        return ((Blob)this.reference).setBytes(pos, bytes, offset, len);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return ((Blob)this.reference).setBytes(pos, bytes);
    }

    @Override
    public void truncate(long len) throws SQLException {
        ((Blob)this.reference).truncate(len);
    }

    @Override
    public void free() throws SQLException {
        ((Blob)this.reference).free();
    }

    @Override
    public InputStream getBinaryStream(long pos, long len) throws SQLException {
        return ((Blob)this.reference).getBinaryStream(pos, len);
    }

    public static SerialBlob createBlob(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new SerialBlob(bytes);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void readReference(ObjectInput in) throws IOException {
        byte[] bytes = new byte[(int)this.getLength()];
        in.readFully(bytes);
        try {
            this.reference = new SerialBlob(bytes);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void writeReference(DataOutput out) throws IOException {
        try {
            BlobType.writeBinary(out, this.getBinaryStream(), (int)this.length);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    static void writeBinary(final DataOutput out, InputStream is, int length) throws IOException {
        OutputStream os = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                out.write(b);
            }
        };
        try {
            int bytes = ObjectConverterUtil.write(os, is, length, false);
            if (bytes != length) {
                throw new IOException("Expected length " + length + " but was " + bytes);
            }
        }
        finally {
            is.close();
        }
    }

    @Override
    public int compareTo(BlobType o) {
        try {
            InputStream is1 = this.getBinaryStream();
            InputStream is2 = o.getBinaryStream();
            long len1 = this.length();
            long len2 = o.length();
            long n = Math.min(len1, len2);
            long i = 0L;
            while (i < n) {
                int b2;
                int b1 = is1.read();
                if (b1 != (b2 = is2.read())) {
                    return b1 - b2;
                }
                ++i;
            }
            return Long.signum(len1 - len2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BlobType)) {
            return false;
        }
        BlobType other = (BlobType)obj;
        if (this.reference != null && ((Blob)this.reference).equals(other.reference)) {
            return true;
        }
        try {
            return this.compareTo(other) == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return 1;
    }
}

