/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.sql.SQLException;
import org.teiid.core.types.BaseLob;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.LobSearchUtil;
import org.teiid.core.types.Streamable;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.runtime.client.Messages;

public class ClobImpl
extends BaseLob
implements Clob {
    private long len = -1L;

    public ClobImpl() {
    }

    public ClobImpl(InputStreamFactory streamFactory, long length) {
        super(streamFactory);
        this.len = length;
    }

    public ClobImpl(char[] chars) {
        this(new StringInputStreamFactory(new String(chars)), chars.length);
    }

    public ClobImpl(String str) {
        this(new StringInputStreamFactory(str), str.length());
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return new ReaderInputStream(this.getCharacterStream(), Charset.forName("US-ASCII"));
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        String string;
        if (pos < 1L) {
            Object[] params = new Object[]{new Long(pos)};
            throw new SQLException(Messages.getString(Messages.MMClob.MMBlob_0, params));
        }
        if (pos > this.length()) {
            return null;
        }
        --pos;
        if (length < 0) {
            Object[] params = new Object[]{new Integer(length)};
            throw new SQLException(Messages.getString(Messages.MMClob.MMBlob_1, params));
        }
        if (pos + (long)length > this.length()) {
            length = (int)(this.length() - pos);
        }
        Reader in = this.getCharacterStream();
        try {
            long skipped = 0L;
            while (pos > 0L) {
                skipped = in.skip(pos);
                pos -= skipped;
            }
            string = new String(ObjectConverterUtil.convertToCharArray(in, length));
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        in.close();
        return string;
    }

    @Override
    public long length() throws SQLException {
        if (this.len == -1L) {
            long length = 0L;
            BufferedReader r = new BufferedReader(this.getCharacterStream());
            try {
                try {
                    while (((Reader)r).read() != -1) {
                        ++length;
                    }
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)r).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((Reader)r).close();
            }
            catch (IOException iOException) {}
            this.len = length;
        }
        return this.len;
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        if (searchstr == null) {
            return -1L;
        }
        return LobSearchUtil.position(new ClobStreamProvider(searchstr), searchstr.length(), new ClobStreamProvider(this), this.length(), start, 2);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        if (searchstr == null) {
            return -1L;
        }
        return this.position(new ClobImpl(searchstr), start);
    }

    @Override
    public Reader getCharacterStream(long arg0, long arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream setAsciiStream(long arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Writer setCharacterStream(long arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setString(long arg0, String arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setString(long arg0, String arg1, int arg2, int arg3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void truncate(long arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public static Clob createClob(char[] chars) {
        return new ClobImpl(chars);
    }

    private static final class ClobStreamProvider
    implements LobSearchUtil.StreamProvider {
        private final Clob searchstr;

        private ClobStreamProvider(Clob searchstr) {
            this.searchstr = searchstr;
        }

        @Override
        public InputStream getBinaryStream() throws SQLException {
            ReaderInputStream ris = new ReaderInputStream(this.searchstr.getCharacterStream(), Charset.forName("UTF-16"));
            try {
                ris.skip(2L);
                return ris;
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
    }

    private static final class StringInputStreamFactory
    extends InputStreamFactory {
        String str;

        private StringInputStreamFactory(String str) {
            this.str = str;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.str.getBytes(Streamable.CHARSET));
        }

        @Override
        public Reader getCharacterStream() throws IOException {
            return new StringReader(this.str);
        }

        @Override
        public InputStreamFactory.StorageMode getStorageMode() {
            return InputStreamFactory.StorageMode.MEMORY;
        }
    }
}

