/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.teiid.runtime.client.Messages;

public class LobSearchUtil {
    private static final int MOD = 37;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long position(StreamProvider pattern, long patternLength, StreamProvider target, long targetLength, long start, int bytesPerComparison) throws SQLException {
        if (pattern == null) {
            return -1L;
        }
        patternLength *= (long)bytesPerComparison;
        targetLength *= (long)bytesPerComparison;
        if (start < 1L) {
            Object[] params = new Object[]{new Long(start)};
            throw new SQLException(Messages.getString(Messages.MMClob.MMBlob_2, params));
        }
        if ((start = (start - 1L) * (long)bytesPerComparison) + patternLength > targetLength) {
            return -1L;
        }
        try {
            InputStream patternStream = pattern.getBinaryStream();
            InputStream targetStream = target.getBinaryStream();
            InputStream laggingTargetStream = target.getBinaryStream();
            try {
                int patternHash = LobSearchUtil.computeStreamHash(patternStream, patternLength);
                int lastMod = 1;
                int i = 0;
                while ((long)i < patternLength) {
                    lastMod *= 37;
                    ++i;
                }
                targetStream.skip(start);
                laggingTargetStream.skip(start);
                long position = start + 1L;
                int streamHash = LobSearchUtil.computeStreamHash(targetStream, patternLength);
                do {
                    if ((position - 1L) % (long)bytesPerComparison == 0L && patternHash == streamHash && LobSearchUtil.validateMatch(pattern, target, position)) {
                        long l = (position - 1L) / (long)bytesPerComparison + 1L;
                        return l;
                    }
                    streamHash = 37 * streamHash + targetStream.read() - lastMod * laggingTargetStream.read();
                } while (++position + patternLength - 1L <= targetLength);
                return -1L;
            }
            finally {
                if (patternStream != null) {
                    patternStream.close();
                }
                if (targetStream != null) {
                    targetStream.close();
                }
                if (laggingTargetStream != null) {
                    laggingTargetStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private static boolean validateMatch(StreamProvider pattern, StreamProvider target, long position) throws IOException, SQLException {
        InputStream targetStream = target.getBinaryStream();
        InputStream patternStream = pattern.getBinaryStream();
        try {
            targetStream.skip(position - 1L);
            int value = 0;
            while ((value = patternStream.read()) != -1) {
                if (value == targetStream.read()) continue;
                return false;
            }
        }
        finally {
            targetStream.close();
            patternStream.close();
        }
        return true;
    }

    private static int computeStreamHash(InputStream is, long length) throws IOException {
        int result = 0;
        int i = 0;
        while ((long)i < length) {
            result = result * 37 + is.read();
            ++i;
        }
        return result;
    }

    public static interface StreamProvider {
        public InputStream getBinaryStream() throws SQLException;
    }
}

