/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;

public class AnyToStringTransform
extends Transform {
    private Class<?> sourceType;

    public AnyToStringTransform(DataTypeManagerService dataTypeManager, Class<?> sourceType) {
        super(dataTypeManager);
        this.sourceType = sourceType;
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public Class<?> getTargetType() {
        return String.class;
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        String result = value.toString();
        if (result != null && result.length() > DataTypeManagerService.MAX_STRING_LENGTH) {
            return result.substring(0, DataTypeManagerService.MAX_STRING_LENGTH);
        }
        return result;
    }
}

