/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;

public class BigIntegerToBigDecimalTransform
extends Transform {
    public BigIntegerToBigDecimalTransform(DataTypeManagerService dataTypeManager) {
        super(dataTypeManager);
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        return new BigDecimal((BigInteger)value, 0);
    }

    @Override
    public Class<?> getSourceType() {
        return DataTypeManagerService.DefaultDataTypes.BIG_INTEGER.getTypeClass();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL.getTypeClass();
    }
}

