/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.io.IOException;
import java.sql.SQLException;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class BlobToBinaryTransform
extends Transform {
    public BlobToBinaryTransform(DataTypeManagerService dataTypeManager) {
        super(dataTypeManager);
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        BlobType source = (BlobType)value;
        try {
            byte[] bytes = ObjectConverterUtil.convertToByteArray(source.getBinaryStream(), DataTypeManagerService.MAX_VARBINARY_BYTES, true);
            return new BinaryType(bytes);
        }
        catch (SQLException e) {
            throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID10080, this.getSourceType().getName(), this.getTargetType().getName()));
        }
        catch (IOException e) {
            throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID10080, this.getSourceType().getName(), this.getTargetType().getName()));
        }
    }

    @Override
    public boolean isExplicit() {
        return true;
    }

    @Override
    public Class<?> getSourceType() {
        return DataTypeManagerService.DefaultDataTypes.BLOB.getTypeClass();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManagerService.DefaultDataTypes.VARBINARY.getTypeClass();
    }
}

