/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;

public class BooleanToNumberTransform
extends Transform {
    private Object trueVal;
    private Object falseVal;
    private Class<?> targetType;

    public BooleanToNumberTransform(DataTypeManagerService dataTypeManager, Object trueVal, Object falseVal) {
        super(dataTypeManager);
        this.trueVal = trueVal;
        this.falseVal = falseVal;
        this.targetType = trueVal.getClass();
    }

    public Class getSourceType() {
        return DataTypeManagerService.DefaultDataTypes.BOOLEAN.getTypeClass();
    }

    public Class getTargetType() {
        return this.targetType;
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        return value.equals(Boolean.TRUE) ? this.trueVal : this.falseVal;
    }
}

