/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.SQLException;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.basic.AnyToStringTransform;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class ClobToStringTransform
extends AnyToStringTransform {
    public ClobToStringTransform(DataTypeManagerService dataTypeManager) {
        super(dataTypeManager, DataTypeManagerService.DefaultDataTypes.CLOB.getTypeClass());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object transformDirect(Object value) throws Exception {
        String string;
        ClobType source = (ClobType)value;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(source.getCharacterStream());
            StringBuffer contents = new StringBuffer();
            int chr = reader.read();
            while (true) {
                if (chr == -1 || contents.length() >= DataTypeManagerService.MAX_STRING_LENGTH) {
                    string = contents.toString();
                    if (reader == null) return string;
                    break;
                }
                contents.append((char)chr);
                chr = reader.read();
            }
        }
        catch (SQLException e) {
            try {
                throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID10080, this.getSourceType().getName(), this.getTargetType().getName()));
                catch (IOException e2) {
                    throw new TeiidClientException(e2, Messages.gs(Messages.TEIID.TEIID10080, this.getSourceType().getName(), this.getTargetType().getName()));
                }
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            reader.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

