/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.math.BigDecimal;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;

public class FloatingNumberToBigDecimalTransform
extends Transform {
    private Class<?> sourceType;

    public FloatingNumberToBigDecimalTransform(DataTypeManagerService dataTypeManager, Class<?> sourceType) {
        super(dataTypeManager);
        this.sourceType = sourceType;
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        BigDecimal result = BigDecimal.valueOf(((Number)value).doubleValue());
        result = result.setScale(Math.max(result.scale(), (value instanceof Double ? 16 : 8) - result.precision()));
        return result;
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL.getTypeClass();
    }
}

