/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;

public class NumberToBooleanTransform
extends Transform {
    private Comparable falseVal;
    private Class<?> sourceType;

    public NumberToBooleanTransform(DataTypeManagerService dataTypeManager, Comparable falseVal) {
        super(dataTypeManager);
        this.falseVal = falseVal;
        this.sourceType = falseVal.getClass();
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManagerService.DefaultDataTypes.BOOLEAN.getTypeClass();
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        if (this.falseVal.compareTo(value) == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

