/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;

public class NumberToByteTransform
extends Transform {
    private Class<?> sourceType;

    public NumberToByteTransform(DataTypeManagerService dataTypeManager, Class<?> sourceType) {
        super(dataTypeManager);
        this.sourceType = sourceType;
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        this.checkValueRange(value, (byte)-128, (byte)127);
        return ((Number)value).byteValue();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManagerService.DefaultDataTypes.BYTE.getTypeClass();
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

